<?php if( app()->getLocale() == 'en' ): ?>
     
<?php $__env->startSection('title', $seo?->meta_title_en); ?>
<?php $__env->startSection("description",$seo?->meta_description_en); ?>
<?php $__env->startSection("canonical",$seo?->canonical_en); ?>
<?php else: ?>
<?php $__env->startSection('title', $seo?->meta_title_ar); ?>
<?php $__env->startSection("description",$seo?->meta_description_ar); ?>
<?php $__env->startSection("canonical",$seo?->canonical_ar); ?>


<?php endif; ?>

<?php $__env->startSection("css"); ?> 
<style>
    .form-select option {
    font-family: Arial, sans-serif;
    font-size: 1.5rem; /* تعديل حجم النجوم */
    color: #ffc107; /* لون النجوم */
}
#rating{
    color: #ffc107;
}
.star-rating {
    font-size: 2rem;
    color: #ccc; /* لون النجوم غير المختارة */
    cursor: pointer;
}



/* تصميم النجوم */
.star-rating {
    font-size: 1.8rem;
    color: #ccc; /* لون النجوم غير المختارة */
}

.star.selected {
    color: #ffc107; /* لون النجوم المختارة */
}

/* تأثير عند التمرير على السلايدر */
.carousel-item {
    transition: transform 0.8s ease-in-out, opacity 0.8s ease-in-out;
}

.review-card {
    background-color: #f8f9fa; /* لون خلفية الكارت */
    border-radius: 15px; /* الزوايا المنحنية */
}

.review-card .card-title {
    font-size: 1.3rem;
    font-weight: bold;
}

.review-card .review-text {
    font-style: italic;
    font-size: 1.1rem;
    color: #343a40;
}

.carousel-control-prev-icon,
.carousel-control-next-icon {
    background-color: #343a40; /* لون أزرار السلايدر */
    border-radius: 50%;
    width: 40px;
    height: 40px;
}

.carousel-control-prev-icon:hover,
.carousel-control-next-icon:hover {
    background-color: #ffc107; /* لون أزرار السلايدر عند التمرير */
}

.card {
    box-shadow: 0 10px 15px rgba(0, 0, 0, 0.1); /* ظل جميل */
}

/* تأثير على الكارت عند العرض */
.carousel-item.active {
    transform: scale(1.05);
}

.carousel-item-next,
.carousel-item-prev {
    opacity: 0.7;
}
.selected-starts{
    color: #ffc107 !important; 
}


.description h6{
    width: 32%;
}
.red-color-single{
    color:red;
}
@media(max-width:752px)
{
    .axil-breadcrumb li a{
        font-size: 14px !important;
    }
}
.description-text{
            background-color: #ddcdda !important;
            color:#000;
}
.installment-contaienr{
        padding: 2rem;
    background: #ddcdda;
}
.price.old-price{
            color:red !important;
                font-size: 17px;
                    text-decoration: line-through;
        }
        .single-product-thumbnail-wrap .label-block .product-badget{
            background-color:#670756 !important ;
        }
        
        .span-quentity-none{
            padding-right:6rem;
        }
        @media(max-width:752px)
{
    .span-quentity-none
    {
        padding-right:0.5rem;
    }
}
        

</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
<?php
$breadcrumb_schema = [ ['name'=>__('lang.Home'),'url'=>url('/')],['name'=> __('lang.products'),'url'=>route('product.index')],
                        ['name'=>app()->getLocale() == 'en'?$product->name_en:$product->name_ar,'url'=>request()->fullUrl()]];
?>
<?php echo $__env->make("components.breadcrumb", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Product Quick View Modal Start -->
<div class="modal fade quick-view-product" id="quick-view-modal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="far fa-times"></i>
                </button>
            </div>
            <div class="modal-body">
                <div class="single-product-thumb">
                    <div class="row">
                        <div class="col-lg-7 mb--40">
                            <div class="row">
                                <div class="col-lg-10 order-lg-2">
                                    <div
                                        class="single-product-thumbnail product-large-thumbnail axil-product thumbnail-badge zoom-gallery">
                                        <div class="thumbnail">
                                            <img id="product-image"
                                                 src="<?php echo e(asset('web/assets/images/product/product-big-01.png')); ?>"
                                                 alt="Product Images">
                                            <div class="label-block label-right">
                                                <div class="product-badget" id="dicount_text">0 % OFF</div>
                                            </div>
                                            <div class="product-quick-view position-view">
                                                <a id="popup_image"
                                                   href="<?php echo e(asset('web/assets/images/product/product-big-01.png')); ?>"
                                                   class="popup-zoom">
                                                    <i class="far fa-search-plus"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2 order-lg-1" id="sadsads">
                                    <div class="product-small-thumb small-thumb-wrapper" id="show_images">

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-5 mb--40">
                            <div class="single-product-content">
                                <div class="inner">
                                    <div class="product-rating">
                                        <div class="star-rating" id="div_reviews">
                                            <i class="fal fa-star" id="box_reviews"></i>
                                            <i class="fal fa-star" id="box_reviews"></i>
                                            <i class="fal fa-star" id="box_reviews"></i>
                                            <i class="fal fa-star" id="box_reviews"></i>
                                            <i class="fal fa-star" id="box_reviews"></i>
                                        </div>
                                        <div class="review-link">
                                            <a>(<span id="count_reviews"></span> <?php echo e(__('lang.customer_reviews')); ?>)</a>
                                        </div>
                                        <div class="review-add">
                                            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#reviewModal">
                                                أضف تقييمك
                                            </button>
                                        </div>

                                    </div>
                                    <h3 id="product-title" class="product-title">Serif Coffee Table</h3>
                                    <span id="product-price" class="price-amount">
                                            $255.00
                                        </span>
                                    
                                    
                                    
                                    
                                    
                                    <div class="description row" id="show_descriptions">
                                        <div class="d-flex align-items-center col-sm-12" id="show_description"
                                             style="margin-bottom: 3px">
                                            <h6 class="mb-0">
                                                title_en
                                            </h6>
                                            <div class="box-container d-flex flex-wrap mx-3">
                                                <span class="description-text">
                                                    option_ar
                                                </span>
                                                <span class="description-text">
                                                   other_option_en
                                                </span>

                                            </div>
                                        </div>
                                    </div>

                                    <div class="product-variation">
                                        <h6 class="title"><?php echo e(__('lang.Colors')); ?>:</h6>
                                        <!-- mona color radio button -->
                                        <div class="box-color d-flex" id="products_colors">
                                             <?php $__currentLoopData = $color_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $colors): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="container-color-box d-flex mb-4">
                                            
                                            <input name="color" class="color" <?php if($loop->first): ?> checked <?php endif; ?> type="radio" id="color-<?php echo e($colors['color_id']); ?>"
                                            value="<?php echo e($colors['color_id']); ?>" data-image="<?php echo e($colors['image_url']); ?>" data-color="<?php echo e($colors['color']); ?>" data-color-id="<?php echo e($colors['color_id']); ?>"/>
                                            <label for="color-<?php echo e($colors['color_id']); ?>"></label>

                                            
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <!-- end -->
                                    </div>

                                    <!-- Start Product Action Wrapper  -->
                                    <div class="product-action-wrapper d-flex-center">
                                        <!-- Start Product Action  -->
                                        <ul class="product-action d-flex-center mb--0">
                                            <div class="pro-qty mr--20">
                                                <span class="dec qtybtn">-</span>
                                                <input type="text" name="quantity" id="out_quantity_out" value="1">
                                                <span class="inc qtybtn">+</span>
                                            </div>
                                            <li class="add-to-cart">
                                                <form action="<?php echo e(route('cart.store')); ?>" method="POST">
                                                    <?php echo csrf_field(); ?>

                                                    <input type="hidden" name="color" id="colorForm_colorForm">

                                                    <input type="hidden" name="quantity" id="in_quantity_in">

                                                    <input type="hidden" name="product_id" id="product_iddd">

                                                    <button type="submit" id="cart-btn" class="add-product">
                                                        <?php echo e(__('lang.add-cart')); ?>

                                                    </button>
                                                </form>
                                            </li>
                                            <li class="wishlist" id="add_fav__add_fav" style="cursor: pointer">
                                                <a>
                                                    <button class="axil-btn wishlist-btn">
                                                        <i class="bi bi-heart-fill red-color " id="heart"></i>
                                                    </button>
                                                </a>
                                            </li>
                                        </ul>
                                        <!-- End Product Action  -->

                                    </div>
                                    <!-- End Product Action Wrapper  -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Product Quick View Modal End -->

<!-- Start Shop Area  -->
<div class="axil-single-product-area">
    <div class="single-product-thumb axil-section-gap pb--20 pb_sm--0">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 mb--40">
                    <div class="row">
                        <div class="col-lg-10 order-lg-2">
                            <div class="single-product-thumbnail-wrap zoom-gallery">
                                <div class="product-large-thumbnail single-product-thumbnail axil-product">
                                    <?php if(count($images) == 0): ?>
                                    <div class="thumbnail">
                                        <a href="<?php echo e(Request::root() . '/dashboard/images/' . $product->image); ?>" class="popup-zoom">
                                            <img src="<?php echo e(Request::root() . '/dashboard/images/' . $product->image); ?>" alt="Product Images">
                                        </a>
                                    </div>

                                    <?php else: ?>
                                    <div class="thumbnail">
                                        <a href="<?php echo e(Request::root() . '/dashboard/images/' . $product->image); ?>" class="popup-zoom">
                                            <img src="<?php echo e(Request::root() . '/dashboard/images/' . $product->image); ?>" class="popup-zoom" alt="Product Images">
                                        </a>
                                    </div>
                                    <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="thumbnail">
                                        <a href="<?php echo e(Request::root() . '/dashboard/images/' . $image->image); ?> " class="popup-zoom  ">
                                            <img  id="color-img-<?php echo e($image->color_id); ?>" src="<?php echo e(Request::root() . '/dashboard/images/' . $image->image); ?>" class="popup-zoom img-product-show" alt="Product Images">
                                        </a>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </div>
                                <?php if($product->discount > 0): ?>
                                <div class="label-block">
                                    <div class="product-badget"><?php echo e(number_format($product->discount )); ?>% OFF</div>
                                </div>
                                <?php endif; ?>

                            </div>
                            <div class="product-variations-wrapper mb-5 d-none">

                                <!-- Start Product Variation  -->
                                <div class="product-variation">
                                    <!--<h6 class="title fw-bold"><?php echo e(__('lang.select_Colors')); ?>:</h6>-->
                                    <!-- mona color radio button -->
                                    <div class="box-color d-flex">
                                        <?php $__currentLoopData = $product->colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $colors): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="container-color-box d-flex mb-4">
                                            
                                            <input name="color" class="color" <?php if($loop->first): ?> checked <?php endif; ?> type="radio" id="color-<?php echo e($colors->id); ?>"
                                            value="<?php echo e($colors->id); ?>" data-color="<?php echo e($colors->color); ?>"/>
                                            <label for="color-<?php echo e($colors->id); ?>"></label>

                                            <!-- <label class="color-name d-flex justify-content-center align-items-center mx-2 py-1 px-3"
                                             for="color-<?php echo e($colors->id); ?>">
                                                <?php echo e($colors->color); ?>

                                            </label> -->
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                    <!-- end -->
                                    
                                </div>

                                <!-- End Product Variation  -->
                            </div>
                            <!-- Start Product Action Wrapper  -->
                            <div class="product-action-wrapper d-flex-center mt-5">
                                
                                <!-- Start Quentity Action  -->
                                <div class="pro-qty mr--20">
                                    <span class="dec qtybtn">-</span>
                                    <input type="text" name="quantity" id="out_quantity" value="1">
                                    <span class="inc qtybtn">+</span>
                                </div>
                                <!-- End Quentity Action  -->

                                <!-- Start Product Action  -->
                                <ul class="product-action d-flex-center mb--0">
                                    <li class="add-to-cart">
                                        <form action="<?php echo e(route('cart.store')); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="color" id="colorForm">

                                            <input type="hidden" name="quantity" id="in_quantity">

                                            <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                                             <?php if($product->quantity > 0): ?>
                                            <button type="submit" id="cart-btn" class="add-product">
                                                <?php echo e(__('lang.add-cart')); ?>

                                            </button>
                                            <?php else: ?>
                                             <!--<sapn class="text-danger d-block text-center" style="font-weight: 500; margin-bottom: 22px;">الكمية نفذت</sapn>-->
                                             <button type="submit" id="cart-btn" class="add-product" disabled>
                                                <?php echo e(__('lang.add-cart')); ?>

                                            </button>
                                            <?php endif; ?>
                                            
                                        </form>
                                    </li>
                                    <li class="wishlist" id="add_favadd_fav" style="cursor: pointer" data-id="<?php echo e($product->id); ?>">
                                        <a>
                                            <?php $__empty_1 = true; $__currentLoopData = $product->favorite; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $favorites): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <?php if(\Illuminate\Support\Facades\Auth::user()): ?>
                                            <?php if($favorites->user_id == \Illuminate\Support\Facades\Auth::user()->id): ?>
                                            <button class="axil-btn wishlist-btn">
                                                <i class="bi bi-heart-fill red-color red-color-single" id="heart"></i>
                                            </button>
                                            <?php break; ?>
                                            <?php else: ?>
                                            <button class="axil-btn wishlist-btn">
                                                <i class="bi bi-heart-fill" id="heart"></i>
                                            </button>
                                            <?php break; ?>
                                            <?php endif; ?>
                                            <?php break; ?>
                                            <?php else: ?>
                                            <button class="axil-btn wishlist-btn">
                                                <i class="bi bi-heart-fill" id="heart"></i>
                                            </button>
                                            <?php break; ?>
                                            <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <button class="axil-btn wishlist-btn">
                                                <i class="bi bi-heart-fill" id="heart"></i>
                                            </button>
                                            <?php endif; ?>
                                        </a>
                                        
                                        
                                        
                                        
                                        
                                        
                                        
                                        
                                        
                                </ul>
                                    
                                   
                                <!-- End Product Action  -->
                            </div>
                            
                            <?php if($product->quantity <= 0): ?>
                            <sapn class="text-danger d-block text-center " style="font-weight: 500;">الكمية نفذت</sapn>
                            <?php endif; ?>
                            
                              <div class="container mt-5 border-start border-danger border-4 installment-contaienr ">
                                  
                                  <a class="title fw-bold " href="<?php echo e(route('installment')); ?>"><?php echo e(__('lang.over_36_months')); ?></a></div>
                            <!-- End Product Action Wrapper  -->
                        </div>
                        <div class="col-lg-2 order-lg-1">
                            <div class="product-small-thumb small-thumb-wrapper small-thumb-style-two">
                                <?php if(count($images) == 0): ?>
                                <div class="thumbnail">
                                    <a href="<?php echo e(Request::root() . '/dashboard/images/' . $product->image); ?>" class="popup-zoom">
                                        <img src="<?php echo e(Request::root() . '/dashboard/images/' . $product->image); ?>" alt="Product Images">
                                    </a>
                                </div>

                                <?php else: ?>
                                <div class="small-thumb-img ">
                                    <img src="<?php echo e(Request::root() . '/dashboard/images/' . $product->image); ?>" class="popup-zoom" alt="Product Images">
                                </div>
                                <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="small-thumb-img ">
                                    <img src="<?php echo e(Request::root() . '/dashboard/images/' . $image->image); ?>" class="popup-zoom" alt="Product Images">
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 mb--40">
                    <div class="single-product-content">
                        <div class="inner">
                            <h1 class="product-title h2">
                                <?php if( app()->getLocale() == 'en' ): ?>
                                <?php echo e($product->name_en); ?>

                                <?php elseif( app()->getLocale() == 'ar' ): ?>
                                <?php echo e($product->name_ar); ?>

                                <?php endif; ?>
                            </h1>
                            <span class="price-amount">
                                 <?php if($product->discount > 0): ?>
                                <span class="price old-price"> <?php echo e(number_format($product->price)); ?> 
                                
                                  <i class="sicon-sar"></i>
                                
                                </span>
                                <?php endif; ?>
                                
                                <?php echo e(number_format(($product->price - ($product->price * $product->discount / 100)) + (($tax_tax / 100) * $product->price))); ?>

                                 <i class="sicon-sar"></i>
                                   
                                 
                                
                            <span class="text-tax"><?php echo e(__('lang.tax_pro')); ?></span>
                            </span>
                            <div class="product-rating">
                                <div class="star-rating">
                                    
                                    
                                    
                                    
                                    
                                    
                                    
                                    
                                    
                                    
                                    
                                    <form id="form_review">
                                        <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                                        <div class="star-rating" id="post_review">
                                            <div class="star-rating__wrap">
                                                <?php $__empty_1 = true; $__currentLoopData = $product->reviews2; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reviews): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <?php if(auth()->user()): ?>
                                                <?php if($reviews->user_id == auth()->user()->id): ?>
                                                <?php switch($reviews->rate):
                                                case (1.00): ?>
                                                <input class="star-rating__input" id="star-rating-5" type="radio" name="rating" value="5">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-5" title="5 out of 5 stars"></label>
                                                <input class="star-rating__input" id="star-rating-4" type="radio" name="rating" value="4">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-4" title="4 out of 5 stars"></label>
                                                <input class="star-rating__input" id="star-rating-3" type="radio" name="rating" value="3">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-3" title="3 out of 5 stars"></label>
                                                <input class="star-rating__input" id="star-rating-2" type="radio" name="rating" value="2">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-2" title="2 out of 5 stars"></label>
                                                <input class="star-rating__input" id="star-rating-1" type="radio" name="rating" value="1">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-1" title="1 out of 5 stars" style="color: rgb(255, 234, 0)"></label>
                                                <?php break; ?>
                                                <?php case (2.00): ?>
                                                <input class="star-rating__input" id="star-rating-5" type="radio" name="rating" value="5">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-5" title="5 out of 5 stars"></label>
                                                <input class="star-rating__input" id="star-rating-4" type="radio" name="rating" value="4">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-4" title="4 out of 5 stars"></label>
                                                <input class="star-rating__input" id="star-rating-3" type="radio" name="rating" value="3">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-3" title="3 out of 5 stars"></label>
                                                <input class="star-rating__input" id="star-rating-2" type="radio" name="rating" value="2">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-2" title="2 out of 5 stars" style="color: rgb(255, 234, 0)"></label>
                                                <input class="star-rating__input" id="star-rating-1" type="radio" name="rating" value="1">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-1" title="1 out of 5 stars" style="color: rgb(255, 234, 0)"></label>
                                                <?php break; ?>
                                                <?php case (3.00): ?>
                                                <input class="star-rating__input" id="star-rating-5" type="radio" name="rating" value="5">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-5" title="5 out of 5 stars"></label>
                                                <input class="star-rating__input" id="star-rating-4" type="radio" name="rating" value="4">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-4" title="4 out of 5 stars"></label>
                                                <input class="star-rating__input" id="star-rating-3" type="radio" name="rating" value="3">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-3" title="3 out of 5 stars" style="color: rgb(255, 234, 0)"></label>
                                                <input class="star-rating__input" id="star-rating-2" type="radio" name="rating" value="2">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-2" title="2 out of 5 stars" style="color: rgb(255, 234, 0)"></label>
                                                <input class="star-rating__input" id="star-rating-1" type="radio" name="rating" value="1">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-1" title="1 out of 5 stars" style="color: rgb(255, 234, 0)"></label>
                                                <?php break; ?>
                                                <?php case (4.00): ?>
                                                <input class="star-rating__input" id="star-rating-5" type="radio" name="rating" value="5">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-5" title="5 out of 5 stars"></label>
                                                <input class="star-rating__input" id="star-rating-4" type="radio" name="rating" value="4">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-4" title="4 out of 5 stars" style="color: rgb(255, 234, 0)"></label>
                                                <input class="star-rating__input" id="star-rating-3" type="radio" name="rating" value="3">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-3" title="3 out of 5 stars" style="color: rgb(255, 234, 0)"></label>
                                                <input class="star-rating__input" id="star-rating-2" type="radio" name="rating" value="2">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-2" title="2 out of 5 stars" style="color: rgb(255, 234, 0)"></label>
                                                <input class="star-rating__input" id="star-rating-1" type="radio" name="rating" value="1">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-1" title="1 out of 5 stars" style="color: rgb(255, 234, 0)"></label>
                                                <?php break; ?>
                                                <?php case (5.00): ?>
                                                <input class="star-rating__input" id="star-rating-5" type="radio" name="rating" value="5">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-5" title="5 out of 5 stars" style="color: rgb(255, 234, 0)"></label>
                                                <input class="star-rating__input" id="star-rating-4" type="radio" name="rating" value="4">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-4" title="4 out of 5 stars" style="color: rgb(255, 234, 0)"></label>
                                                <input class="star-rating__input" id="star-rating-3" type="radio" name="rating" value="3">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-3" title="3 out of 5 stars" style="color: rgb(255, 234, 0)"></label>
                                                <input class="star-rating__input" id="star-rating-2" type="radio" name="rating" value="2">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-2" title="2 out of 5 stars" style="color: rgb(255, 234, 0)"></label>
                                                <input class="star-rating__input" id="star-rating-1" type="radio" name="rating" value="1">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-1" title="1 out of 5 stars" style="color: rgb(255, 234, 0)"></label>
                                                <?php break; ?>
                                                <?php default: ?>

                                                <?php endswitch; ?>
                                                <?php break; ?>


                                                <?php else: ?>
                                                <?php echo e(auth()->user()->id); ?>

                                                <input class="star-rating__input" id="star-rating-5" type="radio" name="rating" value="5">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-5" title="5 out of 5 stars"></label>
                                                <input class="star-rating__input" id="star-rating-4" type="radio" name="rating" value="4">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-4" title="4 out of 5 stars"></label>
                                                <input class="star-rating__input" id="star-rating-3" type="radio" name="rating" value="3">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-3" title="3 out of 5 stars"></label>
                                                <input class="star-rating__input" id="star-rating-2" type="radio" name="rating" value="2">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-2" title="2 out of 5 stars"></label>
                                                <input class="star-rating__input" id="star-rating-1" type="radio" name="rating" value="1">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-1" title="1 out of 5 stars"></label>
                                                <?php break; ?>
                                                <?php endif; ?>
                                                <?php break; ?>
                                                <?php else: ?>
                                                <input class="star-rating__input" id="star-rating-5" type="radio" name="rating" value="5">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-5" title="5 out of 5 stars"></label>
                                                <input class="star-rating__input" id="star-rating-4" type="radio" name="rating" value="4">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-4" title="4 out of 5 stars"></label>
                                                <input class="star-rating__input" id="star-rating-3" type="radio" name="rating" value="3">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-3" title="3 out of 5 stars"></label>
                                                <input class="star-rating__input" id="star-rating-2" type="radio" name="rating" value="2">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-2" title="2 out of 5 stars"></label>
                                                <input class="star-rating__input" id="star-rating-1" type="radio" name="rating" value="1">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-1" title="1 out of 5 stars"></label>
                                                <?php break; ?>
                                                <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <input class="star-rating__input" id="star-rating-5" type="radio" name="rating" value="5">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-5" title="5 out of 5 stars"></label>
                                                <input class="star-rating__input" id="star-rating-4" type="radio" name="rating" value="4">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-4" title="4 out of 5 stars"></label>
                                                <input class="star-rating__input" id="star-rating-3" type="radio" name="rating" value="3">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-3" title="3 out of 5 stars"></label>
                                                <input class="star-rating__input" id="star-rating-2" type="radio" name="rating" value="2">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-2" title="2 out of 5 stars"></label>
                                                <input class="star-rating__input" id="star-rating-1" type="radio" name="rating" value="1">
                                                <label class="star-rating__ico fa fa-star-o fa-lg" for="star-rating-1" title="1 out of 5 stars"></label>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="review-link">
                                    
                                    <a>(<span><?php echo e($product->reviews_count); ?></span> <?php echo e(__('lang.customer_reviews')); ?>

                                        )</a>
                                </div>
                                <div class="review-add mt-3 mx-2">
                                    <button type="button" class="btn btn-primary p-2" style="background:#670756" data-bs-toggle="modal" data-bs-target="#reviewModal">
                                        أضف تقييمك
                                    </button>
                                </div>
                            </div>
                            
                            
                            
                            
                            
                            <div class="description row">
                                <?php $__currentLoopData = $product->specifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specifications): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="d-flex align-items-center col-sm-12" style="margin-bottom: 3px">
                                        <h6 class="mb-0">
                                            <?php if(app()->getLocale() == 'en'): ?>
                                                <?php echo e($specifications->title_en); ?>

                                            <?php else: ?>
                                                <?php echo e($specifications->title_ar); ?>

                                            <?php endif; ?>
                                        </h6>
                                        <div class="box-container d-flex flex-wrap mx-3">
                                            <span class="description-text">
                                                <?php if(app()->getLocale() == 'en'): ?>
                                                    <?php echo e($specifications->option_en); ?>

                                                <?php else: ?>
                                                    <?php echo e($specifications->option_ar); ?>

                                                <?php endif; ?>
                                            </span>
                                            <?php if($specifications->other_option_en != null && $specifications->other_option_ar != null): ?>
                                                <span class="description-text">
                                                    <?php if(app()->getLocale() == 'en'): ?>
                                                        <?php echo e($specifications->other_option_en); ?>

                                                    <?php else: ?>
                                                        <?php echo e($specifications->other_option_en); ?>

                                                    <?php endif; ?>
                                                </span>
                                            <?php else: ?>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>













                            </div>


                            
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End .single-product-thumb -->
</div>
<!-- End Shop Area  -->


<!-- زر لفتح المودال -->


<!-- مودال إدخال التقييم -->
<div class="modal fade" id="reviewModal" tabindex="-1" aria-labelledby="reviewModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="reviewModalLabel">أضف تقييمك</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="<?php echo e(route('product.add-review')); ?>"  id="add-review-model-form" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">

                    <div class="mb-3">
                        <label for="rating" class="form-label">التقييم:</label>
                        <select name="rating" id="rating" class="form-select" required>
                            <option value="1">&#9733;</option> <!-- نجمة واحدة للتقييم 1 -->
                            <option value="2">&#9733;&#9733;</option> <!-- نجمتين للتقييم 2 -->
                            <option value="3">&#9733;&#9733;&#9733;</option> <!-- 3 نجوم للتقييم 3 -->
                            <option value="4">&#9733;&#9733;&#9733;&#9733;</option> <!-- 4 نجوم للتقييم 4 -->
                            <option value="5">&#9733;&#9733;&#9733;&#9733;&#9733;</option> <!-- 5 نجوم للتقييم 5 -->
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="review" class="form-label">التعليق:</label>
                        <textarea name="note" id="review" class="form-control" rows="4" required></textarea>
                    </div>

                    <button type="submit" style="background: #782569" class="btn btn-success w-100">إرسال التقييم</button>
                </form>
            </div>
        </div>
    </div>
</div>


<div class="container">
    <div class="row flex-column-reverse">

   
    <?php
        $number_reviewer=0;
        $number_start=0;

    ?>


<div id="reviewCarousel" class="carousel slide" data-bs-ride="carousel">
    <div class="carousel-inner">
        <?php $__currentLoopData = $product->reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
           $number_reviewer+=1;
        ?>
        <div class="carousel-item <?php echo e($loop->first ? 'active' : ''); ?>">
            <div class="card review-card p-4 shadow border-0">
                <div class="card-body text-center">
                    <div class="review-header mb-3">
                        <h5 class="card-title"><?php echo e($review->user->user_name); ?></h5>
                        <div class="star-rating mb-2">
                            <?php for($i = 1; $i <= 5; $i++): ?>
                                <?php if($i <= $review->rate): ?>
                                    <span class="star selected">&#9733;</span>
                                    <?php
                                      $number_start+=1;  
                                    ?>
                                <?php else: ?>
                                    <span class="star">&#9733;</span>
                                <?php endif; ?>
                            <?php endfor; ?>
                        </div>
                    </div>
                    <p class="card-text review-text">"<?php echo e($review->note); ?>"</p>
                     <?php if($review->created_at): ?>
    <small class="text-muted">تاريخ التقييم: <?php echo e($review->created_at->format('d M Y')); ?></small>
<?php else: ?>
    <small class="text-muted">تاريخ التقييم غير متوفر</small>
<?php endif; ?>

                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
 <?php if($number_reviewer !=0): ?>
    <button class="carousel-control-prev" type="button" data-bs-target="#reviewCarousel" data-bs-slide="prev">
        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
        <span class="visually-hidden">السابق</span>
    </button>
    <button class="carousel-control-next" type="button" data-bs-target="#reviewCarousel" data-bs-slide="next">
        <span class="carousel-control-next-icon" aria-hidden="true"></span>
        <span class="visually-hidden">التالي</span>
    </button>
    <?php endif; ?>
</div>
<?php if($number_reviewer !=0): ?>

<div class="container-title-start">
    <h3 style="color:#782569">

    مراجعات العملاء
    <?php if($number_reviewer !=0): ?>
    <?php for($i = 1; $i<=5; $i++): ?>
    <?php if( $number_start/$number_reviewer >= $i): ?>
    <span class="star selected">&#9733;</span>
    <?php else: ?>
    <span class="star">&#9733;</span>
    <?php endif; ?>
    <?php endfor; ?>
    <?php else: ?>
    <?php for($i = 1; $i<=5; $i++): ?>
    <span class="star">&#9733;</span>
    <?php endfor; ?>
    <?php endif; ?>
    </h3>
   
</div>
<?php endif; ?>


</div>
</div>











<!-- Start Recently Viewed Product Area  -->
<div class="axil-product-area axil-section-gap pb--50 pb_sm--30">
    <div class="container">
        <div class="section-title-wrapper">
            
            <h2 class="title"><?php echo e(__('lang.viewed_Products')); ?></h2>
        </div>
        <div class="recent-product-activation slick-layout-wrapper--15 axil-slick-arrow arrow-top-slide">
            <?php $__currentLoopData = $products_s; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="slick-single-layout">
                <div class="axil-product">
                    <div class="thumbnail">
                        <a href="<?php echo e(route('product.show' , $key->id)); ?>">
                            <img src="<?php echo e(Request::root() . '/dashboard/images/' . $key->image); ?>" alt="<?php if( app()->getLocale() == 'en' ): ?> <?php echo e($key->name_en); ?> <?php elseif( app()->getLocale() == 'ar' ): ?> <?php echo e($key->name_ar); ?> <?php endif; ?>">
                        </a>
                        <?php if($key->discount > 0): ?>
                        <div class="label-block label-right">
                            <div class="product-badget"><?php echo e(number_format($key->discount , 1)); ?>% Off</div>
                        </div>
                        <?php endif; ?>
                        <div class="product-hover-action">
                            <ul class="cart-action">
                                <li class="quickview">
                                    <a href="#" data-bs-toggle="modal" class="eye-modal" data-id="<?php echo e($key->id); ?>" data-bs-target="#quick-view-modal">
                                        <i class="far fa-eye"></i>
                                    </a>
                                </li>
                                <li class="select-option">
                                    <button>
                                        <a href="<?php echo e(route('product.show' , $key->id )); ?>" style="color: white">
                                            <?php echo e(__('lang.Select_Option')); ?>

                                        </a>
                                    </button>
                                </li>
                                <li class="wishlist" id="add_fav" style="cursor: pointer" data-id="<?php echo e($key->id); ?>">
                                    <a>
                                        <?php $__empty_1 = true; $__currentLoopData = $key->favorite; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $favorites): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <?php if(\Illuminate\Support\Facades\Auth::user()): ?>
                                        <?php if($favorites->user_id == \Illuminate\Support\Facades\Auth::user()->id): ?>
                                        <i class="bi bi-heart-fill red-color" id="heart"></i>
                                        <?php break; ?>
                                        <?php else: ?>
                                        <i class="bi bi-heart-fill" id="heart"></i>
                                        <?php break; ?>
                                        <?php endif; ?>
                                        <?php break; ?>
                                        <?php else: ?>
                                        <i class="bi bi-heart-fill" id="heart"></i>
                                        <?php break; ?>
                                        <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <i class="bi bi-heart-fill" id="heart"></i>
                                        <?php endif; ?>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="product-content">
                        <div class="inner">
                            <h5 class="title"><a href="<?php echo e(route('product.show' , $key->id)); ?>">
                                    <?php if( app()->getLocale() == 'en' ): ?>
                                    <?php echo e($key->name_en); ?>

                                    <?php elseif( app()->getLocale() == 'ar' ): ?>
                                    <?php echo e($key->name_ar); ?>

                                    <?php endif; ?>
                                </a></h5>

                            <div class="product-price-variant">
                                <?php if($key->discount > 0): ?>
                                <span class="price old-price">
                                    <?php echo e(number_format( $key->price  + (($tax_tax/100) * $key->price) )); ?>

                                     <i class="sicon-sar"></i>
                                </span>
                                <span class="price current-price"><?php echo e(number_format(($key->price-($key->price*$key->discount/100))  + (($tax_tax/100) * $key->price) )); ?>

                                
                                     <i class="sicon-sar"></i>
                                
                                </span>
                                <?php else: ?>
                                <span class="price current-price">
                                    <?php echo e(number_format( $key->price  + (($tax_tax/100) * $key->price) )); ?>

                                        <i class="sicon-sar"></i>
                                </span>
                                <?php endif; ?>
                                
                                
                                
                                

                                
                                
                                
                                
                                
                                
                                
                                

                            </div>
                            <span class="text-tax"><?php echo e(__('lang.tax_pro')); ?></span>
                            <div class="color-variant-wrapper">
                                <ul class="color-variant">
                                    <?php $__currentLoopData = $key->colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $colors): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="mx-2 color-extra-01">
                                        <!-- <span class="color-name mx-2 py-1 px-3"> ${color}</span> -->
                                        <span style="background-color:<?php echo e($colors->color); ?>" class="color"></span>
                                    </li>
                                    
                                    
                                    
                                    
                                    
                                    
                                    
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="<?php echo e(asset('dashboard/assets/plugins/custom/datatables/datatables.bundle.js')); ?>"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).on('click', '#add_favadd_fav', function(e) {
        var id = $(this).data('id');
        if ('<?php echo e(\Illuminate\Support\Facades\Auth::user()); ?>') {
            $(this).children('a').children('button').children('#heart').toggleClass("red-color-single");
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'POST',
                url: '<?php echo e(route("product.add_fav")); ?>',
                data: {
                    'user_id': '<?php echo e(\Illuminate\Support\Facades\Auth::id()); ?>',
                    'product_id': id,
                },
                success: function(response) {
                    
                    
                    if(response=="add Done")
                    {
                        Swal.fire({
                                position: 'top-end',
                                title: '<?php echo e(__('lang.add_fav')); ?>',
                                showConfirmButton: false,
                                icon: 'success',
                                timer: 3000
                            });
                    }
                    else
                    {
                        Swal.fire({
                                position: 'top-end',
                                title: '<?php echo e(__('lang.delete_fav')); ?>',
                                icon: 'success',
                                showConfirmButton: false,
                                timer: 3000
                            });
                    }
                    
                    
                }
            });
        } else {
            window.location.href = "<?php echo e(route('login')); ?>";
        }

    });
    $(document).on('click', '#add_fav', function(e) {
        var id = $(this).data('id');
        if ('<?php echo e(\Illuminate\Support\Facades\Auth::user()); ?>') {
            $(this).children('a').children('.fa-heart').toggleClass("red-color");
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'POST',
                url: '<?php echo e(route("product.add_fav")); ?>',
                data: {
                    'user_id': '<?php echo e(\Illuminate\Support\Facades\Auth::id()); ?>',
                    'product_id': id,
                },
                success: function(response) {}
            });
        } else {
            window.location.href = "<?php echo e(route('login')); ?>";
        }
    });
</script>
<script>
    $(".qtybtn").on("click", function () {
        var $button = $(this);
        var oldValue = $button.parent().find("input").val();
        if ($button.hasClass("inc")) {
            var newVal = parseFloat(oldValue) + 1;
        } else {
            // Don't allow decrementing below zero
            if (oldValue > 1) {
                var newVal = parseFloat(oldValue) - 1;
            } else {
                newVal = 1;
            }
        }
        $button.parent().find("input").val(newVal);
    });

    $(document).on('click', '#cart-btn', function (e) {

        var quantity = $('#out_quantity').val();

        $('#in_quantity').attr('value', quantity);

        var color = $('input[name="color"]:checked').data('color');

        $('#colorForm').val(color);

    });
</script>
<script>
    function post_review() {
        $(document).off("click", "#post_review").on("click", "#post_review", function(e) {
            // e.preventDefault();
            let formdata = new FormData($('#form_review')[0]);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'post',
                url: "<?php echo e(route('product.add-review')); ?>",
                data: formdata,
                contentType: false,
                processData: false,
                success: function(response) {
                    console.log('done');
                }
            });
        });
    };
    post_review();

    // change color of radio buttons
    $(".box-color .container-color-box").each(function() {
        var curent_color = $(this).children('input').attr('data-color');
        $(this).children('label').css('--myVar', curent_color);
    });


    // Get Color
    $('.color').change(function(e) {

        color = $(this).data('color');
         var imageUrl = "<?php echo e(Request::root()); ?>/dashboard/images/" + $(this).data('image');
       
         console.log('Selected image URL: xxxxxxxxx' + imageUrl);
        var img="color-img-"+$(this).data('color-id');
        $(".img-product-show").attr("src",imageUrl);

        console.log(color);

    })

    $(document).on('click', '#cart-btn', function(e) {
        color = $('input[name="color"]:checked').data('color');
        // color = $('input[name="color"]:checked').val();

        $('#colorForm').val(color);

    })
    // $(".qtybtn").on("click", function() {
    //     var $button = $(this);
    //     var oldValue = $button.parent().find("input").val();
    //     if ($button.hasClass("inc")) {
    //         var newVal = parseFloat(oldValue) + 1;
    //     } else {
    //         // Don't allow decrementing below zero
    //         if (oldValue > 0) {
    //             var newVal = parseFloat(oldValue) - 1;
    //         } else {
    //             newVal = 0;
    //         }
    //     }
    //     $button.parent().find("input").val(newVal);
    // });
</script>

<script>
    var lang = '<?php echo e(\Illuminate\Support\Facades\App::getLocale()); ?>';
    $('.eye-modal').click(function () {
        var id = $(this).data('id');
        $.ajax({
            type: 'get',
            url: "<?php echo e(url('products/getData')); ?>/" + id,
            success: function (data) {
                console.log(data);
                $('#out_quantity_out').val(1);
                $('#product_iddd').attr('value', data.product.id);
                $('#add_fav__add_fav').attr('data-id', data.product.id);
                var product_qty = $('#product_qty').val();
                $('#in_quantity').attr('value', product_qty);
                $('#product-image').attr('src', '')
                $('#product-image').attr('src', '/dashboard/images/' + data.product.image)
                $('#product-title').text('')
                if (lang == 'en') {
                    $('#product-title').text(data.product.name_en);
                } else {
                    $('#product-title').text(data.product.name_ar);
                }
                $('#product-price').text('')
                $('#product-price').text(data.product.price)
                $('#description').text('')
                // if (lang == 'en') {
                //     $('#description').text(data.product.des_en);
                // } else {
                //     $('#description').text(data.product.des_ar);
                // }
                $('#popup_image').attr('href', '');
                $('#popup_image').attr('href', '/dashboard/images/' + data.product.image);
                $('#dicount_text').text('');
                if (data.product.discount > 0 ) {
                    $('#dicount_text').css('display' , 'inline-flex').text(data.product.discount + ' % OFF');
                } else {
                    $('#dicount_text').css('display' , 'none');
                }
                $('#count_reviews').text(data.product.reviews_count);
                const boxes = document.querySelectorAll('#show_img');
                boxes.forEach(box => {
                    box.remove();
                });
                data.product.imageable.forEach(myFunction);

                function myFunction(item) {
                    html(item.image);
                }

                const boxColors = document.querySelectorAll('#product_colors');
                boxColors.forEach(box => {
                    box.remove();
                });
                data.product.colors.forEach(myFunction2);
                console.log(data.product.colors);

                function myFunction2(item) {
                    html2(item);
                    $('input[name="color_input"]').attr('checked', 'checked');

                }


                const box_reviews = document.querySelectorAll('#box_reviews');
                box_reviews.forEach(box => {
                    box.remove();
                });

                if (data.product.reviews_sum_rate != null) {
                    for (var i = 1; i <= data.product.reviews_sum_rate / data.product.reviews_count; i++) {
                        const show_reviews = document.getElementById("div_reviews");
                        let reviews = `
                        <i class="fas fa-star" id="box_reviews"></i>
                        `;
                        show_reviews.insertAdjacentHTML("afterbegin", reviews);
                    }
                } else {
                    const show_reviews = document.getElementById("div_reviews");
                    let reviews = `
                                <i class="fal fa-star" id="box_reviews"></i>
                                <i class="fal fa-star" id="box_reviews"></i>
                                <i class="fal fa-star" id="box_reviews"></i>
                                <i class="fal fa-star" id="box_reviews"></i>
                                <i class="fal fa-star" id="box_reviews"></i>
                        `;
                    show_reviews.insertAdjacentHTML("afterbegin", reviews);
                }

                const show_description = document.querySelectorAll('#show_description');
                show_description.forEach(box => {
                    box.remove();
                });

                console.log(data.product.specifications);
                data.product.specifications.forEach(myFunction3);

                function myFunction3(item) {
                    html3(item);
                }

                if (data.product.favorite.length != 0) {
                    $('#add_fav__add_fav').children('a').children('button').children('.fa-heart').addClass("red-color-single");
                } else {
                    $('#add_fav__add_fav').children('a').children('button').children('.fa-heart').removeClass("red-color-single");
                }
                // $('#add_favadd_fav').attr('data-id', data.product.id);

            },
            error: function (data) {
                console.log('data')
            },

        });
    });

    function html(image) {
        const show_images = document.getElementById("show_images");
        let business = `
               <div class="small-thumb-img" id="show_img">
                    <img src="<?php echo e(Request::root() . '/dashboard/images/'); ?>${image}"
                        alt="thumb image">
                </div>`;
        show_images.insertAdjacentHTML("afterbegin", business);
    }

    function html2(color) {
        const show_color = document.getElementById("products_colors");
//             let cc = `
//             <!--                 <div class="container-color-box d-flex" id="product_colors">-->
// <!--                    <p style="color: black; margin: 5px"></p>-->
// <!--                    <input name="color" class="color color_input" type="radio" id="${color}"-->
//                             value="${color}" data-color="${color}"/>
// <!--                    <label-->
// <!--                        class="color-name d-flex justify-content-center align-items-center mx-2 py-1 px-3"-->
// <!--                        for="${color}">-->
// <!--                        ${color}-->
// <!--                    </label>-->
// <!--                </div>-->
// `;
//             let colors = `
//                 <li class="mx-2 color-extra-01" id="product_colors">
//                     <span style="background-color:${color}" class="color"></span>
//                 </li>`;
        let colors = `
                <div class="container-color-box d-flex mb-4" id="product_colors">
                    <input name="color_input" class="color" type="radio" id="color-${color.id}"
                        value="${color.id}" data-color="${color.color}"/>
                    <label for="color-${color.id}" style="--myVar:${color.color};"></label>
                </div>
                `;
        show_color.insertAdjacentHTML("afterbegin", colors);
    }

    function html3(description) {
        const show_descriptions = document.getElementById("show_descriptions");
        if (lang == 'ar') {
            if (description.other_option_ar != null) {
                var descriptions = `
                <div class="d-flex align-items-center col-sm-12" id="show_description" style="margin-bottom: 3px">
                    <h6 class="mb-0">
                    ${description.title_ar}
                    </h6>
                    <div class="box-container d-flex flex-wrap mx-3">
                        <span class="description-text">
                            ${description.option_ar}
                        </span>
                        <span class="description-text">
                            ${description.other_option_ar}
                        </span>
                    </div>
                </div>
                `;
            } else {
                var descriptions = `
                <div class="d-flex align-items-center col-sm-12" id="show_description" style="margin-bottom: 3px">
                    <h6 class="mb-0">
                    ${description.title_ar}
                    </h6>
                    <div class="box-container d-flex flex-wrap mx-3">
                        <span class="description-text">
                            ${description.option_ar}
                        </span>
                    </div>
                </div>
                `;
            }

        } else {
            if (description.other_option_en != null) {
                var descriptions = `
                <div class="d-flex align-items-center col-sm-12" id="show_description" style="margin-bottom: 3px">
                    <h6 class="mb-0">
                    ${description.title_en}
                    </h6>
                    <div class="box-container d-flex flex-wrap mx-3">
                        <span class="description-text">
                            ${description.option_en}
                        </span>
                        <span class="description-text">
                            ${description.other_option_en}
                        </span>
                    </div>
                </div>
                `;
            } else {
                var descriptions = `
                <div class="d-flex align-items-center col-sm-12" id="show_description" style="margin-bottom: 3px">
                    <h6 class="mb-0">
                    ${description.title_en}
                    </h6>
                    <div class="box-container d-flex flex-wrap mx-3">
                        <span class="description-text">
                            ${description.option_en}
                        </span>

                    </div>
                </div>
                `;
            }

        }

        show_descriptions.insertAdjacentHTML("afterbegin", descriptions);
    }


    // $(document).on('click', '#add_favadd_fav', function (e) {
    $('#add_fav__add_fav').click(function (e) {
        e.preventDefault();
        //     $(document).off("click", "#add_favadd_fav").on("click", "#add_favadd_fav", function (e) {
        var id = $(this).data('id');
        if ('<?php echo e(\Illuminate\Support\Facades\Auth::user()); ?>') {
            $(this).children('a').children('button').children('.fa-heart').toggleClass("red-color-single");
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'POST',
                url: '<?php echo e(route("product.add_fav")); ?>',
                data: {
                    'user_id': '<?php echo e(\Illuminate\Support\Facades\Auth::id()); ?>',
                    'product_id': id,
                },
                success: function (response) {
                }
            });
        } else {
            window.location.href = "<?php echo e(route('login')); ?>";
        }
    });

    $(document).on('click', '.add-product', function (e) {
        var quantity = $('#out_quantity_out').val();

        $('#in_quantity_in').val(quantity);

        var color = $('input[name="color_input"]:checked').data('color');


        $('#colorForm_colorForm').val(color);

    });

    $('#add-review-model-form').on('submit', function(event) {
        event.preventDefault();
        
        let formdata = new FormData($('#add-review-model-form')[0]);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'post',
                url: "<?php echo e(route('product.add-review')); ?>",
                data: formdata,
                contentType: false,
                processData: false,
                success: function(response) {
                    console.log('done');
                    Swal.fire({
                                position: 'top-end',
                                title:'تم حفظ التعليق شكرا لك',
                                showConfirmButton: false,
                                timer: 1500
                            })
                            $('#reviewModal').modal('hide');
                }
            });


    });
    
    
$(document).on("click", ".small-thumb-img img", function() {
    var src = $(this).attr("src");
    
    $(".img-product-show").attr("src",src);
    console.log("Image clicked with src:", src);
});
</script>


<?php
    $breadcrumbs = [
        ['name' => __('lang.Home'), 'url' => route('home')],
        ['name' =>  __('lang.Products'), 'url' => route('product.index')], // Removed {{ }} inside @php
        ['name' => app()->getLocale()=="ar"? $product->name_ar:$product->name_en, 'url' => request()->fullUrl()],
    ];
?>

<script type="application/ld+json">
{
  "@context": "https://schema.org/", 
  "@type": "BreadcrumbList", 
  "itemListElement": [
    <?php $__currentLoopData = $breadcrumbs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $breadcrumb): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    {
      "@type": "ListItem", 
      "position": <?php echo e($index + 1); ?>, 
      "name": "<?php echo e($breadcrumb['name']); ?>",
      "item": "<?php echo e($breadcrumb['url']); ?>"
    }<?php if(!$loop->last): ?>,<?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  ]
}
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cujzkrmy/public_html/newnetwork/project/resources/views/web/product/show_0.blade.php ENDPATH**/ ?>