<?php $__env->startSection('css'); ?>
    <link href="<?php echo e(asset('dashboard/assets/plugins/custom/datatables/datatables.bundle.css')); ?>" rel="stylesheet" type="text/css"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('main_title', __('lang.admins')); ?>
<?php $__env->startSection('header_title', __('lang.admins')); ?>
<?php $__env->startSection('subheader_title', __('lang.index')); ?>

<?php $__env->startSection('content'); ?>
    <div class="card mb-5 mb-xxl-8">
        <!--begin::Header-->
        <div class="card-header border-0 pt-6">
            <!--begin::Title-->
            <h3 class="card-title d-flex align-items-start flex-column">
                <span class="card-label fw-bolder fs-3 mb-1">
                    <?php echo e(__('lang.admins')); ?>

                </span>
                <span class="text-muted fw-bold fs-7">
                    <?php echo e(__('lang.sub_title_message', ['count' => $admins->count()])); ?>

                </span>
            </h3>
            <div class="card-toolbar">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Admins-Create')): ?>
                <div class="d-flex justify-content-end" data-kt-user-table-toolbar="base">
                    <a href="<?php echo e(route('admin.create')); ?>" type="button" class="btn btn-light-primary me-3" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end" data-kt-menu-flip="top-end">
                        <i class="fas fa-plus"></i>
                        <?php echo e(__('lang.admin_create')); ?>

                    </a>
                </div>
                <?php endif; ?>
                <!--end::Toolbar-->
            </div>
            <!--end::Title-->

        </div>
        <!--end::Header-->
        <!--begin::Body-->
        <div class="card-body" style="position: relative;">

            <?php if(session('success')): ?>
                <div class="alert alert-success">
                    <?php echo e(session('success')); ?>

                </div>
            <?php elseif(session('error')): ?>
                <div class="alert alert-danger">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>

            <div id="table-data">
                <?php echo $__env->make('dashboard.admins.table-data', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
        <!--end::Body-->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('dashboard/assets/plugins/custom/datatables/datatables.bundle.js')); ?>"></script>
    <script>
        var tabel = $("#kt_datatable_example_1").DataTable();
        $('#re').click(function (){
            $(".table-data").html(data);
        });

        $(document).on('click', '#status', function (e) {
            e.preventDefault();
            var id = $(this).data('id');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'post',
                url: '<?php echo e(url('/admin/status')); ?>/' + id,
                data: '',
                success: function (response) {
                    $.ajax({
                        url: "<?php echo e(route('admin.index')); ?>"
                    }).done(function (data) {
                        $("#table-data").html(data);
                    });
                }
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cujzkrmy/public_html/newnetwork/project/resources/views/dashboard/admins/index.blade.php ENDPATH**/ ?>