<div class="product-table-heading">
    <h1 class="color1 title mt-5 h4"><?php echo e(__('lang.your_cart')); ?></h1>

    <?php if($items->get()->count() > 0): ?>
        <form action="#" method="POST">
            <?php echo csrf_field(); ?>
            <button type="submit" class="cart-clear" style="background-color: transparent;">
                <?php echo e(__('lang.clear_cart')); ?> <i class="bi bi-cart-x" style="font-size: 21px; color: red;"></i>
            </button>
        </form>
    <?php endif; ?>
</div>

<!-- ✅ جدول ديسكتوب فقط -->
<div class="table-responsive d-none d-md-block">
    <table class="custom-cart-table">
        <thead>
            <tr>
                <th></th>
                <th><?php echo e(__('lang.product')); ?></th>
                <th></th>
                <th><?php echo e(__('lang.quantity')); ?></th>
                <th><?php echo e(__('lang.Colors')); ?></th>
                <th><?php echo e(__('lang.subtotal')); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php if($items->get()->count() > 0): ?>
                <?php $__currentLoopData = $items->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $colors_record = \App\Models\Colors::where('product_id', $item->product->id)
                            ->where('color', $item->color)
                            ->first();
                    ?>
                    <tr>
                        <td>
                            <form action="<?php echo e(route('cart.delete', ['id' => $item->id])); ?>">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="remove-wishlist" data-id="<?php echo e($item->id); ?>">
                                    <i class="fal fa-times"></i>
                                </button>
                            </form>
                        </td>
                        <td>
                            <a href="<?php echo e(route('product.show', ['id' => $item->product->id])); ?>">
                                <img src="<?php echo e(Request::root() . '/dashboard/images/' . ($colors_record?->images?->image ?? $item->product->image)); ?>"
                                    alt="Product">
                            </a>
                        </td>
                        <td>
                            <a href="<?php echo e(route('product.show', ['id' => $item->product->id])); ?>">
                                <?php echo e(app()->getLocale() === 'ar' ? $item->product->name_ar : $item->product->name_en); ?>

                                <br>
                                <?php if($item->product->discount > 0): ?>
                                    <?php echo e(number_format($item->product->price - ($item->product->price * $item->product->discount) / 100 + ($tax_tax / 100) * $item->product->price, 2)); ?>

                                <?php else: ?>
                                    <?php echo e(number_format($item->product->price + ($tax_tax / 100) * $item->product->price)); ?>

                                <?php endif; ?>
                                <img src="<?php echo e(asset('web/assets/images/Saudi_Riyal_Symbol.svg')); ?>" width="16">
                            </a>
                        </td>
                        <td data-id="<?php echo e($item->id); ?>">
                            <div class="pro-qty">
                                <span class="dec qtybtn" data-id="<?php echo e($item->id); ?>">-</span>
                                <input type="number" max="<?php echo e($item->product->quantity); ?>"
                                    value="<?php echo e($item->quantity); ?>" class="quantity-input" readonly>
                                <span class="inc qtybtn" data-id="<?php echo e($item->id); ?>">+</span>
                            </div>
                        </td>
                        <td class="product-color">
                            <div style="background-color: <?php echo e($item->color); ?>;" title="<?php echo e($item->color); ?>"></div>
                        </td>
                        <td style="font-size: 18px">
                            <?php if($item->product->discount > 0): ?>
                                <?php echo e(number_format($item->product->price * $item->quantity - ($item->product->price * $item->quantity * $item->product->discount) / 100 + ($tax_tax / 100) * ($item->product->price * $item->quantity), 2)); ?>

                            <?php else: ?>
                                <?php echo e(number_format($item->product->price * $item->quantity + ($tax_tax / 100) * ($item->product->price * $item->quantity))); ?>

                            <?php endif; ?>
                            <img src="<?php echo e(asset('web/assets/images/Saudi_Riyal_Symbol.svg')); ?>" width="16"><br>
                            <span class="text-tax"><?php echo e(__('lang.tax_pro')); ?></span>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <tr>
                    <td colspan="6" class="text-center text-danger">
                        <?php echo e(__('lang.no_product')); ?>

                    </td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<!-- ✅ بطاقات للجوال فقط -->

<div class="d-md-none position-relative">
    <?php if($items->get()->count() > 0): ?>
        <?php $__currentLoopData = $items->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $colors_record = \App\Models\Colors::where('product_id', $item->product->id)
                    ->where('color', $item->color)
                    ->first();
            ?>

            <div class="card mb-3 shadow-sm rounded-4 p-4 mb-4">
                <div class="d-flex">
                    <!-- صورة المنتج -->
                    <div style="width: 100px;">
                        <a href="<?php echo e(route('product.show', ['id' => $item->product->id])); ?>">
                            <img src="<?php echo e(Request::root() . '/dashboard/images/' . ($colors_record?->images?->image ?? $item->product->image)); ?>"
                                class="img-fluid rounded" style="width: 100%; height: 100px; object-fit: cover;">
                        </a>
                    </div>

                    <!-- التفاصيل -->
                    <div class="ms-3 flex-grow-1 position-relative">
                        <div class="d-flex justify-content-between align-items-start">
                            <div style="flex: 1;">
                                <h6 class="mb-1">
                                    <?php echo e(app()->getLocale() === 'ar' ? $item->product->name_ar : $item->product->name_en); ?>

                                </h6>
                                <!-- السعر -->
                                <div class="d-flex align-items-center gap-2">
                                    <?php if($item->product->discount > 0): ?>
                                        <small class="text-decoration-line-through text-muted">
                                            <?php echo e(number_format($item->product->price, 2)); ?>

                                        </small>
                                    <?php endif; ?>
                                    <span class="fw-bold" style="font-size: 16px;">
                                        <?php echo e(number_format($item->product->price * $item->quantity - ($item->product->price * $item->quantity * $item->product->discount) / 100 + ($tax_tax / 100) * ($item->product->price * $item->quantity), 2)); ?>

                                        <img src="<?php echo e(asset('web/assets/images/Saudi_Riyal_Symbol.svg')); ?>"
                                            width="14">
                                    </span>
                                </div>
                            </div>

                            <!-- زر الحذف -->
                            <form class="form-card-remove-phone" action="<?php echo e(route('cart.delete', ['id' => $item->id])); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="remove-wishlist" data-id="<?php echo e($item->id); ?>">
                                    <i class="fal fa-times"></i>
                                </button>
                            </form>
                        </div>

                        <!-- الكمية -->
                        <div data-id="<?php echo e($item->id); ?>" class="container-qty-phone">
                            <div class="pro-qty d-inline">
                                <button class="dec qtybtn" data-id="<?php echo e($item->id); ?>">-</button>
                                <input name="quantity-input" type="number" max="<?php echo e($item->product->quantity); ?>"
                                    value="<?php echo e($item->quantity); ?>" class="quantity-input" readonly>
                                <button class="inc qtybtn" data-id="<?php echo e($item->id); ?>">+</button>
                            </div>
                        </div>

                        <!-- اللون -->
                        <div class="mt-2 container-color-phone">
                            <span class="small text-muted"><?php echo e(__('lang.Colors')); ?>:</span>
                            <span class="d-inline-block ms-1"
                                style="width: 14px; height: 14px; border-radius: 50%; background-color: <?php echo e($item->color); ?>;"
                                title="<?php echo e($item->color); ?>"></span>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php else: ?>
        <div class="text-center text-danger my-3">
            <?php echo e(__('lang.no_product')); ?>

        </div>
    <?php endif; ?>
</div>
<?php /**PATH /home/cujzkrmy/public_html/newnetwork/project/resources/views/web/cart/table-data.blade.php ENDPATH**/ ?>