<?php $__env->startSection('css'); ?>
    <link href="<?php echo e(asset('dashboard/assets/plugins/custom/datatables/datatables.bundle.css')); ?>" rel="stylesheet" type="text/css"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('main_title', __('lang.roles')); ?>
<?php $__env->startSection('header_title', __('lang.roles')); ?>
<?php $__env->startSection('subheader_title', __('lang.index')); ?>

<?php $__env->startSection('content'); ?>
    <div class="card mb-5 mb-xxl-8">
        <!--begin::Header-->
        <div class="card-header border-0 pt-6">
            <!--begin::Title-->
            <h3 class="card-title d-flex align-items-start flex-column">
                <span class="card-label fw-bolder fs-3 mb-1">
                    <?php echo e(__('lang.roles')); ?>

                </span>
                <span class="text-muted fw-bold fs-7">
                    <?php echo e(__('lang.sub_title_message', ['count' => $roles->count()])); ?>

                </span>
            </h3>
            <div class="card-toolbar">

                <div class="d-flex justify-content-end" data-kt-user-table-toolbar="base">
                    <a href="<?php echo e(route('role.create')); ?>" type="button" class="btn btn-light-primary me-3" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end" data-kt-menu-flip="top-end">
                        <i class="fas fa-plus"></i>
                        <?php echo e(__('lang.role_create')); ?>

                    </a>
                </div>
                <!--end::Toolbar-->
            </div>
            <!--end::Title-->

        </div>
        <!--end::Header-->
        <!--begin::Body-->
        <div class="card-body" style="position: relative;">

            <?php if(session('success')): ?>
                <div class="alert alert-success">
                    <?php echo e(session('success')); ?>

                </div>
            <?php elseif(session('error')): ?>
                <div class="alert alert-danger">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>

            <div id="table-data">
                <table id="kt_datatable_example_1" class="table table-row-bordered gy-5">
                    <thead>
                    <tr class="fw-bold fs-6 text-muted text-center">
                        <th>
                            #
                        </th>
                        <th>
                            <?php echo e(__('lang.role_name')); ?>

                        </th>
                        <th>
                            <?php echo e(__('lang.actions')); ?>

                        </th>

                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="text-center">
                            <td>
                                <?php echo e($i+=1); ?>

                            </td>
                            <td>
                                <?php echo e($role->name); ?>

                            </td>
                            <td>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Roles-Edit')): ?>
                                <a href="<?php echo e(route('role.edit', ['id' => $role->id])); ?>" class="btn btn-icon btn-light-primary btn-sm me-1">
                                    <i class="fas fa-pencil-alt"></i>
                                </a>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Roles-Delete')): ?>
                                <button class="btn btn-icon btn-light-danger btn-sm me-1" data-bs-toggle="modal" data-bs-target="#deleteModal-<?php echo e($role->id); ?>">
                                    <i class="fas fa-trash-alt"></i>
                                </button>
                                <?php endif; ?>
                            </td>
                        </tr>

                        

                        <div class="modal fade" tabindex="-1" id="deleteModal-<?php echo e($role->id); ?>">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">
                                            <?php echo e(__('lang.delete_role')); ?>

                                        </h5>

                                        <!--begin::Close-->
                                        <div class="btn btn-icon btn-sm btn-active-light-primary ms-2" data-bs-dismiss="modal" aria-label="Close">
                                            <i class="bi bi-x fs-2"></i>
                                        </div>
                                        <!--end::Close-->
                                    </div>

                                    <div class="modal-body">
                                        <p>
                                            <?php echo e(__('lang.delete_role_body')); ?>

                                        </p>
                                        <input class="form-control" value="<?php echo e($role->name); ?>" disabled>
                                    </div>

                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                                            <?php echo e(__('lang.close')); ?>

                                        </button>
                                        </button>
                                        <form action="<?php echo e(route('role.delete', ['id' => $role->id])); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>

                                            <button type="submit" class="btn btn-danger">
                                                <?php echo e(__('lang.sure')); ?>

                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                    </tbody>

                </table>

            </div>
        </div>
        <!--end::Body-->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('dashboard/assets/plugins/custom/datatables/datatables.bundle.js')); ?>"></script>





























<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cujzkrmy/public_html/newnetwork/project/resources/views/dashboard/roles/index.blade.php ENDPATH**/ ?>