<?php

use App\Http\Controllers\dashboard\AdminsController;
use App\Http\Controllers\dashboard\ImagesController;
use App\Http\Controllers\dashboard\RolesController;
use App\Http\Controllers\web\CartController;
use App\Http\Controllers\web\ContactUsController;
use App\Http\Controllers\web\FavoriteController;
use App\Http\Controllers\web\HomeController;
use App\Http\Controllers\web\MyAccountController;
use App\Http\Controllers\web\ApplePayController;

use App\Http\Controllers\dashboard\CategoriesController;
use App\Http\Controllers\dashboard\ProductsController;
use App\Http\Controllers\dashboard\ProposalsController as DashboardProposalsController;
use App\Http\Controllers\dashboard\AppointmentsController as DashboardAppointmentsController;
use App\Http\Controllers\web\AppointmentsController;
use App\Http\Controllers\dashboard\SeoController;

use App\Http\Controllers\web\EmcanPaymentController;
use App\Http\Controllers\web\OrderController;
use App\Http\Controllers\web\ProductWebController;
use App\Http\Controllers\web\ProposalsController;
use App\Http\Controllers\web\SearchController;
use App\Http\Controllers\web\SubscribeController;
use App\Http\Controllers\dashboard\TagController;

use App\Http\Controllers\dashboard\GiftController;

use App\Http\Controllers\web\TapPaymentController;
use App\Models\Carts;
use App\Models\Categories;
use App\Models\Order;
use App\Models\Settings;
use Illuminate\Support\Facades\Route;
use  Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use \App\Http\Controllers\Tamara\TamaraController;
use App\Http\Controllers\web\InstallmentController;
use App\Http\Controllers\web\SmsaController;
use \App\Http\Controllers\Webhook\TamarawebhookController;
use App\Http\Controllers\web\BlogController as WebBlogController;
use App\Http\Controllers\dashboard\BranchController;

use App\Payment\Tamara\Tamara;
use App\Models\Seo;
use App\Http\Controllers\Tabby\TabbyController;
use App\Http\Controllers\web\MostSaleController;
use \App\Http\Controllers\Webhook\Tamamwebhook;
use App\Http\Controllers\web\TamamController;
use App\Http\Controllers\dashboard\PreorderController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use App\Http\Controllers\EnterDataController;
use App\Http\Controllers\web\ReviewController;

use App\Http\Controllers\web\WfcoDemoController;


// use Illuminate\Support\Facades\Http;



// Tamam company
Route::group([
    'prefix' => LaravelLocalization::setLocale(),
], function () {
Route::any('/webhooks/tamam/po-confirmation', [Tamamwebhook::class, 'poConfirmation']);
Route::any('/webhooks/tamam/status-callback', [Tamamwebhook::class, 'statusCallback']);
Route::any('/webhooks/tamam/refund-callback', [Tamamwebhook::class, 'refundCallback']);
Route::any('/webhooks/tamam/payment-status', [Tamamwebhook::class, 'paymentStatus']);
});


// الوطنية 
Route::group([
    'prefix' => LaravelLocalization::setLocale(),

], function () {

    Route::get('/wfco/oauth', [WfcoDemoController::class, 'oauth']);
    Route::post('/wfco/initiate', [WfcoDemoController::class, 'initiate']);
    Route::post('/wfco/otp', [WfcoDemoController::class, 'otp']);
    Route::post('/wfco/inquire', [WfcoDemoController::class, 'inquire']);
    Route::post('/wfco/delivery', [WfcoDemoController::class, 'delivery']);
    Route::post('/wfco/cancel-po', [WfcoDemoController::class, 'cancelPo']);
    Route::post('/wfco/cancel-contract', [WfcoDemoController::class, 'cancelContract']);
});

// نهاية الوطنيه 





Route::group([
    'prefix' => LaravelLocalization::setLocale() . '/review',
    'as' => 'review.',
    'middleware' => ['auth:web']
], function () {
    Route::post('/add-review', [ReviewController::class, 'store'])->name('add-review');
});


Route::group([
    'prefix' => LaravelLocalization::setLocale(),
    
], function () {
    Route::get("enter_data", [EnterDataController::class, "index"]);
});


Route::group([
    'prefix' => LaravelLocalization::setLocale(),
   
], function () {
    
    Route::get('/test-translate', function () {
    $text = 'مرحباً';
    $apiKey ='AIzaSyBidp26lsxiul3zZqjcEU1DwgUcc9y03fc';

    $response = Http::asForm()->post('https://translation.googleapis.com/language/translate/v2', [
        'q' => $text,
        'target' => 'en',
        'format' => 'text',
        'key' => $apiKey,
    ]);

    if (!$response->successful()) {
        return $response->body(); // اطبع محتوى الخطأ
    }

    return $response->json();
});
    

Route::get('/thank-you', function () {
    return view('web.think_you');
})->name('thank-you');
});

Route::group([
    'prefix' => LaravelLocalization::setLocale(),
   
], function () {
Route::get("preorder",[HomeController::class ,"preorder"])->name("preorder");
Route::post("preorder",[HomeController::class,"store_preorder"])->name("store_preorder");
Route::get("{name}/tag/{id}", [HomeController::class, "tag_front"])->name("tag_front");
});

Route::prefix(LaravelLocalization::setLocale())
->as('seo.')
->group(function () {
Route::get("index",[SeoController::class,'index_page'])->name("index_page");
Route::get("index_category",[SeoController::class,'index_category'])->name("index_category");
Route::get("index_product",[SeoController::class,'index_product'])->name("index_product");
Route::post("store",[SeoController::class,'store_page'])->name("store_page");
Route::post("store_category",[SeoController::class,'store_category'])->name("store_category");
Route::post("store_product",[SeoController::class,'store_product'])->name("store_product");
Route::post("update/{id}",[SeoController::class,'update_page'])->name("update_page");
Route::get("edit/{id}",[SeoController::class,'edit_page'])->name("edit_page");
Route::get("delete/{id}",[SeoController::class,'delete_recored'])->name("delete_recored");

});



Route::get("authrize/{id}",[Tamara::class,"capture"]);



// Installment 
 
Route::get('service/installment',[InstallmentController::class,"index"])->name("service.installment");

// end Installment

Route::get('smsa',[SmsaController::class,"downloadShippingLabel"])->name("create_shipment");

require __DIR__ . '/auth.php';
// Clear application cache:
Route::get('/clear-cache', function() {
    Artisan::call('cache:clear');
    return 'Application cache has been cleared';
});

//Clear route cache:
Route::get('/route-cache', function() {
    Artisan::call('route:clear');
    return 'Routes cache has been cleared';
});
//Clear config cache:
Route::get('/config-cache', function() {
    Artisan::call('config:cache');
    return 'Config cache has been cleared';
});

// Clear view cache:
Route::get('/view-clear', function() {
    Artisan::call('view:clear');
    return 'View cache has been cleared';
});


Route::get("blog",[WebBlogController::class,'index'])->prefix(LaravelLocalization::setLocale())->name("blog.index");
Route::get("detail-post/{slug}", [WebBlogController::class, 'detail_post'])->prefix(LaravelLocalization::setLocale())->name("blog.detail_post");
Route::get('/admin/dashboard', [\App\Http\Controllers\dashboard\HomeController::class , 'index'])->prefix(LaravelLocalization::setLocale())->middleware(['auth:admin'])->name('dashboard.index');
Route::get('branchs', function() {
    $seo=Seo::where("type","page")->where("name_page","branch")->first();
    return view("web.branch",compact('seo'));
   
})->prefix(LaravelLocalization::setLocale())->name("branch");











//Route::get('/testtest', function (){
//    $order = Order::where('number' , '20230006')->first();
//    $order->update([
//        'payment_status' => 'paid'
//    ]);
//});

Route::get('/', [HomeController::class, 'index'])->prefix(LaravelLocalization::setLocale())->name('home');
Route::get('most_sale', [MostSaleController::class, 'index'])->prefix(LaravelLocalization::setLocale())->name('most_sale');

// Route::get('installment', [ProposalsController::class, 'create']);

// Web Routes
Route::group([
    'prefix' => LaravelLocalization::setLocale(),
    'middleware' => ['auth:web'],
], function () {
// 
    Route::get('services/emkan', [EmcanPaymentController::class, 'services_emkan'])->withoutMiddleware(['auth:web']);
    Route::get('installment', [ProposalsController::class, 'create'])->withoutMiddleware(['auth:web'])->name("installment");
    Route::post('services/proposal', [ProposalsController::class, 'store'])->withoutMiddleware(['auth:web'])->name('proposal.store');
    Route::get('export/proposal', [DashboardProposalsController::class, 'export'])->withoutMiddleware(['auth:web'])->name('proposal.export');
    Route::post('services/appointment', [AppointmentsController::class, 'store'])->withoutMiddleware(['auth:web'])->name('appointment.store');
        Route::get('export/appointment', [DashboardAppointmentsController::class, 'export'])->withoutMiddleware(['auth:web'])->name('appointment.export');


    // My Account
    Route::controller(MyAccountController::class)
        ->prefix('account')
        ->as('account.')
        ->group(function () {
            Route::get('/', 'index')->name('index');
            Route::get('edite_address/{id}', 'edite_address')->name('edite_address');
            Route::post('update_address/{id}', 'update_address')->name('update_address');
            Route::post('delete_address/{id}', 'delete_address')->name('delete_address');
            Route::put('/{id}', 'update')->name('update');
            Route::post('add-address', 'add_address')->name('add_address');
            Route::get('getTracking/{id}', 'getTracking')->name('getTracking');
            
            // create osama route change password
            Route::get('change_password', 'changePassword')->name('change_password');


        });

    // Contact Us
    Route::controller(ContactUsController::class)
        ->prefix('contact-us')
        ->as('contact-us.')
        ->withoutMiddleware(['auth:web'])
        ->group(function () {
            Route::get('/', 'index')->name('index');
            Route::post('/', 'store')->name('store');
        });

    // Subscribe Route
    Route::controller(SubscribeController::class)
        ->prefix('subscribe')
        ->as('subscribe.')
        ->group(function () {
            Route::post('/', 'store')->name('store')->withoutMiddleware(['auth:web']);
        });

    Route::controller(CartController::class)
        ->prefix('cart')
        ->as('cart.')
        ->withoutMiddleware(['auth:web'])
        ->group(function () {
             Route::delete('/{id}', 'destroy')->name('delete');
            Route::get('/', 'index')->name('index');
            Route::post('/', 'store')->name('store');
           
            Route::post('/coupon', 'coupon')->name('coupon');
            Route::post('/update/{id}', 'update_cart')->name('update_cart');
            Route::post('/update_Shipping', 'update_Shipping')->name('update_Shipping');
            Route::post('/empty', 'empty')->name('empty');
        });

    Route::controller(ProductWebController::class)
        ->prefix('products')
        ->as('product.')
        ->withoutMiddleware(['auth:web'])
        ->group(function () {
            Route::get('/', 'index')->name('index');
            Route::get('/single/{id}', 'show')->name('show');
            Route::get('/getData/{id}', 'getData')->name('getData');
            Route::post('/add_fav', 'add_fav')->name('add_fav');
            Route::get('/show/{id}', 'show_products')->name('show_products');
            Route::post('/search', 'search')->name('search');
            Route::get('/new-arrivals', 'product_type')->name('new-arrivals');
            Route::get('/most-sold', 'product_type')->name('most-sold');
            // Route::post('/add-review', 'add_review')->name('add-review');
            Route::post('/add-inquery', 'add_inquery')->name('add-inquery');
            Route::get('/category/{id}/{slug}', 'category')->name('category');
             Route::post('childCategory', 'childCategory')->name('childCategory');
             
               Route::post('/compare-products', [ProductWebController::class, 'campare_product'])
                ->name('compare.product');
        });

    Route::controller(\App\Http\Controllers\web\QuickLinkController::class)
        ->prefix('')
        ->as('link.')
        ->withoutMiddleware(['auth:web'])
        ->group(function () {
            Route::get('/About-Us', 'about')->name('about');
            Route::get('/Terms-Of-Use', 'terms_use')->name('terms_use');
            Route::get('/Privacy-Policy', 'privacy_policy')->name('privacy_policy');
            Route::get('/FAQ', 'faq')->name('faq');
            Route::get('/Corporate_governance', 'Corporate_governance')->name('Corporate_governance');
            Route::get('/Warranty_policy', 'Warranty_policy')->name('Warranty_policy');
            Route::get('/returnsـandـexchanges', 'returnsـandـexchanges')->name('returnsـandـexchanges');
            Route::get('/usage_policy', 'usage_policy')->name('usage_policy');
             Route::get('/return-policy', 'return_policy')->name('return_policy');

        });
        
          Route::controller(\App\Http\Controllers\web\LoyaltyController::class)
        ->prefix('loyalty')
        ->as('loyalty')
        ->middleware(['auth:web'])
        ->group(function () {
            Route::get('/index', 'index')->name('index');
            Route::post('store', 'store')->name('store');
           
        });
        
        
        
    // Start Favorite Route
    Route::controller(FavoriteController::class)
        ->prefix('favorite')
        ->as('favorite.')
        ->group(function () {
            Route::get('/', 'index')->name('index');
            Route::post('/', 'store')->name('store');
            Route::delete('/delete', 'destroy')->name('delete');
        });
    // End Favorite Route

    // Start Favorite Route
    Route::controller(SearchController::class)
        ->prefix('search')
        ->as('search.')
        ->withoutMiddleware(['auth:web'])
        ->group(function () {
            Route::get('/', 'search')->name('modelSearch');
        });
    // End Favorite Route

    // Start Order Route
    Route::controller(OrderController::class)
        ->prefix('orders')
        ->as('order.')
        ->group(function () {
//            Route::get('/list', 'index')->name('index')->withoutMiddleware(['auth:web'])->middleware(['auth:admin']);
            Route::get('/', 'create')->name('create');
            Route::post('/', 'store')->name('store');
            Route::get('/yourOrder/{user_name}/{id}', 'show')->withoutMiddleware(['auth:web'])->name('show');
            Route::delete('/{id}', 'destroy')->name('delete')->withoutMiddleware(['auth:web'])->middleware(['auth:admin']);
        });
    // End Order Route

    // Start Payment Route
    Route::controller(TapPaymentController::class)
        ->prefix('tap_payment')
        ->as('tap.')
        ->withoutMiddleware(['auth:web'])
        ->group(function () {
            Route::get('/v2/orders/{id}', 'create')->name('create');
            Route::get('/{id}', 'getPayment')->name('paymentStatus');
        });
    // End Payment Route
    
     // apple pay
      
    Route::controller(ApplePayController::class)
        ->prefix('apple_pay')
        ->as('apple_pay.') 
        ->withoutMiddleware(['auth:web'])
        ->group(function () {
            // Route::get('/v2/orders/{id}', 'create')->name('create');
            Route::get('create/{id}/{res}', 'createOrder')->name('createOrder');
        });

    // end apple pay

    Route::controller(EmcanPaymentController::class)
    ->prefix('emcan_payment')
    ->as('emcan.')
    ->withoutMiddleware(['auth:web'])
    ->group(function () {
        Route::get('/{id}', 'create')->name('create');
        Route::post('/{id}', 'store')->name('store');
        Route::get('/otp/{id}', 'otp_show')->name('otp_show');
        Route::post('/otp/{id}', 'otp')->name('otp');
    });

});


// Admin Routes
Route::group([
    'middleware' => ['auth:admin', 'localeViewPath'],
    'prefix' => LaravelLocalization::setLocale() . '/admin',
], function () {
    Route::controller(CategoriesController::class)
        ->prefix('categories')
        ->as('cat.')
        ->group(function () {
            Route::get('/index', 'index')->name('index');

            Route::get('/create', 'create')->name('create');

            Route::post('/store', 'store')->name('store');

            Route::get('/show/{id}', 'show')->name('show');

            Route::get('/edit/{id}', 'edit')->name('edit');

            Route::post('/update', 'update')->name('update');

            Route::post('/destroy/{id}', 'destroy')->name('destroy');

            Route::post('/Stauts/{id}', 'updateStauts')->name('updateStauts');
             Route::post('add_description/{id}','add_description')->name('add_description');

        });
        
         Route::prefix('dashboard/tags')->group(function () {
        Route::get('/', [TagController::class, 'index'])->name('dashboard.tags.index');          // عرض كل الوسوم
        Route::get('create', [TagController::class, 'create'])->name('dashboard.tags.create');
        Route::get('edit/{id}', [TagController::class, 'edit'])->name('dashboard.tags.edit');
        Route::get('active/{id}', [TagController::class, 'destroy'])->name('dashboard.tags.active');

        Route::post('/', [TagController::class, 'store'])->name('dashboard.tags.store');        // حفظ وسم جديد
        Route::put('/{id}', [TagController::class, 'update'])->name('dashboard.tags.update');   // تعديل وسم
        Route::delete('/{id}', [TagController::class, 'destroy'])->name('dashboard.tags.destroy'); // حذف وسم
        Route::post("assignProductToTag", [TagController::class, "assignProductToTag"])->name("dashboard.tag.assignProductToTag");
    });

        
        
        
        Route::group([
            'middleware' => ['auth:admin', 'localeViewPath'],
            'prefix' => LaravelLocalization::setLocale() . '/admin',
        ], function () {
            Route::controller(GiftController::class)
                ->prefix('gift')
                ->as('gift.')
                ->group(function () {
                    Route::get('/index', 'index')->name('index');
        
                    Route::get('/create', 'create')->name('create');
        
                    Route::post('/store', 'store')->name('store'); 
        
                     Route::get("client","client")->name("client");

                    Route::get("delivery/{id}","delivery")->name("delivery");
        
                    Route::get('/client/all', 'edit')->name('client.all');
        
                    Route::post('/update', 'update')->name('update');
        
                    Route::post('/destroy/{id}', 'destroy')->name('destroy');
        
                    Route::post('/Stauts/{id}', 'updateStauts')->name('updateStauts');
                });
            });
        
          Route::get("admin/preorder", [PreorderController::class, "index"])->name("admin.preorder");

    // Ads
    Route::controller(\App\Http\Controllers\dashboard\AdsController::class)
        ->prefix('ads')
        ->as('ads.')
        ->group(function () {
            Route::get('/index', 'index')->name('index');

            Route::get('/create', 'create')->name('create');

            Route::post('/store', 'store')->name('store');

            Route::get('/show/{id}', 'show')->name('show');

            Route::get('/edit/{id}', 'edit')->name('edit');

            Route::post('/update', 'update')->name('update');

            Route::post('/destroy/{id}', 'destroy')->name('destroy');

            Route::post('/Stauts/{id}', 'updateStauts')->name('updateStauts');
        });


    // Products
    Route::controller(\App\Http\Controllers\dashboard\ProductsController::class)
        ->prefix('products')
        ->as('products.')
        ->group(function () {
            Route::get('/index', 'index')->name('index');
Route::get("/related_product", "related_product")->name("related_product");
            Route::get('/create', 'create')->name('create');

            Route::post('/store', 'store')->name('store');

            Route::get('/show/{id}', 'show')->name('show');

            Route::get('/edit/{id}', 'edit')->name('edit');

            Route::post('/update', 'update')->name('update');

            Route::post('/destroy/{id}', 'destroy')->name('destroy');

            Route::post('/Stauts/{id}', 'updateStauts')->name('updateStauts');

            Route::post('/appearUpdate/{id}', 'appearUpdate')->name('appearUpdate');

            Route::get('/reStore/{id}' , 'reStore')->name('reStore');
             Route::post('description/{id}', 'description_peroduct')->name('description');

        });
        
        
          Route::controller(\App\Http\Controllers\dashboard\ManagmentBlogController::class)
    ->prefix('blogAdmin')
    ->as('blogAdmin.')
    ->group(function () {
        Route::get('/index', 'index')->name('index');

        Route::get('/create', 'create')->name('create');

        Route::post('/store', 'store')->name('store');

        Route::get('/show/{id}', 'show')->name('show');

        Route::get('/edit/{id}', 'edit')->name('edit');

        Route::post('/update/{id}', 'update')->name('update');

        Route::post('/destroy/{id}', 'destroy')->name('destroy');
        
         Route::get('/actvie/{id}', 'active')->name('active');

        Route::post('/Stauts/{id}', 'updateStauts')->name('updateStauts');

        Route::post('/appearUpdate/{id}', 'appearUpdate')->name('appearUpdate');

        Route::get('/reStore/{id}' , 'reStore')->name('reStore');;
    }); 
    
    
     // slider 

    Route::controller(\App\Http\Controllers\dashboard\SliderController::class)
    ->prefix('slider')
    ->as('slider.')
    ->group(function () {
        Route::get('/index', 'index')->name('index');

        Route::get('/create', 'create')->name('create');

        Route::post('/store', 'store')->name('store');

        Route::get('/show/{id}', 'show')->name('show');

        Route::get('/edit/{id}', 'edit')->name('edit');

        Route::post('/update/{id}', 'update')->name('update');

        Route::get('/destroy/{id}', 'destroy')->name('destroy');
        Route::get('/actvie/{id}', 'active')->name('active');

        Route::post('/Stauts/{id}', 'updateStauts')->name('updateStauts');

        Route::post('/appearUpdate/{id}', 'appearUpdate')->name('appearUpdate');

        Route::get('/reStore/{id}' , 'reStore')->name('reStore');;
    }); 
    
      Route::prefix('branches')->as('branches.')->group(function () {
        Route::get('/', [BranchController::class, 'index'])->name("index");
        Route::post('/', [BranchController::class, 'store'])->name("store");
        Route::get('/create', [BranchController::class, 'create'])->name('create');
        Route::get('/edite/{id}', [BranchController::class, 'edite'])->name('edite');
        Route::get('{id}', [BranchController::class, 'show'])->name("show");
        Route::post('update/{id}', [BranchController::class, 'update'])->name("branch.update");
        Route::delete('{id}', [BranchController::class, 'destroy'])->name("destroy");
        Route::get('/actvie/{id}',  [BranchController::class, 'active'])->name('active');
    });
    
    
    
     Route::controller(\App\Http\Controllers\dashboard\ReviewController::class)
    ->prefix('review')
    ->as('review.')
    ->group(function () {
        Route::get('/index', 'index')->name('index');

        Route::get('/create', 'create')->name('create');

        Route::post('/store', 'store')->name('store');

        Route::get('/show/{id}', 'show')->name('show');

        Route::get('/edit/{id}', 'edit')->name('edit');

        Route::post('/update/{id}', 'update')->name('update');

        Route::get('/destroy/{id}', 'destroy')->name('destroy');
        Route::get('/actvie/{id}', 'active')->name('active');

        Route::post('/Stauts/{id}', 'updateStauts')->name('updateStauts');

        Route::post('/appearUpdate/{id}', 'appearUpdate')->name('appearUpdate');

        Route::get('/reStore/{id}' , 'reStore')->name('reStore');;
    }); 




    // Countries
    Route::controller(\App\Http\Controllers\dashboard\CountriesController::class)
        ->prefix('countries')
        ->as('countries.')
        ->group(function () {
            Route::get('/index', 'index')->name('index');

            Route::get('/create', 'create')->name('create');

            Route::post('/store', 'store')->name('store');

            Route::get('/show/{id}', 'show')->name('show');

            Route::get('/edit/{id}', 'edit')->name('edit');

            Route::post('/update', 'update')->name('update');

            Route::post('/destroy/{id}', 'destroy')->name('destroy');

            Route::post('/Stauts/{id}', 'updateStauts')->name('updateStauts');
        });

    // Cities
    Route::controller(\App\Http\Controllers\dashboard\CitiesController::class)
        ->prefix('cities')
        ->as('cities.')
        ->group(function () {
            Route::get('/index', 'index')->name('index');

            Route::get('/create', 'create')->name('create');

            Route::post('/store', 'store')->name('store');

            Route::get('/show/{id}', 'show')->name('show');

            Route::get('/edit/{id}', 'edit')->name('edit');

            Route::post('/update', 'update')->name('update');

            Route::post('/destroy/{id}', 'destroy')->name('destroy');

            Route::post('/Stauts/{id}', 'updateStauts')->name('updateStauts');
        });

    // Coupons
    Route::controller(\App\Http\Controllers\dashboard\CouponsController::class)
        ->prefix('coupons')
        ->as('coupons.')
        ->group(function () {
            Route::get('/index', 'index')->name('index');

            Route::get('/create', 'create')->name('create');

            Route::post('/store', 'store')->name('store');

            Route::get('/show/{id}', 'show')->name('show');

            Route::get('/edit/{id}', 'edit')->name('edit');

            Route::post('/update', 'update')->name('update');

            Route::post('/destroy/{id}', 'destroy')->name('destroy');

            Route::post('/Stauts/{id}', 'updateStauts')->name('updateStauts');
        });


    // Proposal
    Route::controller(\App\Http\Controllers\dashboard\ProposalsController::class)
    ->prefix('proposals')
    ->as('proposals.')
    ->group(function () {
        Route::get('/index', 'index')->name('index');

        Route::post('/destroy/{id}', 'destroy')->name('destroy');
    });

    // Appointments
    Route::controller(\App\Http\Controllers\dashboard\AppointmentsController::class)
    ->prefix('appointments')
    ->as('appointments.')
    ->group(function () {
        Route::get('/index', 'index')->name('index');

        Route::post('/destroy/{id}', 'destroy')->name('destroy');
    });


    // Shipping options
    Route::controller(\App\Http\Controllers\dashboard\ShippingMethodController::class)
        ->prefix('shippingoptions')
        ->as('shippingoptions.')
        ->group(function () {
            Route::get('/index', 'index')->name('index');

            Route::get('/create', 'create')->name('create');

            Route::post('/store', 'store')->name('store');

            Route::get('/show/{id}', 'show')->name('show');

            Route::get('/edit/{id}', 'edit')->name('edit');

            Route::post('/update', 'update')->name('update');

            Route::post('/destroy/{id}', 'destroy')->name('destroy');

            Route::post('/Stauts/{id}', 'updateStauts')->name('updateStauts');
        });


    // Start Admins Controller
    Route::controller(AdminsController::class)
        ->as('admin.')
        ->group(function () {
            Route::get('/', 'index')->name('index');
            Route::get('/create', 'create')->name('create');
            Route::post('/', 'store')->name('store');
            Route::get('/{id}/edit', 'edit')->name('edit');
            Route::put('/{id}', 'update')->name('update');
            Route::delete('/{id}', 'destroy')->name('delete');
            Route::post('/status/{id}', 'changeStatus')->name('changeStatus');

            Route::get('/profile-edit', 'edit_admin')->name('profile.edit');

            Route::post('/profile-update', 'update_admin')->name('profile.update');

            Route::get('/profile-resetPassword',  'reset_Password')->name('profile.reset_Password');

            Route::post('/profile-reset-Password',  'resetPassword')->name('profile.resetPassword');
        });
    // End Admins Controller

    Route::controller(RolesController::class)
        ->prefix('roles')
        ->as('role.')
        ->group(function () {
            Route::get('/', 'index')->name('index');
            Route::get('/create', 'create')->name('create');
            Route::post('/', 'store')->name('store');
            Route::get('/{id}/edit', 'edit')->name('edit');
            Route::put('/{id}', 'update')->name('update');
            Route::delete('/{id}', 'destroy')->name('delete');
            Route::post('/status/{id}', 'changeStatus')->name('changeStatus');
        });
    // End Admins Controller

    // Start Contact Us Route ( Dashboard )
    Route::controller(ContactUsController::class)
        ->prefix('contact-us')
        ->as('contact-us.')
        ->group(function () {
            Route::get('/', 'fetch')->name('fetch');
            Route::post('/{id}', 'destroy')->name('delete');
        });
    // End Contact Us Route ( Dashboard )

    // Start Subscribe Route ( Dashboard )
    Route::controller(SubscribeController::class)
        ->prefix('subscribe')
        ->as('subscribe.')
        ->group(function () {
            Route::get('/', 'fetch')->name('fetch');
            Route::get('/sendMail', 'sendMail')->name('sendMail');
            Route::post('/sendMail', 'create_mail')->name('create_mail');
//            Route::delete('/{id}', 'destroy')->name('delete');
        });
    // Start Subscribe Route ( Dashboard )

    // Start Subscribe Route ( Dashboard )
    Route::controller(SubscribeController::class)
        ->prefix('subscribe')
        ->as('subscribe.')
        ->group(function () {
//            Route::get('/', 'fetch')->name('fetch');
            Route::post('/{id}', 'destroy')->name('delete');
        });
    // Start Subscribe Route ( Dashboard )

    // Why choose us
    Route::controller(\App\Http\Controllers\dashboard\WhyChooseUsController::class)
        ->prefix('whychooseus')
        ->as('whychooseus.')
        ->group(function () {
            Route::get('/index', 'index')->name('index');

            Route::get('/create', 'create')->name('create');

            Route::post('/store', 'store')->name('store');

            Route::get('/show/{id}', 'show')->name('show');

            Route::get('/edit/{id}', 'edit')->name('edit');

            Route::post('/update', 'update')->name('update');

            Route::post('/destroy/{id}', 'destroy')->name('destroy');

            Route::post('/Stauts/{id}', 'updateStauts')->name('updateStauts');
        });


    // Users
    Route::controller(\App\Http\Controllers\dashboard\UsersController::class)
        ->prefix('users')
        ->as('users.')
        ->group(function () {
            Route::get('/index', 'index')->name('index');

            Route::get('/create', 'create')->name('create');

            Route::post('/store', 'store')->name('store');

            Route::get('/show/{id}', 'show')->name('show');

            Route::get('/edit/{id}', 'edit')->name('edit');

            Route::post('/update', 'update')->name('update');

            Route::post('/destroy/{id}', 'destroy')->name('destroy');

            Route::post('/Stauts/{id}', 'updateStauts')->name('updateStauts');
        });

    Route::controller(ImagesController::class)
        ->prefix('images')
        ->as('image.')
        ->group(function () {
         Route::post('update_color', 'update_color')->name('update.color');

            Route::get('/{model}/{id}', 'index')->name('index');
            Route::get('/{model}/create', 'create')->name('create');
            Route::post('/{model}', 'store')->name('store');
            Route::get('/{model}/{id}/edit', 'edit')->name('edit');
            Route::put('/{model}/{id}', 'update')->name('update');
            Route::delete('/{model}/{id}', 'destroy')->name('delete');
              Route::post("img/{id}", "store_alt")->name("img.alt");
        });

    Route::controller(\App\Http\Controllers\dashboard\SettingController::class)
        ->prefix('setting')
        ->as('setting.')
        ->group(function () {
            Route::get('/global', 'index')->name('global');
            Route::get('/social', 'social')->name('social');
            Route::post('/update', 'update')->name('update');

            Route::get('/page/{group}', 'page')->name('page');
        });

    Route::controller(\App\Http\Controllers\dashboard\PaymentOptionsController::class)
        ->prefix('payment-options')
        ->as('PaymentOptions.')
        ->group(function () {
            Route::get('/index', 'index')->name('index');

            Route::post('/store', 'store')->name('store');

            Route::post('/destroy/{id}', 'destroy')->name('destroy');
        });

    Route::controller(\App\Http\Controllers\dashboard\OrdersController::class)
        ->prefix('orders')
        ->as('order.')
        ->group(function () {
            Route::get('/index', 'index')->name('index');

            Route::get('/print/{id}', 'print')->name('print');

            Route::post('/destroy/{id}', 'destroy')->name('destroy');
        });
});

Route::group([
    'prefix' => LaravelLocalization::setLocale(),
], function () {
    Route::get('/forgotPassword' , [\App\Http\Controllers\web\UserController::class , 'forgot_password'])->name('GETforgotPassword');
    Route::post('/forgotPassword' , [\App\Http\Controllers\web\UserController::class , 'forgot_password_email'])->name('forgotPassword');
    Route::get('/resetPassword/{email}' , [\App\Http\Controllers\web\UserController::class , 'reset_password'])->name('GETresetPassword');;
    Route::post('/resetPassword/{user_name}' , [\App\Http\Controllers\web\UserController::class , 'reset_password_user'])->name('resetPassword');
});


Route::group([
    'prefix' => LaravelLocalization::setLocale(),
], function () {

Route::get("/link_tamara_payment/{order_id}",[TamaraController::class,"get_redirect_link"])->name("tamara_payment_link");

Route::any("/tamara_payment/processing_payment/{order_id}",[TamaraController::class,"processing_payment"])->name('processing_payment');
Route::any("/failure_payment/{id_order}",[TamaraController::class,"failure_payment"])->name("failure_payment");



Route::any('/tamara_webhook',[TamarawebhookController::class,"receive_events"]);
Route::any("/change_uuid",function (){
    $orders=Order::all();
    foreach ($orders as $order){
        $order->uuid=\Illuminate\Support\Str::uuid();
        $order->save();
    }
});

});


// tabby route
Route::group([
    'prefix' => LaravelLocalization::setLocale(),
], function () {
    
    Route::get("/link_tamam_payment/{order_id}", [TamamController::class, "tamamStart"])->name("tamam_payment_link");

    Route::get("/link_tabby_payment/{order_id}", [TabbyController::class, "get_redirect_link"])->name("tabby_payment_link");

    Route::any("/tabby_payment/processing_payment/{order_id}", [TabbyController::class, "processing_payment"])->name('tabby_processing_payment');
    Route::any("/tabby_failure_payment/{id_order}", [TabbyController::class, "failure_payment"])->name("tabby_failure_payment");
    Route::any("/tabby_cancel_payment/{id_order}", [TabbyController::class, "cancel_payment"])->name("tabby_cancel_payment");
     Route::any("webhook/tabby/register", [TabbyController::class, 'register_webhook'])->name("tabby.webhook.register");


    Route::any('/tabby_webhook', [TabbyController::class, "receive_events"])->name("tabby.receive_events");



    Route::any('/tamara_webhook', [TamarawebhookController::class, "receive_events"]);
    Route::any("/change_uuid", function () {
        $orders = Order::all();
        foreach ($orders as $order) {
            $order->uuid = \Illuminate\Support\Str::uuid();
            $order->save();
        }
    });
});
// end tabby route 


