@extends('layouts.front_layout')

@if( app()->getLocale() == 'en' )
     
@section('title', $seo?->meta_title_en)
@section("description",$seo?->meta_description_en)
@section("canonical",$seo?->canonical_en)
@else
@section('title', $seo?->meta_title_ar)
@section("description",$seo?->meta_description_ar)
@section("canonical",$seo?->canonical_ar)


@endif

@section("css")


<style>
body{
    overflow: hidden !important;
}
.main-wrapper{
    background-color: #FFF !important;
}

 .post-date {
      position: absolute;
      top: 10px;
      left: 10px;
      background-color: #782569;
      color: #ffffff;
      padding: 5px 10px;
      border-radius: 5px;
      font-size: 0.9em;
    }
    .card {
      border: none;
      border-radius: 10px;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    .card:hover {
      transform: translateY(-10px);
      box-shadow: 0 12px 20px rgba(0, 0, 0, 0.15);
    }
    .card-img-top {
      border-radius: 10px 10px 0 0;
    }
    .card-body {
      padding: 20px;
    }
    .card-title {
      /*font-size: 1.2rem;*/
      /*font-weight: bold;*/
      font-size: 16px;
    font-weight: 500;
    }
 

</style>

@endsection

@section('content')
@php
$breadcrumb_schema = [ ['name'=>__('lang.Home'),'url'=>url('/')],['name'=> __('lang.blog'),'url'=> request()->fullUrl()]];
@endphp
@include("components.breadcrumb")

<!-- Blog 2 - Bootstrap Brain Component -->
<section class="py-3 py-md-5 py-xl-8">
    <div class="container">
      <div class="row justify-content-md-center">
        <div class="col-12 col-md-10 col-lg-8 col-xl-7 col-xxl-6">
          <h1 class="mb-4 display-5 text-center h2">{{ __('lang.blog') }}</h1>
          <p class="text-secondary mb-5 text-center lead fs-4">{{ __('lang.description_blog') }}</p>
          <hr class="w-50 mx-auto mb-5 mb-xl-9 border-dark-subtle">
        </div>
      </div>
    </div>
  
    <div class="container overflow-hidden">
      <div class="row">
    <!-- Blog Post Card -->
    @foreach($posts as $p)
    <div class="col-md-3 mb-5">
      <div class="card h-100">
        <img src="{{ Request::root() . '/dashboard/images/' . $p->image }}" class="card-img-top" alt="Post Image" style="
    height: 300px;" >
        <div class="post-date">{{$p->created_at}}</div>
        <div class="card-body">
        <h2 class="card-title h5">
  <a href="{{ route('blog.detail_post', ['slug' => app()->getLocale() == 'ar' ? $p->slug_ar : $p->slug_en]) }}">
    {{ app()->getLocale() == 'ar' ? $p->title_ar : $p->title_en }}
  </a>
</h2>
        
        </div>
      </div>
    </div>
    @endforeach
    
    <!-- Repeat the card for each blog post -->
   
  </div>
    </div>
  </section>

@endsection

@section('js')

<script type="application/ld+json">
  {
    "@context": "https://schema.org/",
    "@type": "BreadcrumbList",
    "itemListElement": [
      {
        "@type": "ListItem",
        "position": 1,
        "name": "{{ __('lang.Home') }}",
        "item": "{{ route('home') }}"
      },
      {
        "@type": "ListItem",
        "position": 2,
        "name": "{{ __('lang.blog') }}",
        "item": "{{ request()->fullUrl() }}"
      }
    ]
  }
</script>

@endsection


