
@extends('layouts.front_layout')

  @if( app()->getLocale() == 'en' )
     
     @section('title', $seo?->meta_title_en)
@section("description",$seo?->meta_description_en)
@section("canonical",$seo?->canonical_en)
@else
@section('title', $seo?->meta_title_ar)
@section("description",$seo?->meta_description_ar)
@section("canonical",$seo?->canonical_ar)


@endif
@section("css")
<link rel="stylesheet" type="text/css" href="{{asset('style.css')}}" />


<style>
    body{
        background: none !important;
    }
    .main-wrapper{
        background: unset !important;
    }
    .container-condition .card {
      border: 2px solid #ddcdda90;
    }
    .tap-condition li button{
        color: #782569;
    }
   .container-condition .card p{
    padding: 1rem
   }
    @media (min-width: 992px) {

        .tap-condition li{
        margin-top: 5px;
        border: 1px solid #782569;
        background: #782569;
    }
    .tap-condition li button{
        display: inline-block;
        width: 100%;
        color: white;
    }

    }
    [type=number]{
        direction: unset;
    }
    .form-select{
        font-size:  var(--font-size-b2);
    }
    input[type=checkbox]{
        position:unset !important ;
        opacity: 1;
    }
    iframe{
        height: 1350px !important;
    }
   .form-builder--item a{
       display: none
   }

</style>

@endsection
@section('content')

  @php
    $breadcrumb_schema = [ ['name'=>__('lang.Home'),'url'=>url('/')],['name'=> __('lang.installment'),'url'=> request()->fullUrl()]];
@endphp
@include("components.breadcrumb")


    <div class="container installment mt-5 mb-3">
        <div class="container mt-5 container-condition mb-5">
            <h2 class="text-center mb-3">{{__("lang.Conditions_financing")}}</h2>
          <div class="row">
            <!-- Tabs on top for small screens, on the left for larger screens -->
            <div class="col-md-3 px-0">
              <ul class="nav nav-tabs flex-row flex-md-column tap-condition" id="myTab" role="tablist">
                <li class="nav-item" role="presentation">
                  <button class="nav-link " id="tab1-tab" data-bs-toggle="collapse" data-bs-target="#content1" aria-expanded="true">{{__("lang.nationality")}}</button>
                </li>
                <li class="nav-item" role="presentation">
                  <button class="nav-link" id="tab2-tab" data-bs-toggle="collapse" data-bs-target="#content2" aria-expanded="false">{{__("lang.liabilities")}}</button>
                </li>
                <li class="nav-item" role="presentation">
                  <button class="nav-link" id="tab3-tab" data-bs-toggle="collapse" data-bs-target="#content3" aria-expanded="false"> {{__("lang.duration")}}</button>
                </li>
                <li class="nav-item" role="presentation">
                  <button class="nav-link" id="tab4-tab" data-bs-toggle="collapse" data-bs-target="#content4" aria-expanded="false">{{__("lang.salary")}}</button>
                </li>
              </ul>
            </div>
        
            <!-- Tab contents on the right for large screens, below tabs for small screens -->
            <div class="col-md-9 mt-3 mt-md-0">
              <div class="tab-content">
                <div id="accordion">
                  <div id="content1" class="collapse show" data-bs-parent="#accordion">
                    <div class="card card-body">
                      <p>{{__("lang.body_nationality")}}</p>
                    </div>
                  </div>
                  <div id="content2" class="collapse" data-bs-parent="#accordion">
                    <div class="card card-body">
                      <p>{{__("lang.body_liabilities")}}</p>
                    </div>
                  </div>
                  <div id="content3" class="collapse" data-bs-parent="#accordion">
                    <div class="card card-body">
        
                      <p>{{__("lang.body_duration_sa")}}</p>
                    </div>
                    <div class="card card-body mt-1">
                      <p>{{__("lang.body_duration")}} </p>
                    </div>
                  </div>
                  <div id="content4" class="collapse" data-bs-parent="#accordion">
                    <div class="card card-body">
                     <p>{{__("lang.body_salary_sa")}}</p>
                    </div>
                    <div class="card card-body mt-1">
                      <p>{{__("lang.body_salary")}}</p>
                       </div>
                       
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="my-form p-3">
            <div class="installment-header m-auto">
                <div class="row">
                    <!--<div class="col col-5 col-md-12 text-center">-->
                    <!--    <img src="{{asset('./assests/logo.svg')}}" alt="logo" class="p-2 w-100" />-->
                    <!--</div>-->
                    <div class=" col-md-12 text-center">
                        <h2 class="color-1  my-0">سجل طلبك</h2>
                        <p class="">سنقوم بدراسته فوراً والتواصل معك</p>
                    </div>
                </div>
            </div>

            <iframe
            src="https://link.sawacrm.com/widget/form/nAqcx1rIC3ZwOs78bN1k"
            style="width:100%;height:100%;border:none;border-radius:3px"
            id="inline-nAqcx1rIC3ZwOs78bN1k" 
            data-layout="{'id':'INLINE'}"
            data-trigger-type="alwaysShow"
            data-trigger-value=""
            data-activation-type="alwaysActivated"
            data-activation-value=""
            data-deactivation-type="neverDeactivate"
            data-deactivation-value=""
            data-form-name="فورم خاص بالموقع الالكتروني"
            data-height="936"
            data-layout-iframe-id="inline-nAqcx1rIC3ZwOs78bN1k"
            data-form-id="nAqcx1rIC3ZwOs78bN1k"
            title="فورم خاص بالموقع الالكتروني"
                >
          </iframe>
        

        </div>
    </div>
@endsection

@section("js")
<script type="application/ld+json">
  {
    "@context": "https://schema.org/", 
    "@type": "BreadcrumbList", 
    "itemListElement": [{
      "@type": "ListItem", 
      "position": 1, 
      "name": "الرئسية",
      "item": "{{ route('home') }}"  
    },{
      "@type": "ListItem", 
      "position": 2, 
      "name": "طلب تقسيط",
      "item": "{{ request()->fullUrl() }}"  
    }]
  }
  </script>
<script src="https://link.sawacrm.com/js/form_embed.js"></script>



@endsection
