@extends('layouts.front_layout')


@if( app()->getLocale() == 'en' )
     
@section('title', $seo?->meta_title_en)
@section("description",$seo?->meta_description_en)
@section("canonical",$seo?->canonical_en)
@else
@section('title', $seo?->meta_title_ar)
@section("description",$seo?->meta_description_ar)
@section("canonical",$seo?->canonical_ar)

@endif

@section("meta")
@php use Illuminate\Support\Str; @endphp
@if (Str::contains(Request::url(), 'shop'))
<meta name="robots" content="noindex, follow">
@endif

@endsection

@section("css")
<style>
    .red-color{
    color: red !important;
}
.preorder{
    position: absolute;
    /* bottom: 42rem; */
    top: 2rem;
    z-index: 1000;
    background: #ffd24f;
        right: 31%;
    border-radius: 10px;
    color: white;
    padding: 2px;
    font-weight: 500;
}
.axil-section-gap{
    padding: 65px 0
}
  .quickview button {
            border-radius: 50%;
            width: 40px;
            height: 40px;
            line-height: 32px;
            border: 1px solid #782569 !important;
            border-radius: 50% !important;
            background-color: #eee9ed !important;
            display: block;
            text-align: center;
            transition: .3s;
            position: relative;
            font-size: 14px;
            color: var(--color-heading);
            box-shadow: 0 16px 32px 0 rgba(0, 0, 0, .06);
            position: relative;
            z-index: 1;
            padding: 0px !important;
        }

        @media(max-width:750px) {
            .quickview button {
                border-radius: 4px !important;


            }
        }

        .quickview button i {
            transition: all .3sease-in-out;
        }
        .description h6
        {
            width:32%;
        }
        .description-text{
                background-color: #782569;
        }

</style>
@endsection

@section('content')

    <!-- Product Quick View Modal Start -->
    <div class="modal fade quick-view-product" id="quick-view-modal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="far fa-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="single-product-thumb">
                        <div class="row">
                            <div class="col-lg-7 mb--40">
                                <div class="row">
                                    <div class="col-lg-10 order-lg-2">
                                        <div
                                            class="single-product-thumbnail product-large-thumbnail axil-product thumbnail-badge zoom-gallery">
                                            <div class="thumbnail">
                                                <img id="product-image"
                                                     src="{{ asset('web/assets/images/product/product-big-01.png') }}"
                                                     alt="Product Images">
                                                <div class="label-block label-right">
                                                    <div class="product-badget" id="dicount_text">0 % OFF</div>
                                                </div>
                                                <div class="product-quick-view position-view">
                                                    <a id="popup_image"
                                                       href="{{ asset('web/assets/images/product/product-big-01.png') }}"
                                                       class="popup-zoom">
                                                        <i class="far fa-search-plus"></i>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-2 order-lg-1" id="sadsads">
                                        <div class="product-small-thumb small-thumb-wrapper" id="show_images">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-5 mb--40">
                                <div class="single-product-content">
                                    <div class="inner">
                                        <div class="product-rating">
                                            <div class="star-rating" id="div_reviews">
                                                <i class="fal fa-star" id="box_reviews"></i>
                                                <i class="fal fa-star" id="box_reviews"></i>
                                                <i class="fal fa-star" id="box_reviews"></i>
                                                <i class="fal fa-star" id="box_reviews"></i>
                                                <i class="fal fa-star" id="box_reviews"></i>
                                            </div>
                                            <div class="review-link">
                                                <a>(<span id="count_reviews"></span> {{ __('lang.customer_reviews') }})</a>
                                            </div>
                                        </div>
                                        <h3 id="product-title" class="product-title">Serif Coffee Table</h3>
                                        <span id="product-price" class="price-amount">
                                            $255.00
                                        </span>
                                        {{-- <ul class="product-meta">--}}
                                        {{-- <li><i class="fal fa-check"></i>In stock</li>--}}
                                        {{-- <li><i class="fal fa-check"></i>Free delivery available</li>--}}
                                        {{-- <li><i class="fal fa-check"></i>Sales 30% Off Use Code: MOTIVE30</li>--}}
                                        {{-- </ul>--}}
                                        <div class="description row" id="show_descriptions">
                                            <div class="d-flex align-items-center col-sm-12" id="show_description"
                                                 style="margin-bottom: 3px">
                                                <h6 class="mb-0">
                                                    title_en
                                                </h6>
                                                <div class="box-container d-flex flex-wrap mx-3">
                                                <span class="description-text">
                                                    option_ar
                                                </span>
                                                    <span class="description-text">
                                                   other_option_en
                                                </span>

                                                </div>
                                            </div>
                                        </div>

                                        <div class="product-variation">
                                            <h6 class="title">{{ __('lang.Colors') }}:</h6>
                                            <!-- mona color radio button -->
                                            <div class="box-color d-flex" id="products_colors">
                                                <div class="container-color-box d-flex mb-4" id="product_colors">
                                                    <input name="colorcolor" class="color" type="radio"
                                                           id="color-#000000"
                                                           value="#000000" data-color="#000000"/>
                                                    <label for="color-#000000"></label>
                                                </div>
                                            </div>
                                            <!-- end -->
                                        </div>

                                        <!-- Start Product Action Wrapper  -->
                                        <div class="product-action-wrapper d-flex-center">
                                            <!-- Start Product Action  -->
                                            <ul class="product-action d-flex-center mb--0">
                                                <div class="pro-qty mr--20">
                                                    <span class="dec qtybtn">-</span>
                                                    <input type="text" name="quantity" id="out_quantity_out" value="1">
                                                    <span class="inc qtybtn">+</span>
                                                </div>
                                                <li class="add-to-cart">
                                                    <form action="{{ route('cart.store') }}" method="POST">
                                                        @csrf

                                                        <input type="hidden" name="color" id="colorForm_colorForm">

                                                        <input type="hidden" name="quantity" id="in_quantity_in">

                                                        <input type="hidden" name="product_id" id="product_iddd">

                                                        <button type="submit" id="cart-btn" class="add-product">
                                                            {{ __('lang.add-cart') }}
                                                        </button>
                                                    </form>
                                                </li>
                                                <li class="wishlist" id="add_favadd_fav" style="cursor: pointer">
                                                    <a>
                                                        <button class="axil-btn wishlist-btn">
                                                            <i class="bi bi-heart-fill  red-color " id="heart"></i>
                                                        </button>
                                                    </a>
                                                </li>
                                            </ul>
                                            <!-- End Product Action  -->

                                        </div>
                                        <!-- End Product Action Wrapper  -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Product Quick View Modal End -->

@if($single_product)
<!-- Start Breadcrumb Area  -->
<div class=" d-md-block axil-breadcrumb-area p-2" >
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6 col-md-8">
                <div class="inner">
                    <ul class="axil-breadcrumb">
                        <li class="axil-breadcrumb-item"><a href="{{ url('/') }}">{{ __('lang.Home') }}</a></li>
                        <li class="separator"></li>
                                               <li class="axil-breadcrumb-item active" aria-current="page">{{app()->getLocale()=='ar'?$cat_seo->name_ar:$cat_seo->name_en}}</li>

                    </ul>
                  
                </div>
            </div>
            
        </div>
    </div>
</div>
<!-- End Breadcrumb Area  -->
@endif
<div class="container text-center pt-4">
    <h1 class="fs-3" style="font-weight: 600;">
       @if (app()->getLocale() == 'ar')
                <a href="{{ url('https://newnetwork.sa/ar/installment') }}"> {{ $cat_seo?->desc_ar }} </a>
            @else
                <a href="{{ url('https://newnetwork.sa/en/installment') }}"> {{ $cat_seo?->desc_en }}</a>
            @endif
    </h1>
</div>


<!-- Start Shop Area  -->
<div class="axil-shop-area axil-section-gap">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="axil-shop-top">
                    <form action="{{ route('product.index') }}" method="get">
                        <div class="row">
                            <div class="col-lg-8">
                                <div class="category-select">
                                    <!-- Start Single Select  -->
                                    <select class="single-select" name="category">
                                        <option value="">{{ __('lang.Categories') }}</option>
                                        @foreach($cat as $cat)
                                        <option value="{{ $cat->id }}" @if(request()->input('category') == $cat->id) selected="selected" @endif>
                                            @if(\Illuminate\Support\Facades\App::getLocale() == 'en')
                                            {{ $cat->name_en }}
                                            @else
                                            {{ $cat->name_ar }}
                                            @endif
                                        </option>
                                        @endforeach
                                    </select>
                                    <!-- End Single Select  -->

                                    
                                </div>
                                <!-- <div class="category-select mt_md--10 mt_sm--10 justify-content-lg-start"> -->
                                <!-- Start Single Select  -->

                                <!-- End Single Select  -->
                                <!-- </div> -->
                            </div>
                            <div class="col-lg-4 d-flex justify-content-between align-items-center btn-box">

                                <div class="category-select category-submit justify-content-lg-between">
                                    <button type="submit" class="btn-search">{{ __('lang.search') }}</button>
                                </div>
                                <a class="reset h-100 btn-reset" href="{{ url('/products') }}">{{ __('lang.Reset') }}</a>

                            </div>

                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="row row--15 product-min-size">
            @foreach($products_s as $product)
            <div class="col-6 col-sm-6 col-xl-2 col-lg-3 position-relative  ">
                 @if($product->preorder==1)
                <span class="preorder">طلب مسبق</span>
                @endif
                <div class="axil-product product-style-one has-color-pick mt--40">
                    <div class="thumbnail">
                        <a href="{{ route('product.show', ['id' => $product->id]) }}">
                            <img src="{{ Request::root() . '/dashboard/images/' . $product->image }}" 
                            alt=
                            "{{ 
         app()->getLocale() == 'ar' 
             ? (!empty($product->alt_ar) ? $product->alt_ar : $product->name_ar)
             : (!empty($product->alt_en) ? $product->alt_en : $product->name_en)
     }}"
                            >
                        </a>
                        @if($product->discount > 0)
                        <div class="label-block label-right">
                            <div class="product-badget">{{ $product->discount }}% Off</div>
                        </div>
                        @endif
                        <div class="product-hover-action">
                            <ul class="cart-action">
                                <li class="quickview">
                                    <a href="#" data-bs-toggle="modal" class="eye-modal" data-id="{{ $product->id }}" data-bs-target="#quick-view-modal">
                                        <i class="far fa-eye"></i>
                                    </a>
                                </li>
                                <li class="quickview select-option select-option1">
                                   <form class="addToCartForm" method="POST">

                                                <input type="hidden" name="product_id" value="{{ $product->id }}">
                                                <input type="hidden" name="quantity" value="1">
                                                <input type="hidden" name="flag" value="1">
                                                {{-- @php
                                                        $colors = json_decode($product->colors, true);
                                                    @endphp --}}
                                                @php
                                                    $color = null;
                                                @endphp
                                                @foreach ($product->colors as $colors)
                                                    @php
                                                        $color = $colors->color;
                                                        break;
                                                    @endphp
                                                @endforeach
                                                <input type="hidden" name="color" value="{{ $color }}">

                                                <button type="submit" class="addToCartFormbtn" style="color: white" disabled>
                                                    {{-- {{ __('lang.Select_Option') }} --}}
                                                    <i class="fas fa-shopping-bag"></i>
                                                </button>
                                            </form>
                                </li>
                                <li class="wishlist" id="add_fav" style="cursor: pointer" data-id="{{ $product->id }}">
                                    <a>
                                        @forelse ($product->favorite as $favorites)
                                            @if(\Illuminate\Support\Facades\Auth::user())
                                                @if($favorites->user_id == \Illuminate\Support\Facades\Auth::user()->id)
                                                    <i class="bi bi-heart-fill  red-color" id="heart"></i>
                                                    @break
                                                @else
                                                    <i class="bi bi-heart-fill " id="heart"></i>
                                                    @break
                                                @endif
                                                @break
                                            @else
                                                <i class="bi bi-heart-fill " id="heart"></i>
                                                @break
                                            @endif
                                        @empty
                                            <i class="bi bi-heart-fill " id="heart"></i>
                                        @endforelse
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="product-content">
                        <div class="inner">
                            <h5 class="title">
                                <a href="{{ route('product.show' , $product->id) }}">
                                    @if( app()->getLocale() == 'en' )
                                    {{ $product->name_en }}
                                    @elseif( app()->getLocale() == 'ar' )
                                    {{ $product->name_ar }}
                                    @endif
                                </a>
                            </h5>
                            <div class="product-price-variant">
                                @if($product->discount > 0)
                                <span class="price old-price">
                                    {{  number_format( $product->price  + (($tax_tax/100) * $product->price) ) }}
                                    
                                        <i class="sicon-sar"></i>
                                    
                                </span>
                                <span class="price current-price">{{ number_format(($product->price-($product->price*$product->discount/100))  + (($tax_tax/100) * $product->price) ) }}
                                
                                  <i class="sicon-sar"></i>
                                
                                </span>
                                @else
                                <span class="price current-price">
                                    {{  number_format( $product->price  + (($tax_tax/100) * $product->price)) }}
                                    
                                        <i class="sicon-sar"></i>
                                    
                                </span>
                                @endif
                            </div>
                            <span class="text-tax">{{__('lang.tax_pro')}}</span>
                            <div class="color-variant-wrapper">
                                <ul class="color-variant">

                                    @foreach($product->colors as $colors)
                                    <li class="mx-2 color-extra-01">
                                        <!-- <span class="color-name mx-2 py-1 px-3"> ${color}</span> -->
                                        <span style="background-color:{{ $colors->color }}" class="color"></span>
                                    </li>
                                        <!-- <li class="mx-2 color-extra-01">
                                            <span class="color-name mx-2 py-1 px-3">{{ $colors->color }}</span>
                                        </li> -->
                                    @endforeach
{{--                                    </li>--}}
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Single Product  -->
            @endforeach
        </div>
    </div>
    <!-- End .container -->
</div>
<!-- End Shop Area  -->


<!-- Start Axil Newsletter Area  -->
{{-- <div class="axil-newsletter-area axil-section-gap pt--0" id='subscribe'>
    <div class="container">
        <div class="etrade-newsletter-wrapper bg_image bg_image--5" style="background-image: url({{ asset('web/assets/images/istockphoto.jpg') }})">
            <div class="newsletter-content">
                <span class="title-highlighter highlighter-primary2">
                    <i class="fas fa-envelope-open"></i>{{ __('lang.Newsletter') }}</span>
                <h2 class="title mb--40 mb_sm--30">{{ __('lang.Get_weekly_update') }}</h2>
                <form action="{{ route('subscribe.store') }}" method="POST">
                    @csrf

                    <div class="input-group newsletter-form">
                        <div class="position-relative newsletter-inner mb--15">
                            <input placeholder="example@gmail.com" type="text" name="email" class="@error('email') is-invalid @enderror">
                        </div>
                        <button type="submit" class="axil-btn mb--15">
                            {{ __('lang.subscribe') }}
                        </button>
                    </div>
                    @error('email')
                    <div class="alert text-danger mt-2">{{ $message }}</div>
                    @enderror
                </form>
            </div>
        </div>
    </div>
    <!-- End .container -->
</div> --}}
<!-- End Axil Newsletter Area  -->

@endsection
@section('js')
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="{{ asset('dashboard/assets/plugins/custom/datatables/datatables.bundle.js') }}"></script>
  <script>
        $(document).ready(function() {
             $(".addToCartFormbtn").prop("disabled", false);
            $('.addToCartForm').on('submit', function(e) {

                e.preventDefault(); // Prevent normal form submission
                e.stopPropagation();

                let formData = $(this).serialize(); // Serialize form data

                $.ajax({
                    url: "{{ route('cart.store') }}",
                    type: "POST",
                    data: formData,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') // CSRF token
                    },
                    success: function(response) {

                      console.log(response['quantity_false']) ;
                         if(response['quantity_false']=='1')
                         {
                          Swal.fire({
                            position: 'top-end',
                            // title: 'الكمية نفذت',
                            title:"عزيزي العميل الكمية نفذت لهذه المنتج",
                            showConfirmButton: false,
                            icon: 'error',
                            timer: 3000
                        });
                         }
                         
                         else
                         {
                        $('.cart-count').text(response['data']);
                        Swal.fire({
                            position: 'top-end',
                            title: '{{ __('lang.add_salla') }}',
                            showConfirmButton: false,
                            icon: 'success',
                            timer: 3000
                        });
                         }


                    },
                    error: function(xhr) {
                        console.log(xhr.responseText); // Log error to console
                        alert("Something went wrong. Please try again.");
                    }
                });
                return false;
            });
        });
    </script>

<script>
    $(".qtybtn").on("click", function () {
        var $button = $(this);
        var oldValue = $button.parent().find("input").val();
        if ($button.hasClass("inc")) {
            var newVal = parseFloat(oldValue) + 1;
        } else {
            // Don't allow decrementing below zero
            if (oldValue > 0) {
                var newVal = parseFloat(oldValue) - 1;
            } else {
                newVal = 0;
            }
        }
        $button.parent().find("input").val(newVal);
    });
    $(document).on('click', '#cart-btn', function (e) {

        var quantity = $('#out_quantity').val();

        $('#in_quantity').attr('value', quantity);

        var color = $('input[name="color"]:checked').data('color');

        $('#colorForm').val(color);

    });

    $(document).on('click', '#add_fav', function(e) {
        var id = $(this).data('id');
        if ('{{ \Illuminate\Support\Facades\Auth::user() }}') {
            $(this).children('a').children('#heart').toggleClass("red-color");
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'POST',
                url: '{{ route("product.add_fav") }}',
                data: {
                    'user_id': '{{ \Illuminate\Support\Facades\Auth::id() }}',
                    'product_id': id,
                },
                success: function(response) {
                    
                     if(response=="add Done")
                    {
                        Swal.fire({
                                position: 'top-end',
                                title: '{{ __('lang.add_fav') }}',
                                showConfirmButton: false,
                                icon: 'success',
                                timer: 3000
                            });
                    }
                    else
                    {
                        Swal.fire({
                                position: 'top-end',
                                title: '{{ __('lang.delet_fav') }}',
                                icon: 'success',
                                showConfirmButton: false,
                                timer: 3000
                            });
                    }

                    
                    
                }
            });
        } else {
            window.location.href = "{{ route('login') }}";
        }
    });
</script>

<script>
    var lang = '{{ \Illuminate\Support\Facades\App::getLocale() }}';
    $('.eye-modal').click(function () {
        var id = $(this).data('id');
        $.ajax({
            type: 'get',
            url: "{{ url('products/getData') }}/" + id,
            success: function (data) {
                console.log(data);
                $('#out_quantity_out').val(1);
                $('#product_iddd').attr('value', data.product.id);
                $('#add_favadd_fav').attr('data-id', data.product.id);
                var product_qty = $('#product_qty').val();
                $('#in_quantity').attr('value', product_qty);
                $('#product-image').attr('src', '')
                $('#product-image').attr('src', '/dashboard/images/' + data.product.image)
                $('#product-title').text('')
                if (lang == 'en') {
                    $('#product-title').text(data.product.name_en);
                } else {
                    $('#product-title').text(data.product.name_ar);
                }
                $('#product-price').text('')
                $('#product-price').text(data.product.price)
                $('#description').text('')
                // if (lang == 'en') {
                //     $('#description').text(data.product.des_en);
                // } else {
                //     $('#description').text(data.product.des_ar);
                // }
                $('#popup_image').attr('href', '');
                $('#popup_image').attr('href', '/dashboard/images/' + data.product.image);
                $('#dicount_text').text('');
                if (data.product.discount > 0 ) {
                    $('#dicount_text').css('display' , 'inline-flex').text(data.product.discount + ' % OFF');
                } else {
                    $('#dicount_text').css('display' , 'none');
                }
                $('#count_reviews').text(data.product.reviews_count);
                const boxes = document.querySelectorAll('#show_img');
                boxes.forEach(box => {
                    box.remove();
                });
                data.product.imageable.forEach(myFunction);

                function myFunction(item) {
                    html(item.image);
                }

                const boxColors = document.querySelectorAll('#product_colors');
                boxColors.forEach(box => {
                    box.remove();
                });
                data.product.colors.forEach(myFunction2);
                console.log(data.product.colors);

                function myFunction2(item) {
                    html2(item);
                    $('input[name="color_input"]').attr('checked', 'checked');

                }


                const box_reviews = document.querySelectorAll('#box_reviews');
                box_reviews.forEach(box => {
                    box.remove();
                });

                if (data.product.reviews_sum_rate != null) {
                    for (var i = 1; i <= data.product.reviews_sum_rate / data.product.reviews_count; i++) {
                        const show_reviews = document.getElementById("div_reviews");
                        let reviews = `
                        <i class="fas fa-star" id="box_reviews"></i>
                        `;
                        show_reviews.insertAdjacentHTML("afterbegin", reviews);
                    }
                } else {
                    const show_reviews = document.getElementById("div_reviews");
                    let reviews = `
                                <i class="fal fa-star" id="box_reviews"></i>
                                <i class="fal fa-star" id="box_reviews"></i>
                                <i class="fal fa-star" id="box_reviews"></i>
                                <i class="fal fa-star" id="box_reviews"></i>
                                <i class="fal fa-star" id="box_reviews"></i>
                        `;
                    show_reviews.insertAdjacentHTML("afterbegin", reviews);
                }

                const show_description = document.querySelectorAll('#show_description');
                show_description.forEach(box => {
                    box.remove();
                });

                console.log(data.product.specifications);
                data.product.specifications.forEach(myFunction3);

                function myFunction3(item) {
                    html3(item);
                }

                if (data.product.favorite.length != 0) {
                    $('#add_favadd_fav').children('a').children('button').children('.fa-heart').addClass("red-color-single");
                } else {
                    $('#add_favadd_fav').children('a').children('button').children('.fa-heart').removeClass("red-color-single");
                }
                // $('#add_favadd_fav').attr('data-id', data.product.id);

            },
            error: function (data) {
                console.log('data')
            },

        });
    });

    function html(image) {
        const show_images = document.getElementById("show_images");
        let business = `
               <div class="small-thumb-img" id="show_img">
                    <img src="{{ Request::root() . '/dashboard/images/'}}${image}"
                        alt="thumb image">
                </div>`;
        show_images.insertAdjacentHTML("afterbegin", business);
    }

    function html2(color) {
        const show_color = document.getElementById("products_colors");
//             let cc = `
//             <!--                 <div class="container-color-box d-flex" id="product_colors">-->
// <!--                    <p style="color: black; margin: 5px"></p>-->
// <!--                    <input name="color" class="color color_input" type="radio" id="${color}"-->
//                             value="${color}" data-color="${color}"/>
// <!--                    <label-->
// <!--                        class="color-name d-flex justify-content-center align-items-center mx-2 py-1 px-3"-->
// <!--                        for="${color}">-->
// <!--                        ${color}-->
// <!--                    </label>-->
// <!--                </div>-->
// `;
//             let colors = `
//                 <li class="mx-2 color-extra-01" id="product_colors">
//                     <span style="background-color:${color}" class="color"></span>
//                 </li>`;
        let colors = `
                <div class="container-color-box d-flex mb-4" id="product_colors">
                    <input name="color_input" class="color" type="radio" id="color-${color.id}"
                        value="${color.id}" data-color="${color.color}"/>
                    <label for="color-${color.id}" style="--myVar:${color.color};"></label>
                </div>
                `;
        show_color.insertAdjacentHTML("afterbegin", colors);
    }

    function html3(description) {
        const show_descriptions = document.getElementById("show_descriptions");
        if (lang == 'ar') {
            if (description.other_option_ar != null) {
                var descriptions = `
                <div class="d-flex align-items-center col-sm-12" id="show_description" style="margin-bottom: 3px">
                    <h6 class="mb-0">
                    ${description.title_ar}
                    </h6>
                    <div class="box-container d-flex flex-wrap mx-3">
                        <span class="description-text">
                            ${description.option_ar}
                        </span>
                        <span class="description-text">
                            ${description.other_option_ar}
                        </span>
                    </div>
                </div>
                `;
            } else {
                var descriptions = `
                <div class="d-flex align-items-center col-sm-12" id="show_description" style="margin-bottom: 3px">
                    <h6 class="mb-0">
                    ${description.title_ar}
                    </h6>
                    <div class="box-container d-flex flex-wrap mx-3">
                        <span class="description-text">
                            ${description.option_ar}
                        </span>
                    </div>
                </div>
                `;
            }

        } else {
            if (description.other_option_en != null) {
                var descriptions = `
                <div class="d-flex align-items-center col-sm-12" id="show_description" style="margin-bottom: 3px">
                    <h6 class="mb-0">
                    ${description.title_en}
                    </h6>
                    <div class="box-container d-flex flex-wrap mx-3">
                        <span class="description-text">
                            ${description.option_en}
                        </span>
                        <span class="description-text">
                            ${description.other_option_en}
                        </span>
                    </div>
                </div>
                `;
            } else {
                var descriptions = `
                <div class="d-flex align-items-center col-sm-12" id="show_description" style="margin-bottom: 3px">
                    <h6 class="mb-0">
                    ${description.title_en}
                    </h6>
                    <div class="box-container d-flex flex-wrap mx-3">
                        <span class="description-text">
                            ${description.option_en}
                        </span>

                    </div>
                </div>
                `;
            }

        }

        show_descriptions.insertAdjacentHTML("afterbegin", descriptions);
    }


    // $(document).on('click', '#add_favadd_fav', function (e) {
    $('#add_favadd_fav').click(function (e) {
        e.preventDefault();
        //     $(document).off("click", "#add_favadd_fav").on("click", "#add_favadd_fav", function (e) {
        var id = $(this).data('id');
        if ('{{ \Illuminate\Support\Facades\Auth::user() }}') {
            $(this).children('a').children('button').children('#heart').toggleClass("red-color");
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'POST',
                url: '{{ route("product.add_fav") }}',
                data: {
                    'user_id': '{{ \Illuminate\Support\Facades\Auth::id() }}',
                    'product_id': id,
                },
                success: function (response) {
                }
            });
        } else {
            window.location.href = "{{ route('login') }}";
        }
    });

    $(document).on('click', '.add-product', function (e) {
        var quantity = $('#out_quantity_out').val();

        $('#in_quantity_in').val(quantity);

        var color = $('input[name="color_input"]:checked').data('color');


        $('#colorForm_colorForm').val(color);

    });
</script>

 <script type="application/ld+json">
    {
      "@context": "https://schema.org/",
      "@type": "BreadcrumbList",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "{{ __('lang.Home') }}",
          "item": "{{ route('home') }}"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "{{ $cat_seo 
              ? (app()->getLocale() == 'ar' 
                  ? $cat_seo->name_ar 
                  : $cat_seo->name_en) 
              : __('lang.Products') }}",
          "item": "{{ request()->fullUrl() }}"
        }
      ]
    }
    </script>


@endsection
