<div class="address-slider-wrapper">
<div class="address-slider d-flex ">
    @foreach ($addresses as $address)
        <div class="address-item flex-shrink-0 me-3 {{ $loop->first ? 'checked' : '' }}">
            <div class="card-adress p-3 border rounded">
                <input type="radio" class="d-none" name="address_id" id="address-{{ $address->id }}"
                    value="{{ $address->id }}" {{ $loop->first ? 'checked' : '' }}>
                <label class="d-block w-100" for="address-{{ $address->id }}">
                    <div class="d-flex mb-2">
                        <span class="color1">{{ __('lang.country') }} :</span>
                        <span
                            class="mx-2">{{ app()->getLocale() == 'en' ? $address->country->name_en : $address->country->name_ar }}</span>
                    </div>
                    <div class="d-flex mb-2">
                        <span class="color1">{{ __('lang.city') }} :</span>
                        <span
                            class="mx-2">{{ app()->getLocale() == 'en' ? $address->cities->name_en : $address->cities->name_ar }}</span>
                    </div>
                    <div class="d-flex mb-2">
                        <span class="color1">{{ __('lang.street') }} :</span>
                        <span class="mx-2">{{ $address->street }}</span>
                    </div>
                    <div class="d-flex mb-2">
                        <span class="color1">{{ __('lang.District') }} :</span>
                        <span class="mx-2">{{ $address->district }}</span>
                    </div>
                </label>
            </div>
        </div>
    @endforeach
</div>
</div>