@extends('layouts.front_layout')

@if( app()->getLocale() == 'en' )
     
@section('title', $seo?->meta_title_en)
@section("description",$seo?->meta_description_en)
@section("canonical",$seo?->canonical_en)
@else
@section('title', $seo?->meta_title_ar)
@section("description",$seo?->meta_description_ar)
@section("canonical",$seo?->canonical_ar)


@endif

@section('content')
@php
$breadcrumb_schema = [ ['name'=>__('lang.Home'),'url'=>url('/')],['name'=> __('lang.contact'),'url'=> request()->fullUrl()]];
@endphp
@include("components.breadcrumb")

    @if($single_product)
        <!-- Start Breadcrumb Area  -->
       
        <!-- End Breadcrumb Area  -->
    @endif

    <style>
        .form-group input,
        .form-group textarea{
            background-color: transparent;
            border: none;
            border-radius: 0px;
            font-size: 14px;
            border-bottom: #908E98 1px solid;
        }
        .axil-contact-page .form-group input{
            height: 40px;
        }

        .form-group input:focus{
            background-color: #fff !important;
            border: none;
            border-bottom: #908E98 1px solid;
        }

        .form-group i {
            position: absolute;
            right: 10px;
            top: 15px;
            font-size: 20px;
        }
    </style>
    <!-- Start Contact Area  -->
    <div class="axil-contact-page-area axil-section-gap">
        <div class="container">
            <div class="axil-contact-page">
                <div class="row row--30">
                    <div class="col-lg-8">
                        <div class="contact-form bg-white p-4 rounded-3">
                            <h1 class="title mb--10 h3">{{ __('lang.We_would') }}</h1>
                            <p>{{ __('lang.If_you’ve') }}</p>
                            <form action="{{ route('contact-us.store') }}" method="POST">
                                @csrf
                                @method('POST')
                                <div class="row row--10">
                                    <div class="col-lg-4">
                                        <div class="form-group position-relative">
                                            {{-- <label for="contact-name">{{ __('lang.name') }} <span>*</span></label> --}}
                                            <input type="text" placeholder="{{ __('lang.name') }}" class="@error('name') is-invalid @enderror" name="name" id="contact-name">
                                            @error('name')
                                                <div class="alert text-danger mt-2">{{ $message }}</div>
                                            @enderror
                                            <i class="fas fa-user"></i>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="form-group position-relative">
                                            {{-- <label for="contact-phone">{{ __('lang.phone') }} <span>*</span></label> --}}
                                            <input type="text" placeholder="{{ __('lang.phone') }}" class="@error('phone') is-invalid @enderror" name="phone" id="contact-phone">
                                            @error('phone')
                                                <div class="alert text-danger mt-2">{{ $message }}</div>
                                            @enderror
                                            <i class="fas fa-phone"></i>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="form-group position-relative">
                                            {{-- <label for="contact-email">{{ __('lang.email') }} <span>*</span></label> --}}
                                            <input type="email" class="@error('email') is-invalid @enderror" placeholder="{{ __('lang.email') }}" name="email" id="contact-email">
                                            @error('email')
                                                <div class="alert text-danger mt-2">{{ $message }}</div>
                                            @enderror
                                            <i class="fas fa-envelope"></i>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group position-relative">
                                            <textarea class="@error('massage') is-invalid @enderror" placeholder="{{ __('lang.Your_Message') }}" name="message" id="message" cols="1" rows="1"></textarea>
                                            @error('message')
                                                <div class="alert text-danger mt-2">{{ $message }}</div>
                                            @enderror
                                            <i class="fas fa-sticky-note"></i>
                                        </div>
                                        {{-- <div class="form-group">
                                            <label for="contact-message">{{ __('lang.Your_Message') }}</label>
                                            <textarea class="@error('massage') is-invalid @enderror"  name="message" id="message" cols="1" rows="2"></textarea>
                                            @error('message')
                                                <div class="alert text-danger mt-2">{{ $message }}</div>
                                            @enderror
                                        </div> --}}
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group mb--0 text-center">
                                            <button name="submit" type="submit" id="submit" class="axil-btn btn-search p-3">{{ __('lang.Send_Message') }}</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div class="contact-location mb--40">
                            <h4 class="title mb--20">{{ __('lang.Our_Store') }}</h4>
                            <span class="address mb--20">
                                <i class="fas fa-location-circle color1"></i>
                                @if(\Illuminate\Support\Facades\App::getLocale() == 'ar')
                                    {{ \App\Models\Settings::where('key_id' , 'location_ar')->first()->value }}
                                @else
                                    {{ \App\Models\Settings::where('key_id' , 'location_en')->first()->value }}
                                @endif
                            </span>
                            <span class="phone"><i class="fas fa-phone color1"></i>
                                {{ __('lang.phone') }}: {{ \App\Models\Settings::where('key_id' , 'phone')->first()->value }}
                            </span>
                            <span class="email">
                                <i class="fas fa-envelope-open color1"></i>
                                {{ __('lang.email') }}: {{ \App\Models\Settings::where('key_id' , 'email')->first()->value }}
                            </span>
                        </div>
                        <div class="opening-hour">
                            <h4 class="title mb--20">{{ __('lang.Opening_Hours') }}:</h4>
                            <p>
                                @if(\Illuminate\Support\Facades\App::getLocale() == 'ar')
                                    {{ \App\Models\Settings::where('key_id' , 'opening_hours_ar')->first()->value }}
                                @else
                                    {{ \App\Models\Settings::where('key_id' , 'opening_hours_en')->first()->value }}
                                @endif
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Start Google Map Area  -->
            <div class="axil-google-map-wrap axil-section-gap pb--0">
                <div class="mapouter">
                    <div class="gmap_canvas">
                        <iframe width="1080" height="500" id="gmap_canvas" src="https://www.google.com/maps/embed/v1/search?q=الشبكة+الجديدة+لبيع+وتقسيط+الجوالات&key=AIzaSyBFw0Qbyq9zTFTd-tUY6dZWTgaQzuU17R8"></iframe>
                    </div>
                </div>
            </div>
             <!-- End Google Map Area  -->  
        </div>
    </div>
    <!-- End Contact Area  -->
@endsection


@section('js')

<script type="application/ld+json">
  {
    "@context": "https://schema.org/",
    "@type": "BreadcrumbList",
    "itemListElement": [
      {
        "@type": "ListItem",
        "position": 1,
        "name": "{{ __('lang.Home') }}",
        "item": "{{ route('home') }}"
      },
      {
        "@type": "ListItem",
        "position": 2,
        "name": "{{ __('lang.contact') }}",
        "item": "{{ request()->fullUrl() }}"
      }
    ]
  }
</script>

@endsection

