@extends('layouts.front_layout')

@section('title', __('lang.cart'))

@section("css")

<style>
    @media only screen and (max-width: 767px) {
    .axil-product-table tbody tr {
    border-bottom: solid 1px #9e4185;
    }
    .product-color div{
        margin:auto;
    }
    }
    .tabbyPromo{
      background-color: #ddcdda !important;
    font-weight: 600 !important;
    }
    
    
    .pro-qty .text-left {
            width: auto;
            float: none;
        }
        @media only screen and (max-width: 767px) {
    .product-color div {
        margin:unset !important;
        margin-right: auto !important;
    }
    [lang="en"]  .product-color div {
          margin:unset !important;
        margin-left: auto !important;
    }
    
}

        /*td.product-quantity {*/

        /*    position: relative;*/
        /*    left: 5rem;*/
        /*}*/

        /*[lang="en"] td.product-quantity {*/
        /*    position: unset;*/

        /*}*/
    
    
</style>
@endsection

@section('content')
    <!-- Start Cart Area  -->
    <div class="axil-product-cart-area">
        <div class=" container-fluid">
            <div class="row">
                <div class="col col-12 col-sm-12 col-lg-8 pt-5">
                    <div class="axil-product-cart-wrap">
                        <div class="data-render">
                            @include('web.cart.table-data')
                        </div>
                    </div>
                </div>
                <div class="col col-12 col-sm-12 col-lg-4 order-summary pt-5">
                    <div id="TabbyPromo" class="card TabbyPromo" style="background-color: #ddcdda !important; font-weight: 600 !important; "></div>
                    <div id="tabby"></div>
                    
                     
                      <div class="container">
                            <div class="row shadow-sm py-3 mb-4 mt-3">
                          <div class="col-9">
                            <p>
                {{ app()->getLocale() == 'ar' 
    ? 'قسم فاتورتك بقيمة حتى 12 دفعة بدون رسوم تأخير' 
    : 'Split your bill into up to 12 payments with no late fees' }}
                            </p>
                        </div>
                        <div class="col-3 text-end">
                            <img src="{{ asset('Tamara_Logo-EN-3000x973.png') }}" width="72" height="28" alt="">
                        </div>
                        
                    </div>
                     <div class="row shadow-sm py-3 mb-4 mt-3">
                                        <div class="col-9">
                                            <p>
                                                {{ __('lang.Split_installments_from_3_to_36_months') }}
                                            </p>
                                        </div>
                                        <div class="col-3 text-end">
                                            <img src="{{ asset('AjFnjbps5KvZ1686217173.png') }}" alt=""
                                                width="72" height="28">
                                        </div>

                                    </div>
                                    
                                     <div class="company-tmoil row shadow-sm  py-3 mb-4 mt-3">
                         <div class="col-9">
                            <p>
                                <a href="{{ route('installment') }}">
                                    {{ __('lang.company_tmoil') }}
                                </a>
                            </p>
                        </div>
                        <div class="col-3 text-end">
                            <i style="font-size: 35px ; color:#670756" class="bi bi-cash-coin"></i>
                        </div>
                       
                    </div>
                          
                      </div>
                    
                   
                     
                    
                    <h4 class="color1 title mt-5 ">
                        {{ __('lang.order_summery') }}
                    </h4>
                    @if( $items->get()->count() > 0 )
                        <div class="cart-update-btn-area">
                            @if( $coupon )
                                <form action="{{ route('cart.coupon') }}" id="coupon_form" method="POST">
                                    @csrf
                                    <div class="input-group product-cupon">
                                        <input placeholder="{{ __('lang.enter_coupon_code') }}" id="input_cancel_coupon" name="coupon"
                                            type="text" disabled>
                                        <div class="product-cupon-btn">
                                            <button type="submit" class="axil-btn btn-outline " id="coupon_cancel"
                                                    style="background-color: red; color: white;">
                                                {{ __('lang.cancel') }}
                                            </button>
                                        </div>
                                    </div>
                                </form>
                                {{-- <span class="text-success">--}}
                                {{-- {{ __('lang.coupon_exists') }}--}}
                                {{-- </span>--}}
                            @else
                                <form action="{{ route('cart.coupon') }}" id="coupon_form" method="POST">
                                    @csrf
                                    <div class="input-group product-cupon">
                                        <div class="text-dark mb-2">{{ __('lang.enter_coupon_code') }}</div>
                                        <input class="input-coupan" placeholder="{{ __('lang.enter_coupon_code') }}" id="coupon" name="coupon" type="text">
                                        <div class="product-cupon-btn w-100">
                                            <button type="submit" class="p-2 ps-4 pe-4 m-3 btn-search float-end w-25 couponBtn">
                                                {{ __('lang.apply') }}
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            @endif
                        </div>
                    @endif

                    @if( $items->get()->count() > 0 )
                        <div class="row orderDetails">
                            <div class="col-12">
                                <div class="axil-order-summery p-3 mb-5 mt-5">
                                    <h5 class="title mb--20">
                                        {{ __('lang.order_summery') }}
                                    </h5>
                                    <div class="summery-table-wrap">
                                        <table class="table  mb--30">
                                            <tbody>
                                            <tr class="order-subtotal">
                    {{--                            <td>--}}
                    {{--                                {{ __('lang.subtotal') }}--}}
                    {{--                            </td>--}}
                    {{--                            <td class="total" id="subtotal">--}}
                    {{--                                {{ round($items->total()) }}--}}
                    {{--                            </td>--}}
                                            </tr>
                    {{--                        <tr class="order-shipping">--}}
                    {{--                            <td>{{ __('lang.shipping') }}</td>--}}
                    {{--                            <td>--}}
                    {{--                                <div class="input-group">--}}
                    {{--                                    <input type="radio" id="shipping_value-0" data-id="0" value="0"--}}
                    {{--                                           class="shipping_value" name="shipping" checked>--}}
                    {{--                                    <label for="shipping_value-0">--}}
                    {{--                                        {{ __('lang.free_shipping') }}</label>--}}
                    {{--                                </div>--}}
                    {{--                                @foreach( $shipping_options as $option )--}}
                    {{--                                    <div class="input-group">--}}
                    {{--                                        <input type="radio" id="shipping_value-{{ $option->id }}"--}}
                    {{--                                               data-id="{{ $option->id }}" class="shipping_value" name="shipping"--}}
                    {{--                                               value="{{ round($option->price) }}">--}}
                    {{--                                        @if( app()->getLocale() == 'en' )--}}
                    {{--                                            <label for="shipping_value-{{ $option->id }}">{{ $option->name_en }}--}}
                    {{--                                                : {{ number_format($option->price , 2)  }}</label>--}}
                    {{--                                        @else--}}
                    {{--                                            <label for="shipping_value-{{ $option->id }}">{{ $option->name_ar }}--}}
                    {{--                                                : {{ number_format($option->price , 2) }}</label>--}}
                    {{--                                        @endif--}}
                    {{--                                    </div>--}}
                    {{--                                @endforeach--}}

                    {{--                            </td>--}}
                    {{--                        </tr>--}}
                                            {{--                        <tr class="order-tax">--}}
                                            {{--                            <td>--}}
                                            {{--                                {{ __('lang.state_tax') }}--}}
                                            {{--                            </td>--}}
                                            {{--                            <td id="tax" data-value="{{ $tax->value }}">--}}
                                            {{--                                {{ $tax->value.' %' }}--}}
                                            {{--                            </td>--}}
                                            {{--                        </tr>--}}
                                            @if( $coupon )
                                                <tr class="order-coupons_des">
                                                    <td>
                                                        {{ __('lang.coupons_des') }}
                                                    </td>
                                                    <td id="coupons_des">
                                                       {{-- {{  $items->total() * ($coupon->coupon->discount / 100)  }} --}}
                                                        {{ Cookie::get('total_ca') }}
                                                    </td>
                                                </tr>
                                            @endif


                                            <tr class="order-total">

                                                <td>
                                                    {{ __('lang.total') }}
                                                    <br>
                                                    <span class="text-tax">{{__('lang.tax_pro')}}</span>
                                                </td>
                                                <input type="hidden" id="total_amount" name="total" value="0">
                                                <td class="text-center">
                                                    <div class="order-total-amount color1">
                                                        
                                                         <img
                                                                class="d-inline mx-2"
                                                                src="{{ asset('web/assets/images/Saudi_Riyal_Symbol.svg') }}"
                                                                width=16>
                                                    </div>
                                                    <a href="{{ route('order.create') }}" class="p-1 mt-1 ps-4 pe-4 btn-search" style="background-color: red !important;" >
                                                        {{ __('lang.process_to_checkout') }}
                                                    </a>
                                                </td>
                                                
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- End Cart Area  -->
@endsection
@section('js')
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <script>
        $('#input_cancel_coupon').attr('disabled', 'disabled');
        $(document).on('click', '.remove-wishlist', function (e) {
            e.preventDefault();

            var id = $(this).data('id');

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ url('cart') }}/" + id,
                type: "DELETE",
                data: {},
                success: function (data) {
                    var total = data.total;
                    var count = data.count;
                    console.log(total);
                    $.ajax({
                        url: "{{ url(app()->getLocale().'/cart') }}",
                        type: "GET",
                    }).done(function (data) {

                        $(".data-render").html(data);
                        let shipping_value = 0;

                        // var tax = $('#tax').data('value');
                        // var val =  parseInt(shipping_value) + parseInt(total) + (parseInt(tax) / 100) * parseInt(total);

                        // total = Math.round(total);
                        total = total;
                        var val = parseInt(shipping_value) + total;
                        // val = Math.round(val);
                        val = val;

                        // var val = (parseInt(tax) / 100) + parseInt(shipping_value) + parseInt(total);

                        if (total == 0) {
                            $('.cart-update-btn-area, .orderDetails').addClass('d-none');
                        } else {
                            $('#total_amount').val(val);
                            $('.order-total-amount').text(val);
                        }

                        $('.cart-count').text(count)
                    });

                },
                error: function (data) {
                    console.log(data);
                },
            })

        });
        $(document).on('click', '.cart-clear', function (e) {
            e.preventDefault();

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('cart.empty') }}",
                type: "POST",
                data: {},
                success: function (data) {
                    var total = data.total;
                    $.ajax({
                        url: "{{ url('/cart') }}",
                        type: "GET",
                    }).done(function (data) {
                        $(".data-render").html(data);
                        let shipping_value = 0;

                        var tax = $('#tax').data('value');

                        // var val =  parseInt(shipping_value) + parseInt(total) + (parseInt(tax) / 100) * parseInt(total);

                        // total = Math.round(total);
                        total = total;
                        var val = parseInt(shipping_value) + total + ((tax / 100) * total);
                        val = val;
                        // var val = (parseInt(tax) / 100) + parseInt(shipping_value) + parseInt(total);

                        if (total == 0) {
                            $('.cart-update-btn-area, .orderDetails').addClass('d-none');
                        } else {
                            $('#total_amount').val(val);
                            $('.order-total-amount').text(val);
                        }

                        $('.cart-count').text(total)

                    });

                },
                error: function (data) {
                    console.log(data);
                },
            })

        });
        // Get Total
        $(document).ready(function (e) {
            let shipping_value = 0;

            // After Shipping Change
            $(document).on('change', '.shipping_value', function (e) {

                var id = $(this).data('id');
                shipping_value = $('#shipping_value-' + id).val();
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    url: '{{ url('cart/update_Shipping') }}',
                    type: 'POST',
                    data: "",
                    success: function (data) {
                        var total = data.total;
                        // var tax = $('#tax').data('value');
                        {{--var val =  parseInt(shipping_value) + {{ $items->total() }} + (parseInt(tax) / 100) * {{ $items->total() }};--}}

                        // total = Math.round(total);
                        total = total;
                        var val = parseInt(shipping_value) + total;
                        // val = Math.round(val);
                        val = val;
                        $('.order-total-amount').text(val.toLocaleString('en-US'));
                        $('#total_amount').val(val);
                    }
                });
            });

            // var tax = $('#tax').data('value');
            var total = {{ $items->total() }};
            {{--var val =  parseInt(shipping_value) + {{ $items->total() }} + (parseInt(tax) / 100) * {{ $items->total() }};--}}
            console.log(total);
            // total = Math.round(total);
            total = total;
            var val = parseInt(shipping_value) + total;
            // val = Math.round(val);
            val = val;
            $('#total_amount').val(val);

            $('.order-total-amount').text(val.toLocaleString('en-US'));
        });
    </script>
    <script>
        $(document).on('click', '.couponBtn', function (e) {
            e.preventDefault();
            var coupon = $('#coupon').val();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: $('#coupon_form').attr('action'),
                type: 'POST',
                data: {
                    coupon: coupon,
                },
                success: function (data) {
                    var total = data.total;
                    var total_ca = data.total_ca;
                    var cart = data.cart;
                    $.ajax({
                        url: "{{ url(app()->getLocale().'/cart') }}",
                        type: "GET",
                    }).done(function (data) {
                        if (cart == 'coupon_end') {
                            Swal.fire({
                                position: 'top-end',
                                title: '{{ __('lang.coupon_end') }}',
                                showConfirmButton: false,
                                timer: 3000
                            });
                        } else if (cart == 'cart_range') {
                            Swal.fire({
                                position: 'top-end',
                                title: '{{ __('lang.not_range') }}',
                                showConfirmButton: false,
                                timer: 3000
                            });
                        } else if (cart == 'coupon_empty') {
                            $('#coupon').val('');
                            Swal.fire({
                                position: 'top-end',
                                title: '{{ __('lang.Code_not_found') }}',
                                showConfirmButton: false,
                                timer: 1500
                            });
                        } else {
                            $('#coupon').val('');
                            Swal.fire({
                                position: 'top-end',
                                title: '{{ __('lang.Discount_done') }}',
                                showConfirmButton: false,
                                timer: 1500
                            });
                            $(".data-render").empty().html(data);
                            let shipping_value = 0;
                            // var tax = $('#tax').data('value');
                            // console.log(total + "t" + discount + "d" + tax);

                            // var value =  (parseInt(shipping_value) + parseInt(total));
                            // value = value - (value * (parseInt(discount) / 100));
                            // value = value + (parseInt(tax) / 100) * value;
                            // total = Math.round(total);
                            total = total;
                            var value = parseInt(shipping_value) + total;
                            value = value;
                            // value = Math.round(value);
                            // var value = (parseInt(tax) / 100) + parseInt(shipping_value) + parseInt(total);
                            if (total == 0) {
                                $('#total_amount').val(0);
                                $('.order-total-amount').text(0);
                                $('#coupons_des').text(0);
                            } else {
                                $('#total_amount').val(value);
                                $('.order-total-amount').text(value.toLocaleString('en-US'))
                                // $('#coupons_des').text(Math.round(total_ca));
                                $('#coupons_des').text(total_ca.toFixed(2));
                            }
                        }
                    });

                },
                error: function (data) {

                }
            })
        });
    </script>
    <script>
        $(document).on('click', '#coupon_cancel', function (e) {
            e.preventDefault();
            var coupon = $('#coupon').val();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: '{{ route('cart.coupon') }}',
                type: 'POST',
                data: {
                    coupon: coupon,
                },

                success: function (data) {
                    var total = data.total;
                    var cart = data.cart;
                    $.ajax({
                        url: "{{ url(app()->getLocale().'/cart') }}",
                    }).done(function (data) {
                        $(".data-render").empty().html(data);
                        let shipping_value = 0;
                        // var tax = $('#tax').data('value');
                        // var value =  parseInt(shipping_value) + parseInt(total) + ((parseInt(tax) / 100) * parseInt(total));

                        // total = Math.round(total);
                        total = total;
                        var value = parseInt(shipping_value) + total;
                        // value = Math.round(value);
                        value = value;

                        // var value = (parseInt(tax) / 100) + parseInt(shipping_value) + parseInt(total);
                        if (total == 0) {
                            // $('#subtotal').text(0);
                            $('#total_amount').val(0);
                            $('.order-total-amount').text(0);
                        } else {
                            // $('#subtotal').text(value);
                            $('#total_amount').val(value);
                            $('.order-total-amount').text(value);
                        }
                         
                        $("#coupons_des").text(0.0);
                        if (cart == 'emptyCoupon') {
                            Swal.fire({
                                position: 'top-end',
                                title: '{{ __('lang.emptyCoupon') }}',
                                showConfirmButton: false,
                                timer: 1500
                            })
                        }
                    });

                },
                error: function (data) {

                }
            })
        });
    </script>
    // error
    <script>
        $(document).on('click', '.qtybtn', function () {
            // $(".qtybtn").on("click", function () {
                var $button = $(this);
                var oldValue = $button.parent().find("input").val();
                if ($button.hasClass("inc")) {
                    var newVal = parseFloat(oldValue) + 1;
                    var type = '+';
                } else {
                    // Don't allow decrementing below zero
                    if (oldValue > 1) {
                        var newVal = parseFloat(oldValue) - 1;
                        var type = '-';
                    } else {
                        newVal = 0;
                        var type = '-';
                    }
                }
                $button.parent().find("input").val(newVal);
                console.log(newVal);
                var id = $(this).data('id');
                var qty = newVal;
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                url: '{{ route("cart.update_cart", ":id") }}'.replace(':id', id),

                    type: 'POST',
                    data: {
                        quantity: qty,
                        type: type,
                    },
                    success: function (data) {
                        var total = data.total;
                        if(data.status == 404){
                            Swal.fire({
                                position: 'top-end',
                                title: '{{ __('lang.quantity_end') }}',
                                showConfirmButton: false,
                                timer: 3000
                            });
                            $button.parent().find("input").val(data.quantity);
                        }else if(data.status == 1000){
                            Swal.fire({
                                position: 'top-end',
                                title: '{{ __('lang.cannot_order_one') }}',
                                showConfirmButton: false,
                                timer: 3000
                            });
                            $button.parent().find("input").val(1);
                        }
                        else {
                            var data_render = $.ajax({
                                url: "{{ url(app()->getLocale().'/cart') }}",
                                type: "GET",
                            }).done(function (data) {
                                $(".data-render").html(data);
                                let shipping_value = 0;
                                // var tax = $('#tax').data('value');

                                // var value = parseInt(shipping_value) + parseInt(total) + (parseInt(tax) / 100) * parseInt(total);
                                // total = Math.round(total);
                                total = total;
                                var value = parseInt(shipping_value) + total;
                                // value = Math.round(value);
                                value = value;
                                // var value = (parseInt(tax) / 100) + parseInt(shipping_value) + parseInt(total);
                                if (total == 0) {
                                    // $('#subtotal').text(0);
                                    $('#total_amount').val(0);
                                    $('.order-total-amount').text(0);
                                } else {
                                    // $('#subtotal').text(value);
                                    $('#total_amount').val(value);
                                    $('.order-total-amount').text(value.toLocaleString('en-US'))
                                }
                            });
                        }

                    },
                    error: function (data) {

                    },
                    // complete: function (data){
                    //     location.reload();
                    // }
                });
            });
    </script>
     <script src="https://checkout.tabby.ai/tabby-promo.js"></script>
    <script>
        window.onload = function() {
            new TabbyPromo({
                selector: '#TabbyPromo', // required, content of tabby Promo Snippet will be placed in element with that selector.
                currency: 'SAR', // required, AED|SAR|KWD only supported, with no spaces or lowercase.
                price: document.getElementById("total_amount").value,
                lang: "{{ app()->getLocale() }}", // Optional, en|ar only supported
                source: 'product', // Optional, snippet placement; `product` for product page and `cart` for cart page.
                publicKey: 'pk_test_31f72d93-d792-4e0d-8147-209ad96a4d73', // required, Public Key
                merchantCode: 'NewNtwrk' // required
            });
        }
    </script>
@endsection
