<div class="product-table-heading">
    <h1 class="color1 title mt-5 h4">{{ __('lang.your_cart') }}</h1>

    @if ($items->get()->count() > 0)
        <form action="#" method="POST">
            @csrf
            <button type="submit" class="cart-clear" style="background-color: transparent;">
                {{ __('lang.clear_cart') }} <i class="bi bi-cart-x" style="font-size: 21px; color: red;"></i>
            </button>
        </form>
    @endif
</div>

<!-- ✅ جدول ديسكتوب فقط -->
<div class="table-responsive d-none d-md-block">
    <table class="custom-cart-table">
        <thead>
            <tr>
                <th></th>
                <th>{{ __('lang.product') }}</th>
                <th></th>
                <th>{{ __('lang.quantity') }}</th>
                <th>{{ __('lang.Colors') }}</th>
                <th>{{ __('lang.subtotal') }}</th>
            </tr>
        </thead>
        <tbody>
            @if ($items->get()->count() > 0)
                @foreach ($items->get() as $item)
                    @php
                        $colors_record = \App\Models\Colors::where('product_id', $item->product->id)
                            ->where('color', $item->color)
                            ->first();
                    @endphp
                    <tr>
                        <td>
                            <form action="{{ route('cart.delete', ['id' => $item->id]) }}">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="remove-wishlist" data-id="{{ $item->id }}">
                                    <i class="fal fa-times"></i>
                                </button>
                            </form>
                        </td>
                        <td>
                            <a href="{{ route('product.show', ['id' => $item->product->id]) }}">
                                <img src="{{ Request::root() . '/dashboard/images/' . ($colors_record?->images?->image ?? $item->product->image) }}"
                                    alt="Product">
                            </a>
                        </td>
                        <td>
                            <a href="{{ route('product.show', ['id' => $item->product->id]) }}">
                                {{ app()->getLocale() === 'ar' ? $item->product->name_ar : $item->product->name_en }}
                                <br>
                                @if ($item->product->discount > 0)
                                    {{ number_format($item->product->price - ($item->product->price * $item->product->discount) / 100 + ($tax_tax / 100) * $item->product->price, 2) }}
                                @else
                                    {{ number_format($item->product->price + ($tax_tax / 100) * $item->product->price) }}
                                @endif
                                <img src="{{ asset('web/assets/images/Saudi_Riyal_Symbol.svg') }}" width="16">
                            </a>
                        </td>
                        <td data-id="{{ $item->id }}">
                            <div class="pro-qty">
                                <span class="dec qtybtn" data-id="{{ $item->id }}">-</span>
                                <input type="number" max="{{ $item->product->quantity }}"
                                    value="{{ $item->quantity }}" class="quantity-input" readonly>
                                <span class="inc qtybtn" data-id="{{ $item->id }}">+</span>
                            </div>
                        </td>
                        <td class="product-color">
                            <div style="background-color: {{ $item->color }};" title="{{ $item->color }}"></div>
                        </td>
                        <td style="font-size: 18px">
                            @if ($item->product->discount > 0)
                                {{ number_format($item->product->price * $item->quantity - ($item->product->price * $item->quantity * $item->product->discount) / 100 + ($tax_tax / 100) * ($item->product->price * $item->quantity), 2) }}
                            @else
                                {{ number_format($item->product->price * $item->quantity + ($tax_tax / 100) * ($item->product->price * $item->quantity)) }}
                            @endif
                            <img src="{{ asset('web/assets/images/Saudi_Riyal_Symbol.svg') }}" width="16"><br>
                            <span class="text-tax">{{ __('lang.tax_pro') }}</span>
                        </td>
                    </tr>
                @endforeach
            @else
                <tr>
                    <td colspan="6" class="text-center text-danger">
                        {{ __('lang.no_product') }}
                    </td>
                </tr>
            @endif
        </tbody>
    </table>
</div>

<!-- ✅ بطاقات للجوال فقط -->

<div class="d-md-none position-relative">
    @if ($items->get()->count() > 0)
        @foreach ($items->get() as $item)
            @php
                $colors_record = \App\Models\Colors::where('product_id', $item->product->id)
                    ->where('color', $item->color)
                    ->first();
            @endphp

            <div class="card mb-3 shadow-sm rounded-4 p-4 mb-4">
                <div class="d-flex">
                    <!-- صورة المنتج -->
                    <div style="width: 100px;">
                        <a href="{{ route('product.show', ['id' => $item->product->id]) }}">
                            <img src="{{ Request::root() . '/dashboard/images/' . ($colors_record?->images?->image ?? $item->product->image) }}"
                                class="img-fluid rounded" style="width: 100%; height: 100px; object-fit: cover;">
                        </a>
                    </div>

                    <!-- التفاصيل -->
                    <div class="ms-3 flex-grow-1 position-relative">
                        <div class="d-flex justify-content-between align-items-start">
                            <div style="flex: 1;">
                                <h6 class="mb-1">
                                    {{ app()->getLocale() === 'ar' ? $item->product->name_ar : $item->product->name_en }}
                                </h6>
                                <!-- السعر -->
                                <div class="d-flex align-items-center gap-2">
                                    @if ($item->product->discount > 0)
                                        <small class="text-decoration-line-through text-muted">
                                            {{ number_format($item->product->price, 2) }}
                                        </small>
                                    @endif
                                    <span class="fw-bold" style="font-size: 16px;">
                                        {{ number_format($item->product->price * $item->quantity - ($item->product->price * $item->quantity * $item->product->discount) / 100 + ($tax_tax / 100) * ($item->product->price * $item->quantity), 2) }}
                                        <img src="{{ asset('web/assets/images/Saudi_Riyal_Symbol.svg') }}"
                                            width="14">
                                    </span>
                                </div>
                            </div>

                            <!-- زر الحذف -->
                            <form class="form-card-remove-phone" action="{{ route('cart.delete', ['id' => $item->id]) }}" method="POST">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="remove-wishlist" data-id="{{ $item->id }}">
                                    <i class="fal fa-times"></i>
                                </button>
                            </form>
                        </div>

                        <!-- الكمية -->
                        <div data-id="{{ $item->id }}" class="container-qty-phone">
                            <div class="pro-qty d-inline">
                                <button class="dec qtybtn" data-id="{{ $item->id }}">-</button>
                                <input name="quantity-input" type="number" max="{{ $item->product->quantity }}"
                                    value="{{ $item->quantity }}" class="quantity-input" readonly>
                                <button class="inc qtybtn" data-id="{{ $item->id }}">+</button>
                            </div>
                        </div>

                        <!-- اللون -->
                        <div class="mt-2 container-color-phone">
                            <span class="small text-muted">{{ __('lang.Colors') }}:</span>
                            <span class="d-inline-block ms-1"
                                style="width: 14px; height: 14px; border-radius: 50%; background-color: {{ $item->color }};"
                                title="{{ $item->color }}"></span>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    @else
        <div class="text-center text-danger my-3">
            {{ __('lang.no_product') }}
        </div>
    @endif
</div>
