@extends('layouts.master')

@section('main_title', 'Home Page')

@section('header_title', 'Home')

@section('subheader_title', '#XV2')

@section('content')
    <div class="card mb-5 mb-xl-8">
        <div class="card-header border-0 pt-5">
            <h3 class="card-title align-items-start flex-column">
                <span class="card-label fw-bolder fs-3 mb-1">تعديل السلايدر</span>
            </h3>
        </div>
        @if ($errors->any())
            <div class="alert alert-danger" style="margin: 15px">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card-body py-3">
            <form action="{{ route('slider.update',['id'=>$slider->id]) }}" method="post" enctype="multipart/form-data">
                @csrf
                <div class="row">
                    <div class="col-md-6 mb-5">
                        <div class="form-group">
                            <label for="title_ar">رابط</label>
                            <input type="text" name="url" class="form-control" value="{{ $slider->url }}" required>
                            @error('title_ar')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6 mb-5">
                        <div class="form-group">
                            <label for="category">الصنف</label>
                            <select class="form-control" name="category_id" id="category">
                                <option value="">الصفحة الرئسية</option>
                                 @foreach($category as $c)
                                 @if($c->id==$slider->category_id)
                                 <option value="{{$c->id}}" selected>{{$c->name_ar}}</option>
                                 @else
                                 <option value="{{$c->id}}">{{$c->name_ar}}</option>

                                 @endif
                                 @endforeach
                            </select>
                            @error('title_ar')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
        
                   
                </div>
        
               
        
                <div class="form-group mb-5">
                    <label for="image">صورة البانر</label>
                    <input type="file" name="image" class="form-control-file" >
                    @error('image')
                        <div class="alert alert-danger mt-2">{{ $message }}</div>
                    @enderror
                </div>
        
                <button type="submit" class="btn btn-primary "> حفظ التعديل</button>


            </form>
        </div>
    </div>
@endsection
