@extends('layouts.master')

@section('main_title', 'Home Page')
@section('header_title', 'Home')
@section('subheader_title', '#XV2')

@section('content')
    <div class="card mb-5 mb-xl-8">
        <div class="card-header border-0 pt-5">
            <h3 class="card-title align-items-start flex-column">
                <span class="card-label fw-bolder fs-3 mb-1">{{ __('lang.updatecat') }}</span>
            </h3>
        </div>
        @if ($errors->any())
            <div class="alert alert-danger" style="margin: 15px">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card-body py-3">
            <form action="{{ route('seo.update_page',['id'=>$seo->id]) }}" method="post" enctype="multipart/form-data">
                @csrf

                <div class="row">
                     

                    <div class="mb-3 col-6">
                        <label for="title_ar" class="form-label">title ar</label>
                        <textarea name="meta_title_ar" class="form-control" id="title_ar" rows="3">{{$seo->meta_title_ar}}</textarea>
                    </div>
                    <div class="mb-3 col-6">
                        <label for="title_en" class="form-label">title en</label>
                        <textarea name="meta_title_en" class="form-control" id="title_ar" rows="3">{{$seo->meta_title_en}}</textarea>
                    </div>
                    
                    <div class="mb-3 col-6">
                        <label for="description_ar" class="form-label">description ar</label>
                        <textarea name="meta_description_ar" class="form-control" id="description_ar" rows="3">{{$seo->meta_description_ar}}</textarea>
                    </div>

                    <div class="mb-3 col-6">
                        <label for="description_en" class="form-label">description en</label>
                        <textarea name="meta_description_en" class="form-control" id="description_en" rows="3">{{$seo->meta_description_en}}</textarea>
                    </div>
                    <div class="mb-3 col-6">
                        <label for="canonical_ar" class="form-label">canonical ar</label>
                        <textarea name="canonical_ar" class="form-control" id="canonical_ar" rows="3">{{$seo->canonical_ar}}</textarea>
                    </div>
                    <div class="mb-3 col-6">
                        <label for="canonical_en" class="form-label">canonical en</label>
                        <textarea name="canonical_en" class="form-control" id="canonical_en" rows="3">{{$seo->canonical_en}}</textarea>
                    </div>


                  

                    <div class="btn-save mt-3">
                        <button type="submit" class="btn btn-info">حفظ</button>
                    </div>

                </div>  
               
            </form>
        </div>
    </div>

@endsection
