@extends('layouts.master')

@section('main_title', 'Home Page')

@section('header_title', 'Home')

@section('subheader_title', '#XV2')

@section('content')
    <div class="card mb-5 mb-xl-8">
        <div class="card-header border-0 pt-5">
            <h3 class="card-title align-items-start flex-column">
                <span class="card-label fw-bolder fs-3 mb-1">تعديل السلايدر</span>
            </h3>
        </div>
        @if ($errors->any())
            <div class="alert alert-danger" style="margin: 15px">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card-body py-3">
            <form action="{{ route('branches.branch.update', ['id' => $branch->id]) }}" method="POST"
                enctype="multipart/form-data">

                @csrf
                <div class="row">
                    <div class="col-md-6 mb-5">
                        <div class="form-group">
                            <label for="title_ar">رابط</label>
                            <input type="text" name="google_link" class="form-control" value="{{ $branch->google_link }}"
                                required>

                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="category">اسم الفرع</label>
                            <input type="text" name="name_ar" class="form-control" value="{{ $branch->name_ar }}"
                                required>


                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="category">ساعات العمل</label>
                            <input type="text" name="working_hours" class="form-control"
                                value="{{ $branch->working_hours }}" required>


                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="category"> الموقع</label>
                            <input type="text" name="location" class="form-control" value="{{ $branch->location }}"
                                required>


                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="category"> الهاتف</label>
                            <input type="text" name="phone" class="form-control" value="{{ $branch->location }}"
                                required>


                        </div>
                    </div>

                </div>





                <button type="submit" class="btn btn-primary "> حفظ التعديل</button>


            </form>
        </div>
    </div>
@endsection
