@extends('layouts.master')

@section('main_title', 'Home Page')

@section('header_title', 'Home')

@section('subheader_title', '#XV2')

@section('content')
    <div class="card mb-5 mb-xl-8">
        <div class="card-header border-0 pt-5">
            <h3 class="card-title align-items-start flex-column">
                <span class="card-label fw-bolder fs-3 mb-1">{{ __('lang.New_post') }}</span>
            </h3>
        </div>
        @if ($errors->any())
            <div class="alert alert-danger" style="margin: 15px">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card-body py-3">
            <form action="{{ route('blogAdmin.store') }}" method="post" enctype="multipart/form-data">
                @csrf
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="title_ar">عنوان المقال (عربي)</label>
                            <input type="text" name="title_ar" class="form-control" value="{{ old('title_ar') }}"
                                oninput="copyField_ar(this.value)" required>
                            @error('title_ar')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="title_en">عنوان المقال (إنجليزي)</label>
                            <input type="text" name="title_en" class="form-control" value="{{ old('title_en') }}"
                                oninput="copyField_en(this.value)" required>
                            @error('title_en')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="content_ar">محتوى المقال (عربي)</label>
                            <textarea name="content_ar" id="content_ar" class="form-control tinymce" rows="5">{{ old('content_ar') }}</textarea>
                            @error('content_ar')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="content_en">محتوى المقال (إنجليزي)</label>
                            <textarea name="content_en" id="content_en" class="form-control tinymce" rows="5">{{ old('content_en') }}</textarea>
                            @error('content_en')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="meta_title_ar">meta title ar</label>
                            <input type="text" id="meta_title_ar" name="meta_title_ar" class="form-control"
                                value="{{ old('meta_title_ar') }}" required>
                            @error('meta_title_ar')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="meta_title_en">meta title en</label>
                            <input type="text" id="meta_title_en" name="meta_title_en" class="form-control"
                                value="{{ old('meta_title_en') }}" required>
                            @error('meta_title_en')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="meta_desc_ar">meta description ar</label>
                            <textarea name="meta_desc_ar" id="meta_desc_ar" class="form-control " rows="5">{{ old('meta_desc_ar') }}</textarea>
                            @error('meta_desc_ar')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="meta_desc_en">meta description ar</label>
                            <textarea name="meta_desc_en" id="meta_desc_en" class="form-control " rows="5">{{ old('meta_desc_en') }}</textarea>
                            @error('meta_desc_en')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="slug_ar">slug ar</label>
                            <input type="text" id="slug_ar" name="slug_ar" class="form-control"
                                value="{{ old('slug_ar') }}" required>
                            @error('slug_en')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="slug_ar">slug en</label>
                            <input type="text" id="slug_en" name="slug_en" class="form-control"
                                value="{{ old('slug_en') }}" required>
                            @error('slug_en')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>


                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="canonical_url_ar">canonical url ar</label>
                            <input type="text" id="canonical_url_ar" name="canonical_url_ar" class="form-control"
                                value="{{ old('canonical_url_ar') }}" required>
                            @error('canonical_url_ar')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="canonical_url_en">canonical url en</label>
                            <input type="text" id="canonical_url_en" name="canonical_url_en" class="form-control"
                                value="{{ old('canonical_url_en') }}" required>
                            @error('canonical_url_en')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                </div>

                <div class="form-group">
                    <label for="image">صورة المقال</label>
                    <input type="file" name="image" class="form-control-file" required>
                    @error('image')
                        <div class="alert alert-danger mt-2">{{ $message }}</div>
                    @enderror
                </div>
                <div class="container-fqa mb-5 mt-5 shadow-sm p-5">
                    <h2>إدخال الأسئلة والأجوبة</h2>

                    <div id="questionContainer"></div>

                    <button type="button" class="btn-fqa btn btn-primary" onclick="addQuestion()"
                        style="position: relative;
    left: 50%;
    z-index: 10000;
    right: 50%;">إضافة سؤال</button>

                </div>

                <button type="submit" class="btn btn-primary ">إنشاء المقال</button>


            </form>
        </div>
    </div>
@endsection
@section('js')
    <!--<script src="https://cdn.tiny.cloud/1/g9uieb5olnqysg3lc2rfft4k9ugrtx1l2s60mvqx8hkksdd8/tinymce/7/tinymce.min.js"
        referrerpolicy="origin"></script>-->
    <script src="https://cdn.tiny.cloud/1/ck45ndr7s2p980n3j5btyvescsat4kmrolihkfnesbozmae6/tinymce/7/tinymce.min.js"
        referrerpolicy="origin"></script>
    <script>
        tinymce.init({
            selector: ".tinymce",
            height: "480",
            menubar: false,
            toolbar: [
                "styleselect fontselect fontsizeselect",
                "undo redo | cut copy paste | bold italic | link image | forecolor backcolor | alignleft aligncenter alignright alignjustify",
                "bullist numlist | outdent indent | blockquote subscript superscript | advlist | autolink | lists charmap | print preview | code | table"
            ],
            plugins: "advlist autolink link image lists charmap print preview code table"
        });
    </script>

    <script>
        let questionCount = 0;

        // Function to add a new question
        function addQuestion() {
            questionCount++;
            const questionContainer = document.getElementById('questionContainer');

            const questionGroup = document.createElement('div');
            questionGroup.className = 'question-group form-group';
            questionGroup.id = `questionGroup_${questionCount}`;

            questionGroup.innerHTML = `
                <label for="question_${questionCount}" class="form-label">السؤال ${questionCount}:</label>
                <input type="text" id="question_${questionCount}" name="questions[${questionCount}][question]" class="form-control" placeholder="أدخل السؤال" required>
    
                <label class="form-label" for="answer_${questionCount}">الإجابة ${questionCount}:</label>
                <textarea id="answer_${questionCount}" name="questions[${questionCount}][answer]" class="form-control" rows="3" placeholder="أدخل الإجابة" required></textarea>
                <button type="button" class="btn btn-danger my-4" onclick="removeQuestion(${questionCount})">حذف السؤال</button>
            `;

            questionContainer.appendChild(questionGroup);
        }

        // Function to remove a question
        function removeQuestion(id) {
            const questionGroup = document.getElementById(`questionGroup_${id}`);
            questionGroup.remove();
        }

        // Handle form submission
        document.getElementById('questionForm').addEventListener('submit', function(e) {
            // e.preventDefault();

            // Here you can handle the form data (e.g., sending it to the server)
            const formData = new FormData(this);
            const data = Object.fromEntries(formData.entries());
            console.log(data);

            alert('تم إرسال البيانات بنجاح!');
        });


        function copyField_ar(value) {
            var secondField = document.getElementById("slug_ar");

            // Replace spaces with underscores
            var modifiedValue = value.replace(/ /g, "-");
            secondField.value = modifiedValue;
            var secondField = document.getElementById("canonical_url_ar");
            secondField.value = "https://newnetwork.sa/ar/detail-post/" + modifiedValue;

        }

        function copyField_en(value) {
            var secondField = document.getElementById("slug_en");
            // Replace spaces with underscores
            var modifiedValue = value.replace(/ /g, "-");
            secondField.value = modifiedValue;
            var secondField = document.getElementById("canonical_url_en");
            secondField.value = "https://newnetwork.sa/en/detail-post/" + modifiedValue;
        }
    </script>




@endsection
