
    <div class="search-result-header">
        <h6 class="title">
            {{ $products->count() }} {{ __('lang.Result Found') }} </h6>
        <a href="{{ route('product.index') }}" class="view-all">
            {{ __('lang.View All') }}
        </a>
    </div>
    <div class="psearch-results">
        <div class="row row--15 product-min-size">
        @foreach($products as $product)
            <div class="col-6 col-sm-6 col-xl-2 col-lg-3">
                <div class="axil-product product-style-one has-color-pick mt--40">
                    <div class="thumbnail">
                        <a href="{{ route('product.show', ['id' => $product->id]) }}">
                            <img src="{{ Request::root() . '/dashboard/images/' . $product->image }}" alt="Product Images">
                        </a>
                        @if($product->discount > 0)
                        <div class="label-block label-right">
                            <div class="product-badget">{{ $product->discount }}% Off</div>
                        </div>
                        @endif
                        <div class="product-hover-action">
                            <ul class="cart-action">
                                <li class="quickview">
                                    <a href="#" data-bs-toggle="modal" class="eye-modal" data-id="{{ $product->id }}" data-bs-target="#quick-view-modal">
                                        <i class="far fa-eye"></i>
                                    </a>
                                </li>
                                <li class="quickview select-option select-option1">
                                    {{-- <button> --}}
                                        <a href="{{ route('product.show' , $product->id ) }}" style="color: white">
                                            {{-- {{ __('lang.Select_Option') }} --}}
                                            <i class="fas fa-shopping-bag"></i>
                                        </a>
                                    {{-- </button> --}}
                                </li>
                                <li class="wishlist" id="add_fav" style="cursor: pointer" data-id="{{ $product->id }}">
                                    <a>
                                        @forelse ($product->favorite as $favorites)
                                            @if(\Illuminate\Support\Facades\Auth::user())
                                                @if($favorites->user_id == \Illuminate\Support\Facades\Auth::user()->id)
                                                    <i class="far fa-heart red-color" id="heart"></i>
                                                    @break
                                                @else
                                                    <i class="far fa-heart" id="heart"></i>
                                                    @break
                                                @endif
                                                @break
                                            @else
                                                <i class="far fa-heart" id="heart"></i>
                                                @break
                                            @endif
                                        @empty
                                            <i class="far fa-heart" id="heart"></i>
                                        @endforelse
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="product-content">
                        <div class="inner">
                            <h5 class="title">
                                <a href="{{ route('product.show' , $product->id) }}">
                                    @if( app()->getLocale() == 'en' )
                                    {{ $product->name_en }}
                                    @elseif( app()->getLocale() == 'ar' )
                                    {{ $product->name_ar }}
                                    @endif
                                </a>
                            </h5>
                            <div class="product-price-variant">
                                @if($product->discount > 0)
                                <span class="price old-price">
                                    {{ __('lang.sar') . ' ' .  number_format( $product->price  + (($tax_tax/100) * $product->price)) }}
                                </span>
                                <span class="price current-price">{{ __('lang.sar') . ' ' .   number_format(($product->price-($product->price*$product->discount/100))  + (($tax_tax/100) * $product->price) ) }}</span>
                                @else
                                <span class="price current-price">
                                    {{ __('lang.sar') . ' ' . number_format( $product->price  + (($tax_tax/100) * $product->price)) }}
                                </span>
                                @endif
                            </div>
                            <span class="text-tax">{{__('lang.tax_pro')}}</span>
                            <div class="color-variant-wrapper">
                                <ul class="color-variant">

                                    @foreach($product->colors as $colors)
                                    <li class="mx-2 color-extra-01">
                                        <!-- <span class="color-name mx-2 py-1 px-3"> ${color}</span> -->
                                        <span style="background-color:{{ $colors->color }}" class="color"></span>
                                    </li>
                                        <!-- <li class="mx-2 color-extra-01">
                                            <span class="color-name mx-2 py-1 px-3">{{ $colors->color }}</span>
                                        </li> -->
                                    @endforeach
    {{--                                    </li>--}}
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            {{-- <div class="axil-product-list">
                <div class="thumbnail">
                    <a href="{{ route('product.show' , $product->id) }}">
                        <img src="{{ Request::root() . '/dashboard/images/' . $product->image }}"
                            width="150" height="150" alt="Yantiti Leather Bags">
                    </a>
                </div>
                <div class="product-content">
                    <div class="product-rating">
                                <span class="rating-icon">
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fal fa-star"></i>
                                </span>
                        <span class="rating-number"><span>100+</span> Reviews</span>
                    </div>
                    <h6 class="product-title">
                        <a href="{{ route('product.show' , $product->id) }}">
                            @if( app()->getLocale() == 'en' )
                                {{ $product->name_en }}
                            @else
                                {{ $product->name_ar }}
                            @endif
                        </a>
                    </h6>
                    <div class="product-price-variant">
                        @if($product->discount > 0)
                            <span class="price old-price">
                                    {{ __('lang.sar') . ' ' . number_format($product->price + (($tax_tax/100) * $product->price) , 2) }}
                                </span>
                            <span class="price current-price">{{ __('lang.sar') . ' ' . number_format(($product->price-($product->price*$product->discount/100))  + (($tax_tax/100) * $product->price) , 2) }}</span>
                        @else
                            <span class="price current-price">
                                    {{ __('lang.sar') . ' ' . number_format($product->price + (($tax_tax/100) * $product->price) , 2) }}
                                </span>
                        @endif
                    </div>
                    <div class="product-cart">
                        <li class="cart-btn" id="add_fav_add_fav" style="cursor: pointer"
                            data-id="{{ $product->id }}">
                            <a>
                                @forelse ($product->favorite as $favorites)
                                    @if(\Illuminate\Support\Facades\Auth::user())
                                        @if($favorites->user_id == \Illuminate\Support\Facades\Auth::user()->id)
                                            <i class="far fa-heart red-color" id="heart"></i>
                                            @break
                                        @else
                                            <i class="far fa-heart" id="heart"></i>
                                            @break
                                        @endif
                                        @break
                                    @else
                                        <i class="far fa-heart" id="heart"></i>
                                        @break
                                    @endif
                                @empty
                                    <i class="far fa-heart" id="heart"></i>
                                @endforelse
                            </a>
                        </li>
                    </div>
                </div>
            </div> --}}
        @endforeach
        </div>
</div>
