@foreach ($sections as $section)
    <div class="axil-product-area axil-section-gap" id='all-products'>
        <div class="container">
            <div class="section-title-wrapper">
                {{-- <span class="title-highlighter highlighter-primary"> <i class="far fa-shopping-basket"></i> {{ __('lang.Our_Products') }}</span> --}}
               <h2 class="title">
    @if(app()->getLocale() == 'ar')
        {{ $section['category']->name_ar }} <!-- النص العربي -->
    @else
        {{ $section['category']->name_en }} <!-- النص الإنجليزي -->
    @endif
</h2>
            </div>
            <div
                class="explore-product-activation slick-layout-wrapper slick-layout-wrapper--15 axil-slick-arrow arrow-top-slide">
                <div class="slick-single-layout">
                    <div class="row row--15">
                        @foreach ($section['products'] as $product)
                            <div class="col-6 col-sm-6 col-xl-3 col-lg-4 col-sm-6 mb--30 position-relative">
                                @if ($product->preorder == 1)
                                    <span class="preorder">طلب مسبق</span>
                                @endif
                                <div class="axil-product product-style-one">
                                    <div class="thumbnail">
                                        <a href="{{ route('product.show', ['id' => $product->id]) }}">
                                            <img data-sal="zoom-out" data-sal-delay="200" data-sal-duration="800"
                                                loading="lazy" class="main-img"
                                                src="{{ Request::root() . '/dashboard/images/' . $product->image }}"
                                                alt="{{ 
         app()->getLocale() == 'ar' 
             ? (!empty($product->alt_ar) ? $product->alt_ar : $product->name_ar)
             : (!empty($product->alt_en) ? $product->alt_en : $product->name_en)
     }}"
                                                            
                                                                                                >
                                                
                                        </a>
                                        @include('components.number_sale')

                                        @if ($product->discount > 0)
                                            <div class="label-block label-right">
                                                <div class="product-badget">{{ number_format($product->discount) }}%
                                                    Off</div>
                                            </div>
                                        @endif
                                        <div class="product-hover-action">
                                            <ul class="cart-action">
                                                <li class="quickview">
                                                    <a href="#" data-bs-toggle="modal" class="eye-modal"
                                                        data-id="{{ $product->id }}"
                                                        data-bs-target="#quick-view-modal">
                                                        <i class="far fa-eye"></i>
                                                    </a>
                                                </li>
                                                <li class="select-option ">
                                                    <button>
                                                        <a href="{{ route('product.show', $product->id) }}"
                                                            style="color: white">
                                                            {{ __('lang.order_now_product') }}
                                                        </a>
                                                    </button>
                                                </li>
                                                <li class="wishlist" id="add_fav" style="cursor: pointer"
                                                    data-id="{{ $product->id }}">
                                                    <a>
                                                        @forelse ($product->favorite as $favorites)
                                                            @if (\Illuminate\Support\Facades\Auth::user())
                                                                @if ($favorites->user_id == \Illuminate\Support\Facades\Auth::user()->id)
                                                                    <i class="bi bi-heart-fill red-color"
                                                                        id="heart"></i>
                                                                    @break

                                                                @else
                                                                    <i class="bi bi-heart-fill" id="heart"></i>
                                                                    @break
                                                                @endif
                                                                @break

                                                            @else
                                                                <i class="bi bi-heart-fill" id="heart"></i>
                                                                @break

                                                            @endif
                                                        @empty
                                                            <i class="bi bi-heart-fill" id="heart"></i>
                                                        @endforelse
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="product-content">
                                        <div class="inner">

                                            <h5 class="title pt-3">
                                                <a href="{{ route('product.show', $product->id) }}">
                                                    @if (app()->getLocale() == 'en')
                                                        {{ $product->name_en }}
                                                    @elseif(app()->getLocale() == 'ar')
                                                        {{ $product->name_ar }}
                                                    @endif
                                                </a>
                                            </h5>
                                            <div class="product-price-variant pt-2">
                                                @if ($product->discount > 0)
                                                    <span class="price old-price">
                                                        {{ number_format($product->price + ($tax_tax / 100) * $product->price) }}
                                                        <i class="sicon-sar"></i>

                                                    </span>
                                                    <span
                                                        class="price current-price">{{ number_format($product->price + ($tax_tax / 100) * $product->price - ($product->price * $product->discount) / 100) }}>
                                                        <i class="sicon-sar"></i>


                                                    </span>
                                                    </span>
                                                @else
                                                    <span class="price current-price">
                                                        {{ number_format($product->price + ($tax_tax / 100) * $product->price) }}
                                                        <i class="sicon-sar"></i>
                                                    </span>
                                                @endif
                                            </div>
                                            <div class="rating position-absolute start-0">
                                                @php
                                                    $randomNumber = rand(40, 50) / 10;
                                                @endphp
                                                <span>{{ $randomNumber }}</span> <i class="bi bi-star-fill"
                                                    style="color: #ffd24f; font-size:20px"></i>
                                            </div>
                                        </div>
                                        {{-- <span class="text-tax">{{__('lang.tax_pro')}}</span> --}}
                                    </div>
                                </div>
                            </div>
                            <!-- End Single Product  -->
                        @endforeach
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12 text-center mt--20 mt_sm--0">
                    <a href="{{ route('product.category', ['id' => $section['category']->id, 'slug' => $section['category']->name_en]) }}"
                        class="axil-btn btn-load-more">
                        {{ __('lang.View_All_Products') }}
                    </a>
                </div>
            </div>

        </div>
    </div>
@endforeach
