@extends('layouts.front_layout')

@section('title', __('lang.verify_otp'))
@section('css')
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('web/assets/images/favicon.png') }}">
    @if (app()->getLocale() == 'en')
        <link rel="stylesheet" href="{{ asset('web/assets/css/style.min.css') }}">
        <style>
            .form-group i {
                position: absolute;
                right: 10px;
                top: 15px;
                font-size: 20px;
            }

            .email-login {
                text-align: start;
            }
        </style>
    @elseif(app()->getLocale() == 'ar')
        <link rel="stylesheet" href="{{ asset('web/rtl_assets/css/style.min.css') }}">
        <style>
            .form-group i {
                position: absolute;
                top: 15px;
                left: 10px;
                font-size: 20px;
            }

            .email-login {
                text-align: end;
            }
        </style>
    @endif

    <style>
        body {
            background-image: url("{{ asset('web/assets/imgs/bg.png') }}");
            background-size: cover;
        }

        .header-style-1 {
            padding-bottom: 5px !important
        }

        .content-auth {
            /* height: 100vh; */
        }

        .form-group input {
            background-color: #fff;
            border: none;
            border-bottom: #908E98 1px solid;
        }

        .form-group input:focus {
            background-color: #fff !important;
            border: none;
            border-bottom: #908E98 1px solid;
        }

        .forgot-btn {
            color: #782569;
        }

        .btn-login {
            background-color: #782569;
            color: #fff;
        }

        .btn-register {
            background-color: #D6AE3E;
            color: #fff;
        }
    </style>
@endsection

@section('content')
    <div class="container content-auth d-flex justify-content-center">
        <div class="row w-100 align-self-center     justify-content-center">
            <div class="col col-12 col-md-6 p-2 p-md-5 align-self-center text-center">
                <h1 class="mt-3">{{ __('lang.verify_otp') }}</h1>
                <x-auth-validation-errors class="mb-4 alert alert-danger" :errors="$errors" />

                <form action="{{ route('verify.otp') }}" method="POST" class="singin-form m-0 p-2 m-md-5 p-md-5">
                    @csrf
                    @method('POST')

                    <div class="form-group position-relative">
                        <input type="text" class="form-control" name="otp" placeholder="{{ __('lang.enter_otp') }}">
                        {{-- <div class="text-start">
                            <a href="{{ route('verify.otp.resend') }}" class="">
                                {{ __('lang.resend_otp') }}
                            </a>
                        </div> --}}

                        <div class="text-start">
                            <button type="button" data-href="{{ route('verify.otp.resend') }}" id="resend-link"
                                class="">
                                {{ __('lang.resend_otp') }}
                            </button>
                        </div>
                    </div>



                    <div class="col col-12 p-3">
                        <button type="submit" class="btn-login axil-btn submit-btn p-3 m-0 m-md-3">
                            {{ __('lang.verify_otp_btn') }}
                        </button>
                    </div>

                </form>
            </div>

        </div>
    </div>
@endsection

@section('js')

    <script src="{{ asset('assets/js/vendor/modernizr.min.js') }}"></script>
    <script src="{{ asset('assets/js/vendor/jquery.js') }}"></script>
    <script src="{{ asset('web/assets/js/vendor/popper.min.js') }}"></script>
    <script src="{{ asset('web/assets/js/vendor/bootstrap.min.js') }}"></script>
    <script src="{{ asset('web/assets/js/vendor/slick.min.js') }}"></script>
    <script src="{{ asset('web/assets/js/vendor/js.cookie.js') }}"></script>
    <script src="{{ asset('web/assets/js/vendor/jquery-ui.min.js') }}"></script>
    <script src="{{ asset('web/assets/js/vendor/jquery.countdown.min.js') }}"></script>
    <script src="{{ asset('web/assets/js/vendor/sal.js') }}"></script>
    <script src="{{ asset('web/assets/js/vendor/jquery.magnific-popup.min.js') }}"></script>
    <script src="{{ asset('web/assets/js/vendor/imagesloaded.pkgd.min.js') }}"></script>
    <script src="{{ asset('web/assets/js/vendor/isotope.pkgd.min.js') }}"></script>
    <script src="{{ asset('web/assets/js/vendor/counterup.js') }}"></script>
    <script src="{{ asset('web/assets/js/vendor/waypoints.min.js') }}"></script>
    <script src="{{ asset('web/assets/js/main.js') }}"></script>

    <script>
        $(document).ready(function() {
            $('#resend-link').click(function() {
                let button = $(this);
                let url = button.data('href');

                // تعطيل الزر

                button.prop('disabled', true).css("opacity", "0.5").text("انتظر 60 ثانية...");


                // إرسال الطلب باستخدام AJAX
                $.ajax({
                    url: url,
                    type: "GET", // غيّرها إلى "POST" إذا كان المسار يحتاج ذلك
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr(
                            'content') // تأكد من وجود الميتا في الـ <head>
                    },
                    success: function(response) {
                        console.log("تم إرسال OTP:", response);
                    },
                    error: function(xhr, status, error) {
                        console.error("خطأ أثناء الإرسال:", error);
                    }
                });

                // إعادة تفعيل الزر بعد 60 ثانية
                let seconds = 60;
                let interval = setInterval(() => {
                    seconds--;
                    button.text(`انتظر ${seconds} ثانية...`);
                    if (seconds <= 0) {
                        clearInterval(interval);
                        button.prop('disabled', false).css("opacity", "1").text(
                            "{{ __('lang.resend_otp') }}");
                    }
                }, 1000);
            });
        });
    </script>




@endsection
