@extends('layouts.front_layout')

@section('title',  __('lang.verify_otp'))
@section('css')
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('web/assets/images/favicon.png') }}">
    @if( app()->getLocale() == 'en')
        <link rel="stylesheet" href="{{ asset('web/assets/css/style.min.css') }}">
        <style>
            .form-group i {
                position: absolute;
                right: 10px;
                top: 15px;
                font-size: 20px;
            }
            .email-login {
                text-align: start;
            }
        </style>
    @elseif( app()->getLocale() == 'ar' )
        <link rel="stylesheet" href="{{ asset('web/rtl_assets/css/style.min.css') }}">
        <style>
            .form-group i {
                position: absolute;
                top: 15px;
                left: 10px;
                font-size: 20px;
            }
            .email-login {
                text-align: end;
            }
        </style>
    @endif

    <style>
        body {
            background-image: url("{{ asset('web/assets/imgs/bg.png') }}");
            background-size: cover;
        }

        .header-style-1 {
            padding-bottom: 5px !important
        }

        .content-auth {
            /* height: 100vh; */
        }

        .form-group input {
            background-color: #fff;
            border: none;
            border-bottom: #908E98 1px solid;
        }

        .form-group input:focus {
            background-color: #fff !important;
            border: none;
            border-bottom: #908E98 1px solid;
        }

        .forgot-btn {
            color: #782569;
        }
        
        .btn-login {
            background-color: #782569;
            color: #fff;
        }

        .btn-register {
            background-color: #D6AE3E;
            color: #fff;
        }
    </style>
@endsection

@section('content')
    <div class="container content-auth d-flex justify-content-center">
        <div class="row w-100 align-self-center     justify-content-center">
            <div class="col col-12 col-md-6 p-2 p-md-5 align-self-center text-center">
                <h1 class="mt-3">{{ __('lang.active_user') }}</h1>
                <p>{{ __('lang.enter_code_active_user') }}</p>
                <x-auth-validation-errors class="mb-4 alert alert-danger" :errors="$errors" />
                
                <form action="{{ route('activate.account') }}" method="POST" class="singin-form m-0 p-2 m-md-5 p-md-5">
                    @csrf
                    @method('POST')

                    <div class="form-group position-relative">
                        <input type="hidden" name="email" value="{{$email}}">
                        <input type="text" class="form-control" name="activation_code" placeholder="{{ __('lang.enter_otp') }}">
                        <div class="text-start">
                           
                        </div>
                    </div>

                   
                       
                        <div class="col col-12 p-3">
                            <button type="submit" class="btn-login axil-btn submit-btn p-3 m-0 m-md-3">
                                {{ __('lang.verify_otp_btn') }}
                            </button>
                        </div>
                    
                </form>
            </div>
           
        </div>
    </div>
@endsection

@section("scripts")
<script src="{{ asset('assets/js/vendor/modernizr.min.js') }}"></script>
<script src="{{ asset('assets/js/vendor/jquery.js') }}"></script>
<script src="{{ asset('web/assets/js/vendor/popper.min.js') }}"></script>
<script src="{{ asset('web/assets/js/vendor/bootstrap.min.js') }}"></script>
<script src="{{ asset('web/assets/js/vendor/slick.min.js') }}"></script>
<script src="{{ asset('web/assets/js/vendor/js.cookie.js') }}"></script>
<script src="{{ asset('web/assets/js/vendor/jquery-ui.min.js') }}"></script>
<script src="{{ asset('web/assets/js/vendor/jquery.countdown.min.js') }}"></script>
<script src="{{ asset('web/assets/js/vendor/sal.js') }}"></script>
<script src="{{ asset('web/assets/js/vendor/jquery.magnific-popup.min.js') }}"></script>
<script src="{{ asset('web/assets/js/vendor/imagesloaded.pkgd.min.js') }}"></script>
<script src="{{ asset('web/assets/js/vendor/isotope.pkgd.min.js') }}"></script>
<script src="{{ asset('web/assets/js/vendor/counterup.js') }}"></script>
<script src="{{ asset('web/assets/js/vendor/waypoints.min.js') }}"></script>
<script src="{{ asset('web/assets/js/main.js') }}"></script>
@endsection
