<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use Illuminate\Http\Client\RequestException;
use Illuminate\Http\Client\ConnectionException;

class TamamService
{
    protected $baseUrl;
    protected $clientId;
    protected $merchantId;
    protected $secretKey;

    public function __construct()
    {
       $this->baseUrl = 'https://uat-s2s-di.tamam.life/sama-digital-installments';
        $this->clientId = config('tamam.client_id');
        $this->merchantId = config('tamam.merchant_id');
        $this->secretKey = config('tamam.merchant_salt');
    }

    protected function generateSignature(array $body): string
    {
        
        // dd($this->secretKey);
        return base64_encode(
            hash_hmac('sha256', json_encode($body), $this->secretKey,true)
        );
    }

    protected function sendRequest(string $endpoint, array $body)
    {
        $signature = $this->generateSignature($body);
        // dd($body ,$signature);
        // dd($signature ,$this->clientId,$this->merchantId,$this->secretKey);

        return Http::timeout(5000000)->withHeaders([
            'X-FOO-Signature' => $signature,
            'X-FOO-Signature-Type' => 'S2S',
            'X-CLIENT-ID' => $this->clientId,
            'Content-Type' => 'application/json',
        ])->post("https://uat-s2s-di.tamam.life/sama-digital-installments/ext/v1/inapp/requestToken", $body)->json();

    }

    public function requestToken(string $orderId): array
    {
        $body = [
            'merchant_id' => $this->merchantId,
            'order_id' => $orderId,
        ];

        return $this->sendRequest('/ext/v1/inapp/requestToken', $body);
    }

    public function initiateOrder(array $data): array
    {
        $body = [
            'app_token' => $data['app_token'],
            'transaction_id' => $data['transaction_id'],
            'redirect_url' => $data['redirect_url'],
            'merchant' => [
                'app_id' => $data['app_id'],
                'merchant_id' => $this->merchantId,
            ],
            'customer' => [
                'customer_name' => $data['customer_name'],
                'customer_address' => $data['customer_address'],
                'national_id' => $data['national_id'],
                'email' => $data['email'],
                'phone' => $data['phone'],
                'dob' => $data['dob'],
            ],
            'order' => [
                'order_id' => $data['order_id'],
                'reference' => $data['reference'],
                'total_amount' => $data['total_amount'],
                'items' => $data['items'],
            ]
        ];

        return $this->sendRequest('/ext/v1/inapp/initiateOrder', $body);
    }
}
