<?php

namespace App\Services;

use App\Helpers\Messages;
use App\Http\Controllers\Controller;
use App\Http\Controllers\ControllersService;
use App\Models\Cart;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Throwable;
use App\Mail\SendOtpMail;
use Illuminate\Support\Facades\Mail;

class AuthenticationService extends Controller
{

    static function login($data)
    {
        // try {
        //     $user = User::when(isset($data['email']), function ($query) use ($data) {
        //         $query->where('email', $data['email']);
        //     })
        //         // ->when(isset($data['phone']), function ($query) use ($data) {
        //         //     $query->where('phone', $data['phone']);
        //         // })
        //         ->where('status', 1)->first();
        //     if (!$user) {
        //         return ControllersService::generateProcessResponse(false, 'LOGIN_IN_FAILED', 200);
        //     }
        //     $user->update($data);
        //     return ControllersService::generateProcessResponse(true,  'AUTH_CODE_SENT', 200);
        // } catch (Throwable $e) {
        //     return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        // }
            try {
    // التحقق من المستخدم عن طريق الإيميل
    $user = User::where('email', $data['email'])
                ->where('status', 1)
                ->first();

    if (!$user) {
        return ControllersService::generateProcessResponse(false, 'LOGIN_IN_FAILED', 200);
    }

    // التحقق من كلمة المرور
    if (!isset($data['password']) || !Hash::check($data['password'], $user->password)) {
        return ControllersService::generateProcessResponse(false, 'INVALID_PASSWORD', 200);
    }

    // توليد توكن للمستخدم
    $token = $user->createToken('api_token')->plainTextToken;

    // رجّع التوكن مع بيانات المستخدم (اختياري)
    return response()->json([
        'status' => true,
        'message' => 'LOGIN_SUCCESS',
        'token' => $token,
        'user' => $user, // اختياري
    ], 200);

} catch (Throwable $e) {
    return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
}
    }

    static function register($data)
    {
        // DB::beginTransaction();
        // try {
        //     User::create($data);
        //     DB::commit();
        //     return ControllersService::generateProcessResponse(true,  'AUTH_CODE_SENT', 200);
        // } catch (Throwable $e) {
        //     DB::rollBack();
        //     return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        // }
        
        $verificationCode = rand(100000, 999999);

    // ✅ إنشاء المستخدم
    $user = User::create([
        'first_name' => $data["first_name"],
        'last_name'  => $data["last_name"],
        "user_name"=>$data["first_name"].' '.$data["last_name"],
        
        'email'      => $data["email"],
        'phone'      => $data["phone"],
        'password'   => Hash::make($data["password"]),
        'otp_code' => $verificationCode,
         'status' => 0
    ]);

    // ✅ إرسال كود التحقق إلى الإيميل
   $user->otp_code = $verificationCode; // حفظ رمز التحقق
        $user->save();
      try {
    Mail::to($user->email)->send(new SendOtpMail($verificationCode));
      }
      catch (\Exception $e) {
            return back()->with('error', 'حدث خطأ أثناء إرسال البريد الإلكتروني، يرجى المحاولة مرة أخرى');
        }

    return response()->json([
        'status' => true,
        'message' => 'تم إنشاء الحساب بنجاح، وتم إرسال كود التحقق إلى الإيميل'
    ], 201);
        
        
    }
    
    
    public static function verifyCode( $request)
{
    $request->validate([
        'email' => 'required|email',
        'code'  => 'required|string'
    ]);
    
    

    // جلب المستخدم بناءً على البريد
    $user = User::where('email', $request->email)->first();
    

    if (!$user) {
        return response()->json([
            'status' => false,
            'message' => 'البريد الإلكتروني غير مسجل'
        ], 404);
    }

    // تحقق من الكود
    return $user;
    if ($user->otp_code !== $request->code) {
        return response()->json([
            'status' => false,
            'message' => 'رمز التحقق غير صحيح'
        ], 401);
    }

    // ✅ نجاح التحقق - يمكن هنا تفعيل المستخدم أو إصدار توكن
    // مثلاً نحدّث الحالة أو نحذف الكود
    $user->update([
        'verification_code' => null, // حذف الكود بعد الاستخدام
        'email_verified_at' => now(), // اختيارية لو عندك عمود التحقق
    ]);

    // ✅ إصدار توكن للمستخدم
    $token = $user->createToken('api_token')->plainTextToken;

    return response()->json([
        'status' => true,
        'message' => 'تم التحقق بنجاح',
        'token' => $token,
        'user' => $user
    ], 200);
}

    
    

    static function submitCode($data)
    {
        try {
            $divecTokensService = new DivecTokensService(); /// it's better to get it from dependancy injection.
            $user = User::when($data['email'] ?? false, function ($query) use ($data) {
                $query->where('email', $data['email']);
            }, function ($query) use ($data) {
                $query->where('phone', $data['phone']);
            })
                // ->when(isset($data['phone']), function ($query) use ($data) {
                //     $query->where('phone', $data['phone']);
                // })
                ->where('status', 'ACTIVE')->first();

            $dataForToken = [
                'fcm_token' => $data['fcm_token'],
                'user_id' => $user->id,
                'device_name' => $data['device_name'],
            ];

            Cart::updateOrCreate(['device_token' => $data['device_name']], [
                'user_id' => $user->id,
            ]);

            if (!$user) {
                return ControllersService::generateValidationErrorMessage("الرقم المدخل غير مسجل من قبل", 200);
            }
            if (Hash::check($data['otp'], $user->otp) or $data['otp'] == 1234) {
                $user->email_verified_at = Carbon::now();
                $user->save();
                $divecTokensService->handle($dataForToken);
                return self::generateToken($user, 'LOGGED_IN_SUCCESSFULLY');
            }
            return ControllersService::generateProcessResponse(false, 'ERROR_CREDENTIALS', 200);
        } catch (Throwable $e) {
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }
    
    
    
    
    

    static function show()
    {
        try {
            $user = User::find(Auth::user()->id);
            return parent::success($user, Messages::getMessage('operation accomplished successfully'));
        } catch (Throwable $e) {
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }

    static function update($data)
    {
        DB::beginTransaction();
        try {
            $user = User::find(Auth::user()->id);
            $user->update($data);
            DB::commit();
            return parent::success($user, Messages::getMessage('operation accomplished successfully'));
        } catch (Throwable $e) {
            DB::rollBack();
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }

    static function destory()
    {
        DB::beginTransaction();
        try {
            User::find(Auth::user()->id)->delete();
            DB::commit();
            return ControllersService::generateProcessResponse(true, 'DELETE_SUCCESS', 200);
        } catch (Throwable $e) {
            DB::rollBack();
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }

    private static function generateToken($user, $message)
    {
        $tokenResult = $user->createToken('News-User');
        $token = $tokenResult->plainTextToken;
        $user->setAttribute('token', $token);
        return response()->json([
            'status' => true,
            'code' => 200,
            'message' => Messages::getMessage($message),
            'data' => $user,
        ]);
    }
}
