<?php

namespace App\Providers;

use App\Models\Categories;
use App\Models\Products;
use App\Models\Settings;
use App\Repositories\Cart\CartRepository;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\URL;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
         $customOrder = ['جوالات', 'اكسسوارات', 'بلايستيشن', 'لابتوبات', 'شاشات', 'مكيفات', 'غسالات', 'ثلاجات'];
        $placeholders = implode(',', array_fill(0, count($customOrder), '?'));
        
         view()->composer('*',function($view)  use ($customOrder, $placeholders) {
            $view->with('cart',  new CartRepository());
            $view->with('products',  Products::tableFilters()->where('status' , 1)->where('type', 'NOT LIKE', '%apple_care%')->orderBy('order_sort', 'asc')->get());
            $view->with('categories_key',   Categories::where('status', '1')->whereNull('parent_id')->orderByRaw("FIELD(name_ar, $placeholders)", $customOrder)->get());
            $view->with('tax_tax',  Settings::where('key_id' , 'tax')->first()->value);
        });

        
        // view()->composer('*',function($view) {
        //     $view->with('cart',  new CartRepository());
        //     $view->with('products',  Products::tableFilters()->where('status' , 1)->where('type', 'NOT LIKE', '%apple_care%')->orderBy('order_sort', 'asc')->get());
        //     $view->with('categories_key',  Categories::where('status' , 1)->whereNull("parent_id")->with('products')->orderBy('order_sort', 'asc')->get());
        //     $view->with('tax_tax',  Settings::where('key_id' , 'tax')->first()->value);
        // });

        // $this->app->bind(ProductInterface::class, function () {
        //     return new ProductBuilder();
        // });
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Schema::defaultStringLength(191);
        
       
        
    }
}
