<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VisitedProduct extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'cookie_id',
        'product_id',
    ];


    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Relation to the Product model.
     */
    public function product()
    {
        return $this->belongsTo(Products::class);
    }
}
