<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Tag extends Model
{
    use HasFactory;
    protected $fillable = ['name'];

    public function products()
    {
        return $this->belongsToMany(Products::class);
    }
      protected static function booted()
    {
        static::created(function ($tag) {
            // تحديث خريطة الموقع عندما يتم إنشاء منتج جديد
            app()->make('App\Http\Controllers\dashboard\SitemapController')->updateSitemap($tag, 'tag');
        });
    }
}
