<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Database\Eloquent\Relations\MorphOne;

class Products extends Model
{

    protected $table = 'products';
    public $timestamps = true;
    protected $fillable = array('category_id', 'code', 'name_en', 'name_ar',
    'price', 'des_en', 'des_ar', 'tax', 'status', 'image', 'discount', 'quantity', 'appear' , 'sku','weight','alt_ar','alt_en','related_products');

    public static $rules = [
        'name_ar' => 'required|min:3|max:255',
        'name_en' => 'required|min:3|max:255',
        'category_id' => 'required|integer|exists:categories,id',
        'price' => 'required|numeric|min:1',
//        'discount' => 'required|numeric',
        'test.*.quantity' => 'required|numeric|min:1',
        'test.*.colors' => 'required',

        'specifications.*.title_en' => 'required|min:1|max:255',
        'specifications.*.title_ar' => 'required|min:1|max:255',
        'specifications.*.option_en' => 'required|min:1|max:255',
        'specifications.*.option_ar' => 'required|min:1|max:255',
        'specifications.*.other_option_en' => 'nullable|min:1|max:255',
        'specifications.*.other_option_ar' => 'nullable|min:1|max:255',
//        'des_en' => 'required|min:3|max:255',
//        'des_ar' => 'required|min:3|max:255',
//        'image' => 'nullable|image',
    ];

    public static $rules2 = [
        'name_ar' => 'required|min:3|max:255',
        'name_en' => 'required|min:3|max:255',
        'category_id' => 'required|integer|exists:categories,id',
        'price' => 'required|numeric|min:1',
//        'discount' => 'required|numeric',
        'test.*.quantity' => 'required|numeric',
        'test.*.colors' => 'required',
        'specifications.*.title_en' => 'required|min:1|max:255',
        'specifications.*.title_ar' => 'required|min:1|max:255',
        'specifications.*.option_en' => 'required|min:1|max:255',
        'specifications.*.option_ar' => 'required|min:1|max:255',
        'specifications.*.other_option_en' => 'nullable|min:1|max:255',
        'specifications.*.other_option_ar' => 'nullable|min:1|max:255',
//        'des_en' => 'required|min:3',
//        'des_ar' => 'required|min:3',
        'image' => 'nullable|image',
    ];

    public function categories(){
        return $this->belongsTo('\App\Models\Categories' , 'category_id'  , 'id');
    }

    /**
     * Get the post's image.
     */
    public function images(): MorphMany
    {
        return $this->morphMany(Images::class, 'imageable');
    }

    public function imageable()
    {
        return $this->hasMany(Images::class, 'imageable_id');

    }

    public function reviews(){
        return $this->hasMany('\App\Models\Reviews' , 'product_id'  , 'id');
    }

    public function reviews2(){
        return $this->hasMany('\App\Models\Reviews' , 'product_id'  , 'id')->where('user_id' , auth()->user()->id ?? 0);
    }

    public function colors(){
        return $this->hasMany('\App\Models\Colors' , 'product_id'  , 'id');
    }

    public function specifications(){
        return $this->hasMany('\App\Models\Specifications' , 'product_id'  , 'id');
    }

    public function favorite(){
        return $this->hasMany('\App\Models\Favorite' , 'product_id'  , 'id')->where('user_id' , auth()->user()->id ?? 0);
    }

    public function scopeTableFilters($query)
    {
        $lang = app()->getLocale();

        return $query->when(request()->input('name_en', false), function ($query, $name) use ($lang) {
//        dd($query);
            return $query->where("name_$lang", 'like', '%' . $name . '%');
        });

    }
     public function tags()
    {
        return $this->belongsToMany(Tag::class, 'product_tag');
    }
     protected static function booted()
    {
        static::created(function ($product) {
            // تحديث خريطة الموقع عندما يتم إنشاء منتج جديد
            app()->make('App\Http\Controllers\dashboard\SitemapController')->updateSitemap($product, 'product');
        });
    }
    
       public function children()
    {
        return $this->hasMany(Products::class, 'parent_product_id');
    }

    public function parent()
    {
        return $this->belongsTo(Products::class, 'parent_product_id');
    }
     public function views()
    {
        return $this->hasMany(ProductView::class);
    }
     public function scopeFilter(Builder $builder, $filters)
    {
        $filters = array_merge([
            'name' => null,
            'type' => null,
            'category' => null,
            'from' => null,
            'to' => null,
            'myFavorite' => null,
        ], $filters);

        $builder->when($filters['name'], function ($builder, $value) {
            $builder->where('products.title_ar', 'like', '%' . $value . '%')
                ->orWhere('products.title_en', 'like', '%' . $value . '%');
        });

        // $builder->when($filters['type'], function ($builder, $value) {
        //     $builder->where('products.type', $value);
        // });

        $builder->when($filters['category'], function ($builder, $value) {
            $builder->where('products.category_id', $value);
        });

        $builder->when($filters['from'], function ($builder, $value) {
            $builder->where('products.price', '>=', $value);
        });

        $builder->when($filters['to'], function ($builder, $value) {
            $builder->where('products.price', '<=', $value);
        });

        $builder->when($filters['myFavorite'], function ($q) {
            $q->whereHas('favorites', function ($q) {
                $q->where('products.user_id', Auth::user()->id);
            });
        });
    }
    
    
    
    
}
