<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Loyalty extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id', 'product_id', 'delivery_method'
    ];

    // علاقة مع مودل المستخدم
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // علاقة مع مودل المنتج
    public function product()
    {
        return $this->belongsTo(Products::class);
    }
}
