<?php

namespace App\Mail;

use App\Models\Carts;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class AbandonedCartReminder extends Mailable
{
    use Queueable, SerializesModels;

    public $product;
    public $user;

    public function __construct($user, $product)
    {
        $this->user = $user;
        $this->product = $product;
    }

    public function build()
    {
        return $this->subject('منتجاتك ما زالت في السلة 🛒')
            ->view('emails.abandoned_cart');  // ربط البريد بالقالب الذي صممته
    }
}
