<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CartItemResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'master_image' => $this->variant ? $this->variant->image : $this->product->master_image,
            'title_ar' => $this->product->title_ar,
            'title_en' => $this->product->title_en,
            'quantity' => $this->quantity . '',
            'price' =>  $this->variant ? (string) $this->variant->price : (string) $this->product->price,
            'discount' => $this->variant ? (string) $this->variant->discount : (string) $this->product->discount,
        ];
    }
}
