<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class RemoveWWW
{
    public function handle(Request $request, Closure $next)
    {
        // التحقق إذا كان الرابط يحتوي على www
        if (strpos($request->getHost(), 'www.') === 0) {
            // إعادة توجيه إلى الرابط بدون www
            $newUrl = $request->getScheme() . '://' . str_replace('www.', '', $request->getHost()) . $request->getRequestUri();
            return redirect($newUrl, 301); // 301 تعني إعادة توجيه دائمة
        }

        return $next($request);
    }
}
