<?php

namespace App\Http\Controllers\web;

use App\Http\Controllers\Controller;
use App\Models\Products;
use Illuminate\Http\Request;

class SearchController extends Controller
{
//     public function search(Request $request)
//     {

// //        $products = Products::tableFilters()->get();

//         $products = Products::query()->with('favorite' , 'colors')->where("status",1);
//         if (request()->input('name_en', false)) {
//             $queryString = request()->input('name_en');
//     $queryString = strtolower($queryString); // نحول قيمة البحث إلى حروف صغيرة

//     $products->where(function($query) use ($queryString) {
//         $query->whereRaw('LOWER(name_en) LIKE ?', ["%$queryString%"])
//               ->orWhereRaw('LOWER(name_ar) LIKE ?', ["%$queryString%"]);
//     })->limit(2);
//         }

//         if ( $request->ajax() )
//         {
//             return view('components.search' , compact('products'))->render();
//         }
//     }
    public function search(Request $request)
    {
        $products = Products::query()
            ->with('favorite', 'colors')
            ->where('status', 1)
            ->where('type', '!=', 'apple_care');

        if ($request->filled('name_en')) {
            $queryString = strtolower(trim($request->input('name_en')));
            $keywords = array_filter(explode(' ', $queryString)); // إزالة الفراغات الزائدة

            $products->where(function ($query) use ($keywords) {
                foreach ($keywords as $index => $word) {
                    if ($index == 0) {
                        // للكلمة الأولى استخدم where
                        $query->where(function ($q) use ($word) {
                            $q->whereRaw('LOWER(name_en) LIKE ?', ["%$word%"])
                                ->orWhereRaw('LOWER(name_ar) LIKE ?', ["%$word%"]);
                        });
                    } else {
                        // لباقي الكلمات استخدم orWhere
                        $query->orWhere(function ($q) use ($word) {
                            $q->whereRaw('LOWER(name_en) LIKE ?', ["%$word%"])
                                ->orWhereRaw('LOWER(name_ar) LIKE ?', ["%$word%"]);
                        });
                    }
                }
            });
        }

        $products = $products->limit(5)->get();

        if ($request->ajax()) {
            return view('components.search', compact('products'))->render();
        }

        return response()->json([
            'count' => $products->count(),
            'data' => $products
        ]);
    }

}
