<?php

namespace App\Http\Controllers\web;

use App\Http\Controllers\Controller;
use App\Models\Categories;
use App\Models\Colors;
use App\Models\Favorite;
use App\Models\Images;
use App\Models\Products;
use App\Models\Reviews;
use App\Repositories\Cart\CartRepository;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use App\Models\VisitedProduct;
use App\Models\Inquiry;
use App\Models\Seo;
use Illuminate\Support\Facades\Cookie;

class ProductWebController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return Application|Factory|View
     */
    public function index(Request $request)
    {
            $products_s = Products::with('favorite', 'colors')
    ->where('status', '1')
    ->whereHas('categories', function ($query) {
        $query->where('status', '1');
    })
    ->when($request->category, function ($q) use ($request) {
        // جلب جميع الأصناف الفرعية والرئيسية المرتبطة بالصنف المحدد
        // $categoryId = $request->category;
        $categoryId = $request->category_children;
         if(!$categoryId)
        $categoryId= $request->category;

        // الحصول على الأصناف الفرعية
        $subCategoryIds = Categories::where('parent_id', $categoryId)
            ->orWhere('id', $categoryId)
            ->pluck('id');

         $subCategoryIds=Categories::whereIn('parent_id', $subCategoryIds)
          ->orWhereIn('id', $subCategoryIds)
          ->pluck('id');
        return $q->whereIn('category_id', $subCategoryIds);
    })
   
    ->when($request->color, function ($q) use ($request) {
        $q->whereHas('colors', function ($query) use ($request) {
            $query->where('id', $request->color);
        });
    })
    ->when($request->price, function ($q) use ($request) {
        $price = explode(' - ', $request->price);
        $q->whereBetween('price', [$price[0], $price[1]]);
    })
    ->when($request->sort_order, function ($q) use ($request) {
        if ($request->sort_order == 'desc') {
            $q->orderBy('order_sort', 'asc');
        }
        if ($request->sort_order == 'name') {
            $q->orderBy('name_' . App::getLocale());
        }
        if ($request->sort_order == 'price') {
            $q->orderBy('price');
        }
    })
    ->whereNull('parent_product_id')
    ->orderBy('order_sort', 'asc')->orderBy('price', 'desc')
    ->get();
        $min = Products::first();
        $max = Products::orderBy('id', 'desc')->first();
        if ($min || $max) {
            $single_product = Products::where('id', rand($min->id, $max->id))->first();
        } else {
            $single_product = Products::first();
        }
        // $cat = Categories::get();
         $subCategroy=Categories::find( request('category'));
        if($subCategroy)
        $cat = Categories::where("parent_id",$subCategroy->parent_id)->where("status",1)->get();
        else
        // $cat = Categories::get();
          $cat = Categories::where("parent_id",null)->where("status",1)->get();
        $colors = Colors::get();
//        return $colors;
if ($request->category)
            $seo = Seo::where("name_page", $request->category)->where("type", "category")->first();
        else
            $seo = Seo::where("name_page", "products")->first();
//  if($subCategroy)
//   $cat_seo = Categories::find($subCategroy->id);
//  else
//  $cat_seo=null;

// dd($products_s);
        return view('web.product.index', compact('products_s', 'single_product','subCategroy', 'cat' , 'colors','seo'));
    }
    function getAllCategoryIds($category)
    {
        $ids = collect([$category->id]);

        foreach ($category->children as $child) {
            $ids = $ids->merge($this->getAllCategoryIds($child));
        }

        return $ids;
    }


    public function category($id,$slug)
    {
    //       $products_s = Products::with(['favorite', 'colors'])
    // ->where('status', '1')
    // ->whereHas('categories', function ($query) use ($id) {
    //     $query->where('status', '1')
    //           ->where(function ($q) use ($id) {
    //               $q->where('id', $id) // التصنيف الرئيسي
    //                 ->orWhere('parent_id', $id); // التصنيفات الفرعية
    //           });
    // })
    //  ->orderBy('order_sort', 'asc')->orderBy('price', 'desc')
    // ->get();
    
     $category = Categories::with('children')->find($id);

        // الخطوة 2: استخراج كل التصنيفات التابعة له
        $categoryIds = $this->getAllCategoryIds($category);

        // الخطوة 3: جلب المنتجات المرتبطة بأي من هذه التصنيفات
        $products_s = Products::with(['favorite', 'colors'])
            ->where('status', 1)
            ->whereHas('categories', function ($query) use ($categoryIds) {
                $query->whereIn('id', $categoryIds);
            })
            ->orderBy('order_sort', 'asc')
            ->orderBy('price', 'desc')
             ->whereNull("parent_product_id")
            ->get();
            // echo $products_s->toSql();
            // dd($products_s->toSql());

        
        // $cat = Categories::get();
                $cat = Categories::where('parent_id', $id)->get();
                $cat_seo=Categories::find($id);

        $min = Products::first();
        $max = Products::orderBy('id', 'desc')->first();
        if ($min || $max) {
            $single_product = Products::where('id', rand($min->id, $max->id))->first();
        } else {
            $single_product = Products::first();
        }
        $seo=Seo::where("name_page",$id)->where("type","category")->first();
        return view('web.product.category', compact('products_s','cat','cat_seo', 'single_product','seo'));
    }

    public function product_type(Request $request)
    {
        $min = Products::first();
        $max = Products::orderBy('id', 'desc')->first();
        if ($min || $max) {
            $single_product = Products::where('id', rand($min->id, $max->id))->first();
        } else {
            $single_product = Products::first();
        }
        if ($request->type == 'new') {
            $products_s = Products::with('favorite' , 'colors')->where('status', '1')->where('appear', 'most_recent')->get();
        } elseif ($request->type == 'sold') {
            $products_s = Products::with('favorite' , 'colors')->where('status', '1')->where('appear', 'best_seller')->get();
        } else {
            $products_s = Products::with('favorite' , 'colors')->where('status', '1')->get();
        }

        return view('web.product.product_types', compact('products_s', 'single_product'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return Application|Factory|View
     */
    public function show($id)
    {
        $product = Products::withSum('reviews','rate')->withCount('reviews')->with('favorite' ,'tags' ,'colors' , 'specifications')->find($id);
        
         if ($product->related_products) {
            $ids = $product->related_products
                ? explode(',', $product->related_products)
                : [];

            // استرجع المنتجات الفعلية
            $products_s = Products::whereIn('id', $ids)->get();
        } else {
            $products_s = Products::where('status', '1')->with('favorite', 'colors')
                ->whereHas('categories', function ($query) {
                    $query->where('status', '1');
                })->where('category_id', $product->category_id)->orderBy('order_sort', 'asc')->take(8)->get();
        }
        if ($product){
            // $products_s = Products::where('status', '1')->with('favorite' , 'colors')
            //     ->whereHas('categories', function ($query) {
            //         $query->where('status', '1');
            //     })->where('category_id', $product->category_id)->orderBy('order_sort', 'asc')->take(8)->get();

            $images = Images::where('imageable_id', $product->id)
                ->where('imageable_type', '\App\Models\Products')->get();
                
                
         $color_images = [];
                // dd($product->colors);
                foreach ($product->colors as $color) {
                    $color_images[] = 
                    [
                   "color"=> $color->color,
                   "color_id"=>$color->id,
                   "image_url"=> $color->images?->image,
                    ];
                }  
                
                  // تسجيل المنتجات التي شاهدها العميل 
                $cookieId = Cookie::get('visitor_id', null);

                if (!$cookieId) {
                    $cookieId = uniqid('visitor_');
                    Cookie::queue('visitor_id', $cookieId, 60 * 24 * 30); // حفظ لمدة 30 يومًا
                }
            
                // إضافة المنتج إلى جدول المنتجات المزارَة
                VisitedProduct::create([
                    'user_id' => auth()->check() ? auth()->id() : null,
                    'cookie_id' => auth()->check() ? null : $cookieId,
                    'product_id' => $id,
                ]);
                    $seo=Seo::where("type","product")->where("name_page",$id)->first();    

            return view('web.product.show', compact('product', 'products_s', 'images','color_images','seo'));
        }else{
            return abort(403);
        }

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function getData(Request $request, $id)
    {
        $product = Products::withSum('reviews', 'rate')->withCount('reviews')->with('colors' , 'favorite' , 'specifications')
            ->with(['imageable' => function ($q) {
                $q->where('imageable_type', '\App\Models\Products');
            }])->find($id);

        return response()->json([
            'product' => $product,
        ]);
    }

    public function add_fav(Request $request)
    {
        $checkFav = Favorite::where('user_id', $request->user_id)->where('product_id', $request->product_id)->first();
        if ($checkFav) {
            $checkFav->delete();
            return "delete Done";
        } else {
            $fav = new Favorite();
            $fav->user_id = $request->user_id;
            $fav->product_id = $request->product_id;
            $fav->save();
            return "add Done";
        }
    }

    public function show_products($id)
    {
        $min = Products::first();
        $max = Products::orderBy('id', 'desc')->first();
        if ($min || $max) {
            $single_product = Products::where('id', rand($min->id, $max->id))->first();
        } else {
            $single_product = Products::first();
        }
        $category = Categories::findOrFail($id);
        if ($category->status == 1) {
            $show_products = Products::with('favorite' , 'colors')->where('category_id', $id)->where('status', '1')->get();
        } else {
            return abort(404);
        }

        return view('web.product.show_products', compact('show_products', 'single_product'));
    }

    public function add_review(Request $request)
    {
        $reviews = Reviews::where('user_id', Auth::user()->id)->where('product_id', $request->product_id)->first();
        if ($reviews) {
            $reviews->update([
                'user_id' => Auth::user()->id,
                'product_id' => $request->product_id,
                'rate' => $request->rating,
                'note'=>$request->note
            ]);
            return "done1";
        } else {
            Reviews::create([
                'user_id' => Auth::user()->id,
                'product_id' => $request->product_id,
                'rate' => $request->rating,
                'note'=>$request->note

            ]);
            return "done2";
        }
    }
    
       public function childCategory(Request $request)
    {


        $id = $request->input('value'); 
        $child=Categories::where('parent_id', $id)->get();
        return response()->json([
            'child' =>$child
        ]);
    }
    
     public function add_inquery(Request $request)
    {
        // $reviews = Inquiry::where('user_id', Auth::user()->id)->where('product_id', $request->product_id)->first();

        Inquiry::create([
            'user_id' => Auth::user()->id,
            'product_id' => $request->product_id,
            'note' => $request->note

        ]);
        return "done2";
    }


   public function campare_product(Request $request)
    {
        // dd($request->all());
        $data = $request->validate([
            // تقبل مصفوفة IDs أو سترينغ مفصول بفواصل
            'ids'   => ['required'],
        ]);

        $ids = is_array($data['ids'])
            ? $data['ids']
            : array_filter(explode(',', $data['ids']));

        // تنظيف وحدّ أقصى 4
        $ids = array_slice(array_unique(array_map('intval', $ids)), 0, 4);

        abort_if(count($ids) < 2, 422, 'اختر منتجين على الأقل للمقارنة.');

        $compare_product = Products::with("specifications")->whereIn('id', $ids)
            ->where('status', 1)
            ->get();


        // return $products;


        return view('web.product.compare_product', compact('compare_product'));
    }
    
    
    


}
