<?php

namespace App\Http\Controllers\web;

use App\Http\Controllers\Controller;
use App\Models\Ads;
use App\Models\Categories;
use App\Models\Favorite;
use App\Models\Products;
use App\Models\Reviews;
use App\Models\WhyChooseUs;
use App\Repositories\Cart\CartInterface;
use App\Repositories\Cart\CartRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\View;
use App\Models\Slider;
use App\Models\Preorder;
use App\Models\Seo;
use App\Models\Tag;
use Illuminate\Support\Facades\DB;


class MostSaleController extends Controller
{
    public function index()
    {

        $products_s = Products::where("status", 1)
            ->where("appear", "first_home_page")
            ->where("market","more_sale")
            // ->whereHas('categories', function ($query) {
            //     $query->where('name_ar', 'جوالات')->orWhere('name_ar', 'هواتف');
            // })
            ->orderBy("price", "desc")
            ->limit(10)
            ->get();
        $seo = Seo::where("name_page", "most_sale")->first();


        return view('web.most_sale', compact('products_s', 'seo'));
    }
}
