<?php

namespace App\Http\Controllers\web;

use App\Http\Controllers\Controller;
use App\Models\Loyalty;
use App\Models\Order;
use App\Models\Products;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LoyaltyController extends Controller
{
    //

    public function index()
    {
        $gifts=Products::where("is_gift",1)->get();
        return view("web.gift.index", compact("gifts"));
    }
    public function store(Request $request)
    {

        $number=Order::where("payment_status","paid")->where("user_id",Auth::id())->count();

        if($number%4==0 && $number!=0){
            $loyalty = Loyalty::create([
                'user_id' => Auth::id(),
                'product_id' => $request["gift_id"],
                'delivery_method' => $request["delivery_method"],  // أو 'pickup' حسب الحالة
            ]);
               return back()->with("success","تم تقديم طلبك بنجاح ");
        }

        return back()->with("error","انت لم تنطبق عليك الشروط ");
        
      
    }

}
