<?php

namespace App\Http\Controllers\web;

use App\Http\Controllers\Controller;
use App\Models\Ads;
use App\Models\Categories;
use App\Models\Favorite;
use App\Models\Products;
use App\Models\Reviews;
use App\Models\WhyChooseUs;
use App\Repositories\Cart\CartInterface;
use App\Repositories\Cart\CartRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\View;
use App\Models\Slider;
use App\Models\Preorder;
use App\Models\Seo;
use App\Models\Tag;
use Illuminate\Support\Facades\DB;
use App\Models\User;


class HomeController extends Controller
{
    
    protected $limit;
    
     function isMobile($userAgent)
    {
        return preg_match('/Mobile|Android|iP(hone|od|ad)|Opera Mini|IEMobile|WPDesktop/', $userAgent);
    }
    
      public function getAllCategoryIds($category)
    {
        $ids = [];

        foreach ($category->children as $child) {
            $ids[] = $child->id;
            if ($child->children->count()) {
                $ids = array_merge($ids, $this->getAllCategoryIds($child));
            }
        }

        return $ids;
    }
    
    //   public function getMainCategoryProducts()
    // {
    //     $mainCategories = Categories::where('is_main', 1)->where('status', 1)->with('allChildren')->get();

    //     $sections = [];

    //     foreach ($mainCategories as $main) {
    //         // جلب كل الأصناف الفرعية اللي تحت الصنف الرئيسي
    //         $allCategoryIds = $this->getAllCategoryIds($main);

    //         // جلب المنتجات المرتبطة بهذه الأصناف
    //         $products = Products::whereIn('category_id', $allCategoryIds)
    //             ->orderBy('price', 'desc')
    //             ->take(4)
    //             ->get();

    //         if ($products->count()) {
    //             $sections[] = [
    //                 'category_name' => $main->name_ar,
    //                 'category' => $main,
    //                 'products' => $products,
    //             ];
    //         }
    //     }

    //     return $sections;
    // }
    
    public function getMainCategoryProducts(Request $request)
    {
        // ترتيب الأقسام المطلوب عرضها
        $orderedCategories = ['جوالات', 'اكسسوارات', 'لابتوبات', 'بلايستيشن'];

        // جلب كل الأقسام الرئيسية مع الأطفال
        $mainCategories = Categories::where('is_main', 1)
            ->where('status', 1)
            ->whereIn('name_ar', $orderedCategories)
            ->with('allChildren')
            ->get()
            // ترتيب حسب المصفوفة
            ->sortBy(function ($item) use ($orderedCategories) {
                return array_search($item->name_ar, $orderedCategories);
            });

        $sections = [];
        $userAgent = $request->header('User-Agent');
        $sections = [];
        $this->limit = $this->isMobile($userAgent) ? 2 : 4;

        foreach ($mainCategories as $main) {
            $allCategoryIds = $this->getAllCategoryIds($main);

            $products = Products::whereIn('category_id', $allCategoryIds)
            ->where('status', 1)
                ->orderBy('price', 'desc')
                ->take($this->limit)
                ->get();

            if ($products->count()) {
                $sections[] = [
                    'category_name' => $main->name_ar,
                    'category' => $main,
                    'products' => $products,
                ];
            }
        }

        return $sections;
    }

    
    
    public function index(Request $request)
    {
        
         $sections = $this->getMainCategoryProducts($request);
         
          if ($request->has('ref')) {
            $ref = $request->get('ref');
            session(['referral' => $ref]);

            $user = User::where('referral_code', $ref)->first();
            if ($user) {
                session(['referral_name' => $user->user_name]);
                // dd($user->referral_name);
            }
        }
         
         
        $products_first_home_page = Products::withSum('reviews', 'rate')->withCount('reviews')
            ->with('reviews.user')->whereHas('categories', function ($query) {
                $query->where('status', '1');
            })->where('appear', 'first_home_page')->where('status', '1')->orderByDesc('id')
            ->take(6)->get();
        $cart = new CartRepository();

        // $categories = Categories::where('status', '1')->orderBy('order_sort', 'asc')->whereNull('parent_id')->get();
        
        
        $customOrder = ['جوالات', 'اكسسوارات', 'بلايستيشن', 'لابتوبات', 'شاشات', 'مكيفات', 'غسالات', 'ثلاجات'];
        $placeholders = implode(',', array_fill(0, count($customOrder), '?'));
        $categories = Categories::where('status', '1')
            ->whereNull('parent_id')
            ->orderByRaw("FIELD(name_ar, $placeholders)", $customOrder)
            ->get();

        
        
        $products_s = Products::withSum('reviews', 'rate')->withCount('reviews')->with('favorite')
            ->whereHas('categories', function ($query) {
                $query->where('status', '1');
            })->where("market","more_sale")->where('appear', '!=', 'only_product')->where('appear', '!=', 'most_recent')->where('appear', '!=', 'best_seller')->where('status', '1')->orderBy('order_sort', 'asc')->orderBy('price', 'desc')->take($this->limit)->get();

        $products_most_recent = Products::withSum('reviews', 'rate')->with('favorite', 'colors')
            ->withCount('reviews')->where('appear', 'most_recent')
            ->whereHas('categories', function ($query) {
                $query->where('status', '1');
            })->where('status', '1')->orderByDesc('price')->take(6)->get();

        $ads = Ads::where('type', 'general')->where('status', '1')->orderByDesc('id')->take(2)->get();
        $reviews = Reviews::with("user")->where("is_active", 1)->get();
        $products_sf = Products::with('favorite', 'colors')->where('status', '1')->where('appear', 'most_recent')->take(3)->get();
        // $slider = Slider::whereNull('category_id')->where("is_active", 1)->orderBy('id', 'desc')->get();
        
        $language = app()->getLocale(); // سترجع 'ar' أو 'en'

$slider = Slider::whereNull('category_id')
    ->where('is_active', 1)
    ->where('type', $language) // تصفية حسب اللغة
   ->orderBy('created_at', 'asc')
    ->get();
        
        
        $seo = Seo::where("name_page", "home")->first();
        return view('web.home', compact(
            'products_s',
            'products_sf',
            'cart',
            'categories',
            'products_first_home_page',
            'products_most_recent',
            'ads',
            'reviews',
            'slider',
            'seo',
            'sections'
        ));
    }

    public function preorder()
    {
        return view("web.preorder");
    }
    public function store_preorder(Request $request)
    {

        // حفظ البيانات في قاعدة البيانات

        $order = new Preorder();
        $order->name = $request['name'];
        $order->phone = $request['phone'];
        $order->phoneSelect = $request['phoneSelect'];
        $order->color = $request['color'];
        $order->storage = $request['storage'];
        $order->deliveryMethod = $request['deliveryMethod'];
        $order->paymentMethod = $request['paymentMethod'];
        $order->save();
        return redirect()->back()->with('success', 'تم إرسال الطلب بنجاح!');
    }
      public function tag_front($name,$id)
    {
       
        $current_tag = Tag::find($id);

        if ($current_tag) {

            // Get all product IDs that have this tag
            $tags = DB::table('product_tag')
                ->where('tag_id', $id)
                ->pluck('products_id'); // ✅ Correct column name

            // Get products that match these IDs and have active categories
            $products_s = Products::with('favorite', 'colors')
                ->where('status', '1')
                ->whereIn("id", $tags)
                ->whereHas('categories', function ($query) {
                    $query->where('status', '1');
                })
                ->orderBy('order_sort', 'asc')
                ->orderBy('price', 'desc')
                ->get();

            return view("web.product.tag", compact('products_s', 'current_tag'));
        }
        return back();
    }
    
}
