<?php

namespace App\Http\Controllers\web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Seo;
use App\Models\Post;
use App\Models\FAQ;
class BlogController extends Controller
{
    
    public function index()
    {
        
         $posts=Post::where("is_active",1)->get();
        $seo=Seo::where("type","page")->where("name_page","post")->first();
        
        return view("web.quick_link.blog",compact('seo','posts'));
    }
    public function detail_post($slug)
    {
        $faqSchema = null;
        $faqs=[];
        $post = Post::where("is_active", 1)->where("slug_ar", $slug)->orWhere("slug_en", $slug)->first();
        if($post)
        {
            $faqs = FAQ::where("post_id", $post->id)->get();
        }
         if($faqs)
         {
             if ($faqs->count() > 0) {
            $faqSchema = [
                "@context" => "https://schema.org",
                "@type" => "FAQPage",
                "mainEntity" => []
            ];

            foreach ($faqs as $faq) {
                $faqSchema["mainEntity"][] = [
                    "@type" => "Question",
                    "name" => $faq->question,
                    "acceptedAnswer" => [
                        "@type" => "Answer",
                        "text" => $faq->answer,
                    ]
                ];
            }

            // تحويل المصفوفة إلى JSON
            $faqSchema = json_encode($faqSchema, JSON_UNESCAPED_UNICODE);
        }
         }
        
        return view("web.quick_link.detail_post", compact('post','faqs','faqSchema'));
    }
}
