<?php

namespace App\Http\Controllers\dashboard;

use App\Http\Controllers\Controller;
use App\Models\Products;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class SitemapController extends Controller
{

    public function updateSitemap($item, $type)
    {
        // تحديد مسار ملف sitemap.xml
        $sitemapPath = base_path('../sitemap.xml');

        // إذا كان الملف موجودًا، نفتح الملف
        if (File::exists($sitemapPath)) {
            $xml = simplexml_load_file($sitemapPath);

            if ($type == "product") {
                // الرابط العربي
                $urlAr = $xml->addChild('url');
                $urlAr->addChild('loc', url("/ar/products/single/{$item->id}"));
                $urlAr->addChild('lastmod', now()->toAtomString());
                $urlAr->addChild('priority', '0.80');

                // الرابط الإنجليزي
                $urlEn = $xml->addChild('url');
                $urlEn->addChild('loc', url("/en/products/single/{$item->id}"));
                $urlEn->addChild('lastmod', now()->toAtomString());
                $urlEn->addChild('priority', '0.80');
            } elseif ($type == "category") {
                // الرابط العربي
                $urlAr = $xml->addChild('url');
                $urlAr->addChild('loc', url("/ar/products/category/{$item->id}/{$item->name_en}"));
                $urlAr->addChild('lastmod', now()->toAtomString());
                $urlAr->addChild('priority', '0.80');

                // الرابط الإنجليزي
                $urlEn = $xml->addChild('url');
                $urlEn->addChild('loc', url("/en/products/category/{$item->id}/{$item->name_en}"));
                $urlEn->addChild('lastmod', now()->toAtomString());
                $urlEn->addChild('priority', '0.80');
            } elseif ($type == "tag") {
                // الرابط العربي
                $urlAr = $xml->addChild('url');
                $urlAr->addChild('loc', url("/ar/{$item->name_ar}/tag/{$item->id}"));
                $urlAr->addChild('lastmod', now()->toAtomString());
                $urlAr->addChild('priority', '0.80');

                // الرابط الإنجليزي
                $urlEn = $xml->addChild('url');
                $urlEn->addChild('loc', url("/en/{$item->name_en}/tag/{$item->id}"));
                $urlEn->addChild('lastmod', now()->toAtomString());
                $urlEn->addChild('priority', '0.80');
            }
               elseif($type=="post")
            {
                $urlAr = $xml->addChild('url');
                $urlAr->addChild('loc', url("/ar/detail-post/{$item->id}"));
                $urlAr->addChild('lastmod', now()->toAtomString());
                $urlAr->addChild('priority', '0.80');

                // الرابط الإنجليزي
                $urlEn = $xml->addChild('url');
                $urlEn->addChild('loc',  url("/en/detail-post/{$item->id}"));
                $urlEn->addChild('lastmod', now()->toAtomString());
                $urlEn->addChild('priority', '0.80');

            }

            // حفظ التحديثات
            $xml->asXML($sitemapPath);
        } else {
            dd("not find xml path", asset('sitemap.xml'), public_path('sitemap.xml'), base_path('../sitemap.xml'));
        }
    }
}
