<?php

namespace  App\Http\Controllers\dashboard;

use App\Models\Seo;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Categories;
use App\Models\Products;

class SeoController extends Controller
{
    //

    public function index_page()
    {
         $seos=Seo::where('type','page')->get();
        
        return view("dashboard.seo.index_page",compact('seos'));
    }

    public function store_page(Request $request)
{
    // التحقق من وجود page_name في قاعدة البيانات
    $existingSeo = Seo::where('name_page', $request->input('name_page'))->first();

    if ($existingSeo) {
        // إذا كانت الصفحة موجودة مسبقاً
        return back()->with('error', 'هذه الصفحة موجودة بالفعل.');
    }

    // إنشاء سجل جديد إذا لم تكن الصفحة موجودة
    $seo = Seo::create($request->all());
    $seo->type='page';
    $seo->save();

    if ($seo) {
        return back()->with('success', 'تم الحفظ بنجاح.');
    }

    // في حالة حدوث خطأ أثناء الحفظ
    return back()->with('error', 'حدث خطأ أثناء الحفظ.');
}

    public function edit_page($id)
    {
        $seo=Seo::find($id);
        return view("dashboard.seo.edite_page",compact('seo'));
    }
    
    public function update_page(Request $request, $id)
{
    // Find the record by its ID
    $seo = Seo::find($id);

    if (!$seo) {
        return back()->with('error', 'Record not found.');
    }

    // Update the record with the provided data
    $updated = $seo->update($request->all());

    if ($updated) {
        return back()->with('success', 'Record updated successfully.');
    } else {
        return back()->with('error', 'Failed to update the record.');
    }
}
public function index_category()
{
    $category=Categories::where("status",1)->get();
    $seos=Seo::where("type","category")->with("category")->get();
    // dd($seos);
    return view("dashboard.seo.index_category",compact('category','seos'));
}

public function store_category(Request $request)
{
    $existingSeo = Seo::where('name_page', $request->input('name_page'))->where("type","product")->first();

    if ($existingSeo) {
        // إذا كانت الصفحة موجودة مسبقاً
        return back()->with('error', 'هذه الصفحة موجودة بالفعل.');
    }

    // إنشاء سجل جديد إذا لم تكن الصفحة موجودة
    $seo = Seo::create($request->all());
    $seo->type='category';
    $seo->save();

    if ($seo) {
        return back()->with('success', 'تم الحفظ بنجاح.');
    }

    // في حالة حدوث خطأ أثناء الحفظ
    return back()->with('error', 'حدث خطأ أثناء الحفظ.');
}

public function index_product()
{
    $product=Products::where("status",1)->get();
    $seos=Seo::where("type","product")->with("category")->get();
    return view("dashboard.seo.index_product",compact('product','seos'));

}

public function store_product(Request $request)
{
    $existingSeo = Seo::where('name_page', $request->input('name_page'))->where("type","product")->first();

    if ($existingSeo) {
        // إذا كانت الصفحة موجودة مسبقاً
        return back()->with('error', 'هذه الصفحة موجودة بالفعل.');
    }

    // إنشاء سجل جديد إذا لم تكن الصفحة موجودة
    $seo = Seo::create($request->all());
    $seo->type='product';
    $seo->save();

    if ($seo) {
        return back()->with('success', 'تم الحفظ بنجاح.');
    }

    // في حالة حدوث خطأ أثناء الحفظ
    return back()->with('error', 'حدث خطأ أثناء الحفظ.');
}

public function delete_recored($id)
{
    $user = Seo::find($id);
if ($user) {
    $user->delete();
    return back()->with('success', 'تم الحذف بنجاح.');
}
return back()->with('error', 'حدث خطأ أثناء الحذف.');


}


}
