<?php

namespace App\Http\Controllers\dashboard;

use App\Http\Controllers\Controller;
use App\Models\Categories;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class CategoriesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
        $this->middleware('permission:Category-List|Category-Create|Category-Edit|Category-Delete', ['only' => ['index','store']]);
        $this->middleware('permission:Category-Create', ['only' => ['create','store']]);
        $this->middleware('permission:Category-Edit', ['only' => ['edit','update']]);
        $this->middleware('permission:Category-Delete', ['only' => ['destroy']]);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $categories = Categories::get();
        if ($request->ajax())
        {
            return view('dashboard.Categories.table-data' , compact('categories'))->render();
        }
        return view('dashboard.Categories.index' ,  compact('categories'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categories = Categories::whereNull('parent_id')->where("status",1)->get();
        return view('dashboard.Categories.create',compact('categories'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = $request->validate(Categories::$rules);
//        $validator = Validator::make($request->all(), Categories::$rules);


        $data = $request->except('image');
        if ($request->file('image')) {
            $name = Str::random(12);
            $path = $request->file('image');
            $name = $name . time() . '.' . $request->file('image')->getClientOriginalExtension();
            $data['image'] = $name;
            $path->move('dashboard/images', $name);
        }
        if ($request->status == 'on') {
            $data['status'] = 1;
        } else {
            $data['status'] = 0;
        }

        Categories::create($data);
        return redirect()->route('cat.index')->with('success', __('lang.success'));
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $category = Categories::find($id);
                $categories = Categories::whereNull('parent_id')->where("status",1)->get();

        return view('dashboard.Categories.edite', compact('category','categories'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $validator = $request->validate(Categories::$rules2);
        $category = Categories::find($request->id);
        $data = $request->except('image');
        if ($request->file('image')) {
            $name = Str::random(12);
            $path = $request->file('image');
            $name = $name . time() . '.' . $request->file('image')->getClientOriginalExtension();
            $data['image'] = $name;
            $path->move('dashboard/images', $name);
        }
        if ($request->status == 'on') {
            $data['status'] = 1;
        } else {
            $data['status'] = 0;
        }
        $category->update($data);
        return redirect()->route('cat.index')->with('success', __('lang.success'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $category = Categories::find($id)->delete();
        return redirect()->route('cat.index')->with('success', __('lang.delete'));
    }

    public function updateStauts($id)
    {
        $category = Categories::find($id);
        if ($category->status == '1' ){
            $category->update(['status' => 0]);

        }else{
            $category->update(['status' => 1]);

        }
        return redirect()->route('cat.index');
    }
    
    public function add_description(Request $request, $id)
    {
        $category = Categories::find($id);
        if($category)
        {
            $category->desc_ar=$request['desc_ar'];
            $category->desc_en=$request['desc_en'];
            $category->save();
        }
        return back()->with('success',"تم اضافة الوصف بنجاح");
    }
    

}
