<?php

namespace App\Http\Controllers\Webhook;

use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\Register_transaction;
use App\Payment\Tamara\Tamara;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;


class TamarawebhookController extends Controller
{
    public function receive_events(Request $request){
        Log::info($request);

        $tamara=new Tamara();
        $transaction_id=$request->order_id;
        $type_event=$request->event_type;

        if ($type_event=='order_approved'){
            Log::info($request);
            $tamara->Auth_order($transaction_id);

        }
        elseif($type_event=='order_authorised'){
            Log::info($request);
             $tamara->capture($transaction_id);
            return $type_event;
        }
        elseif($type_event=='order_captured'){
            Log::info($request);
           $register_trunsactions=Register_transaction::where("uuid","=",$transaction_id)->first();
           $order=Order::findorfail($register_trunsactions->id);
           if ($order->payment_status!="paid"){
           $order->payment_status="paid";
           $order->save();
            return $type_event;}
           else{
               Log::info('ORDER done');
               return "order is already paid";  }


        }
        elseif($type_event=='order_expired'){
            return $type_event;

        }
        else{
            Log::info($request);
            return "Request_reject";


        }

    }
//    public function withdraw(){
//        return "withdraw";
//    }
}
