<?php

namespace App\Http\Controllers\Tamara;

use App\Http\Controllers\Controller;
use App\Mail\OrderMail;
use App\Models\Carts;
use App\Models\Colors;
use App\Models\Order;
use App\Models\OrderItem;
use App\Models\Products;
use App\Models\Register_transaction;
use App\Models\Settings;
use App\Payment\Tamara\Tamara;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\URL;

class TamaraController extends Controller
{
    public function failure_payment($id)
    {

        toastr()->warning('payment cancel !!!!!!!!!!');
        $order = Order::find($id);
        if ($order) {
            $order->payment_status = "failed";
            $order->save();
            return redirect()->route("home");
        } else {

            return redirect()->route("home");
        }
    }

    public function get_redirect_link(Request $request, $id_order)
    {



        if (! $request->hasValidSignature()) {
            return abort(401);
        }
        if ($id_order < 0) {
            toastr()->warning('اقل قيمة للدفع هي 100');
            return back();
        }


        $order = Order::findorfail($id_order);
        // if ($order->total < 100) {
        //     toastr()->warning('اقل قيمة للدفع هي 100');
        //     return back();
        // }
        // if ($order->total > 4000) {
        //     toastr()->warning('اكبر قيمة للدفع هي 2000');
        //     return back();
        // }


        $price = $order->total;

        $price = round($price, 2);






        $success_url = URL::signedRoute("processing_payment", $id_order);
        $failure_url = URL::signedRoute('failure_payment', $id_order);
        // dd($id_order);
        $tamara = new Tamara();

        $response = $tamara->get_payment_link($price, "SAR", $success_url, $failure_url,$id_order);

        $transaction_id = $response['order_id'];
        $out_link = $response['payment_link'];
        $register_transaction = Register_transaction::create([
            "uuid" => $transaction_id,
            "order_id" => $id_order
        ]);
        if ($register_transaction) {
            $order->register_transaction_id = $transaction_id;
            $order->save();
            return redirect()->to($out_link);
        } else {
            abort("404");
        }
    }
    public function processing_payment(Request $request, $id_order)
    {

       
            // dd($request->paymentStatus,$request->paymentStatus,$id_order);
        if (isset($request->paymentStatus) && $request->paymentStatus == 'approved') {


            $register_transaction = Register_transaction::where("order_id", "=", $id_order)->first();
            // dd($register_transaction);
            if ($register_transaction->status != "withdraw") {

                $register_transaction->status = "withdraw";
                $register_transaction->save();
                $tamara = new Tamara();
                $order = Order::findorfail($id_order);
                // dd($register_transaction->uuid);
                $response_capture = $tamara->capture($register_transaction->uuid);
                // dd($response_capture);
               
                $user = Auth::user();
                $total_quantity = Carts::with('product')->whereHas('product', function($query) { $query->where('status', 1);})->where('user_id', Auth::user()->id)->sum('quantity');
                $total_weight = Carts::with('product')->whereHas('product', function($query) { $query->where('status', 1);})->where('user_id', Auth::user()->id)->get()->sum(function($cart) {return $cart->product->weight;});
                // $total_weight = Carts::with('product')->whereHas('product', function($query) { $query->where('status', 1);})->where('user_id', Auth::user()->id)->sum('weight');
                // dd($total_weight);
                $location = Settings::where('key_id' , 'location_ar')->first()->value;
                $phone = Settings::where('key_id' , 'phone')->first()->value;
                if ($response_capture == "done") {
                    $order->payment_status = "paid";
                    $order->save();
                    // dd($response_capture);
                    $postFieldsSmsa = [
                        'passkey' => 'New@8919',
                        'refno' => $order->id."12453",
                        'sentDate' => now(),
                        'idNo' => $order->id,
                        'cName' => $user->user_name,
                        'cntry' => $order->addresses->cities->countries->name_ar,
                        'cCity' => $order->addresses->cities->name_ar,
                    //   "cZip" => $order->addresses->czip ?? rand(10000, 99999),
                    //   "cPOBox" => $order->addresses->cpobox ?? rand(1000, 9999),
                        'cMobile' => $order->addresses->cmobile,// Mobile number
                        // 'cntry' => 'Saudi Arabia',
                        // 'cCity' => 'Riyadh',
                        // "cZip" => '12271', // Postal code
                        // "cPOBox" => '12298', // Postal box
                        // 'cMobile' => '966509395939',// Mobile number
                         "cZip" => '12271', // Postal code
                         "cPOBox" => '12298', // Postal box
                        "cTel1" => "",
                        "cTel2" => "",
                        // 'cAddr1' => 'Al Fadl Al Amiri',
                        // 'cAddr2' => 'حي العليا',
                        'cAddr1' => $order->addresses->street,
                        'cAddr2' => $order->addresses->district,
                        'shipType' => 'DLV',
                        'PCs' => $total_quantity, // total_quantity
                        'cEmail' => $user->email,
                        "carrValue" => "",
                        "carrCurr" => "",
                        'codAmt' => 0,
                        'weight' => $total_weight,
                        'itemDesc' => "",
                        "custVal" => "",
                        "custCurr" => "",
                        "insrAmt" => "",
                        "insrCurr" => "",
                        'sName' => 'NEW NETWORK COMPANY',
                        'sContact' => 'NEW NETWORK COMPANY',
                        'sAddr1' => $location,
                        // 'sAddr1' => 'Riyadh 13224, Saudi Arabia',
                        'sAddr2' => '',
                        'sCity' => 'Riyadh',
                        'sPhone' => $phone,
                        'sCntry' => 'Saudi Arabia',
                        "prefDelvDate" => "",
                        "gpsPoints" => "",
                    ];
                    $smsa = $this->CallApiSmsa('/addship' , $postFieldsSmsa);
                     $order->update(['awbNo' => $smsa]);
                    //  $cart->empty();
                    toastr()->success(__('lang.order_done'));
                    $order->payment_status = 'paid';
                    $OrderItem = OrderItem::whereHas('order' , function ($q) use($order){
                        $q->where('order_id' , $order->id);
                    })->get();
                    foreach ($OrderItem as $items){
                        $product_s = Products::with('colors')->find($items->product_id);
                        $product_s->update([
                            'quantity' => $product_s->quantity - $items->quantity,
                        ]);
                        $colors = Colors::where('product_id' , $items->product_id)->where('color' , $items->options)->first();
        //                return $colors;
                        $colors->update([
                            'quantity' => $colors->quantity - $items->quantity,
                        ]);
                    }
                    Mail::to(Auth::user()->email)->send(new OrderMail($order));
                     
                     
                    // toastr()->success('تم الدفع بنجاح');

                   
               
                    // return redirect()->route('home');
                    return redirect()->route('account.index');
                } else {
                    toastr()->success('تم دفع المبلغ بنجاح');


                    return redirect()->route('home');
                }
            } else {
                toastr()->warning('جاري معالجة الطلب');


                return redirect()->route('home');
            }
        } else {
            toastr()->warning('جاري معالجة الطلب');


            return redirect()->route('home');
        }
    }

    public function CallApiSmsa($apiUrl , $postFields , $type = 'post')
    {
        $headers = [
            'Content-type'  => 'application/json',
            'Accept'        => 'application/json',
        ];
        if($type == 'get'){
            $response = Http::withHeaders($headers)->get('https://track.smsaexpress.com/SecomRestWebApi/api'.$apiUrl , $postFields);
            return json_decode($response);
        }elseif($type == 'post'){
        $response = Http::withHeaders($headers)->post('https://track.smsaexpress.com/SecomRestWebApi/api'.$apiUrl , $postFields);
            return json_decode($response);
        }else{
            abort(403);
        }
    }
}
