<?php

namespace App\Http\Controllers\API\V1;

use App\Http\Controllers\Controller;
use App\Http\Requests\CartItemRequest;
use App\Http\Requests\CartRequest;
use App\Models\User;
use App\Notifications\TestNotification;
use App\Services\CartService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Notification;

class CartsController extends Controller
{
    public function index(Request $request)
    {
        return CartService::index($request->id);
    }

    public function store(CartRequest $cartRequest)
    {
        return CartService::store($cartRequest->cartData());
    }

    public function update(CartItemRequest $cartRequest, $id)
    {
        return CartService::update($id, $cartRequest->cartData());
    }

    public function destroy($id)
    {
        return CartService::destroy($id);
    }
}
