<?php

namespace App\Http\Controllers\API\V1;

use App\Helpers\Messages;
use App\Http\Controllers\Controller;
use App\Http\Requests\ReviewRequest;
use App\Http\Requests\VariantRequest;
use App\Http\Resources\ProductResource;
use App\Models\Products;
use App\Services\ProductService;
use Illuminate\Http\Request;

class ProductsController extends Controller
{
    public function index(Request $request)
    {
        return ProductService::index($request->all());
    }

    public function show($id)
    {
        return ProductService::show($id);
    }

    public function similarProduct($id)
    {
        return ProductService::similarProduct($id);
    }

    public function getVariant(VariantRequest $request)
    {
        return ProductService::getVariant($request);
    }

    public function reviewProduct(ReviewRequest $request)
    {
        return ProductService::reviewProduct($request);
    }

    public function viewProduct($id)
    {
        return ProductService::viewProduct($id);
    }
    
    public function search_product(Request $request)
    {
         $query = $request->input('search');
        //  dd($query);
        $products = Products::where('status', 1)
    ->where(function ($q) use ($query) {
        $q->where('name_ar', 'like', '%' . $query . '%')
          ->orWhere('name_en', 'like', '%' . $query . '%');
    })
    ->get();
          return parent::success($products, "successfully");
        
    }
}
