<?php

namespace App\Http\Controllers\API\V1;

use App\Helper\Messages;
use App\Http\Controllers\Controller;
use App\Http\Requests\CartItemRequest;
use App\Http\Requests\CartRequest;
use App\Models\Carts;
use App\Models\Colors;
use App\Models\Message;
use App\Models\Products;
use App\Models\User;
use App\Notifications\TestNotification;
use App\Services\CartService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Notification;

class CartsController extends Controller
{
    public function index(Request $request)
    {
        // return CartService::index($request->id);
        $user = $request->user(); // إذا استخدمت Sanctum أو Passport

        if ($user) {
            // مستخدم مسجل دخول بالتوكن
            $cartItems = Carts::where('user_id', $user->id)
                ->with('product')
                ->get();
        } else {
            // مستخدم غير مسجل - استخدم cookie_id المرسل من تطبيق الجوال
            $request->validate([
                'cookie_id' => 'required|string'
            ]);

            $cartItems = Carts::where('cookie_id', $request->cookie_id)
                ->with('product')
                ->get();
        }

        return parent::success($cartItems, Messages::getMessage('operation accomplished successfully'));
    }

    public function store(Request $request)
    {
        // return CartService::store($cartRequest->cartData());

        $color = Colors::where("product_id", $request->product_id)->first();
        $product=Products::find($request->product_id);
        // $request->validate([
        //     'product_id' => 'required|exists:products,id',
        //     'total' => 'required|numeric',
        //     'quantity' => 'required|integer|min:1',
        //     'cookie_id' => 'nullable|string'
        // ]);
        // return $request->all();

        $user = $request->user();
        // return $user;

        $cartItem = new Carts();

        if ($user) {
            $cartItem->user_id = $user->id;
        } else {
            if (!$request->cookie_id) {
                return response()->json(['error' => 'cookie_id is required for guests'], 422);
            }
            $cartItem->cookie_id = $request->cookie_id;
        }

        $cartItem->product_id = $request->product_id;
        $cartItem->total = $product->price;
        $cartItem->quantity = $request->quantity;
        $cartItem->color = $color->color;
         $cartItem->cookie_id ="cookie_id_api";
        $cartItem->save();


        return parent::success($cartItem, Messages::getMessage('CREATE_SUCCESS'));
    }

    public function update(CartItemRequest $cartRequest, $id)
    {
        return CartService::update($id, $cartRequest->cartData());
    }

    public function destroy($id)
    {
        return CartService::destroy($id);
    }
    public function delete(Request $request)
    {

        // $request->validate([
        //     'product_id' => 'required|exists:cart,product_id',
        //     'cookie_id' => 'nullable|string',
        // ]);

        $user = $request->user();

        $query = Carts::where('product_id', $request->product_id);

        if ($user) {
            $query->where('user_id', $user->id);
        } elseif ($request->cookie_id) {
            $query->where('cookie_id', $request->cookie_id);
        } else {
            return self::error([], 'User ID or Cookie ID is required', 400);
        }

        $deleted = $query->delete();

        if ($deleted) {
            return parent::success($request->all(), Messages::getMessage('DELETE_SUCCESS'));
        } else {
            return self::error($request->all(), 'DELETE_Faild', 404);
        }
    }
    public function updateCartQuantity(Request $request)
    {
        // $request->validate([
        //     'product_id' => 'required|exists:cart,product_id',
        //     'quantity' => 'required|integer|min:1',
        //     'cookie_id' => 'nullable|string',
        // ]);

        $user = $request->user();
        // return $user;

        $query = Carts::where('product_id', $request->product_id)->where("user_id",$user->id);

        

        $cartItem = $query->first();
        $product = Products::find($request->product_id);

        if (!$cartItem) {
            return self::error([], 'Product not found in cart', 404);
        }

        $updated = $query->update(['quantity' => $request->quantity, 'total' => $request->quantity * $product->price]);

        return  parent::success([$updated], Messages::getMessage("UPDATE_SUCCESS"));
    }
    public function clearCart(Request $request)
    {
        $user = $request->user();

        $query = DB::table('carts');

        if ($user) {
            $query->where('user_id', $user->id);
        } elseif ($request->has('cookie_id')) {
            $query->where('cookie_id', $request->cookie_id);
        } else {
            return self::error([], 'User ID or Cookie ID is required', 400);
        }

        $deleted = $query->delete();

        return self::success([$deleted], 'Cart cleared successfully');
    }
}
