<?php

namespace App\Http\Controllers\API\V1\Auth;

use App\Http\Controllers\API\V1\Auth\AuthBaseController;
use App\Http\Requests\Auth\LoginRequest as AuthLoginRequest;
use App\Http\Requests\LoginRequest;
// use App\Http\Requests\Auth\RegisterRequest;
use App\Http\Requests\SubmitCodeRequest;
use App\Http\Requests\UpdateProfileRequest;
use App\Services\AuthenticationService;
use Illuminate\Http\Request;

class AuthController extends AuthBaseController
{
    public function login(AuthLoginRequest $loginRequest)
    {
        // return AuthenticationService::login($loginRequest->loginData());
        //  return $loginRequest['email'];
          return AuthenticationService::login(['email' => $loginRequest['email'], 'password' => $loginRequest['password']]);
    }
     public function verifyCode(Request $request)
    {
        // return AuthenticationService::login($loginRequest->loginData());
        //  return $loginRequest['email'];
          return AuthenticationService::verifyCode($request);
    }

    // public function register(RegisterRequest $registerRequest)
    // {
    //     return AuthenticationService::register($registerRequest->registerData());
    // }
     public function register(Request $request)
    {
        return AuthenticationService::register($request->all());
    }

    public function submitCode(SubmitCodeRequest $submitCodeRequest)
    {
        return AuthenticationService::submitCode($submitCodeRequest->validated());
    }

    public function show()
    {
        return AuthenticationService::show();
    }

    public function update(UpdateProfileRequest $updateProfileRequest)
    {
        return AuthenticationService::update($updateProfileRequest->profileData());
    }

    public function destory()
    {
        return AuthenticationService::destory();
    }
}
