<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Products;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Throwable;

class ProductController extends Controller
{
    /**
     * Handle the incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function __invoke(Request $request)
    {
        
       return parent::error("يرجى التأكد من البيانات المطلوبة", $validator->errors()->first());
        try {
            if ($request->header('Shabaka-EM-AMEN') != '4tyJG86m5rqaGKBrXkQKwYixqJtNzDfmiwJuupCwg0uzXIaDkaJDoNmjSicw-AMEN') {
                return response()->json([
                    'massage' => 'لا يمكن أتمام العملية بسبب حدوث خطأ ما',
                    'status' => false,
                    'data' => null,
                ], 401);
            }

            $roles = [
                'data' => "required",
                'data.*.sku' => "required",
                'data.*.quantity' => "required|numeric",
            ];
            $customMessages = [
                'data.*.quantity.sku' => 'يرجى أدخال ال sku',
                'data.*.quantity.required' => 'يرجى أدخال الكمية',
                'data.*.quantity.numeric' => 'يجب أن تكون الكمية رقم',
            ];
            $validator = Validator::make($request->all(), $roles, $customMessages);
            if ($validator->fails()) {
                return parent::error("يرجى التأكد من البيانات المطلوبة", $validator->errors()->first());
            }
            $countSuccss = 0;
            $countErorr = 0;
            foreach ($request->data as  $row) {
                $product = Products::with('categories')->where('sku', $row['sku'])->first();
                if ($product) {
                    $countSuccss += 1;
                    $product->update([
                        "quantity" => $row['quantity']
                    ]);
                } else {
                    $countErorr += 1;
                }
            }
            return parent::success(["The number of modified products" => $countSuccss, "The number of products that have not been modified" => $countErorr], "تمت العملية بنجاح");
        } catch (Throwable $e) {
            return parent::error("حدث خطأ ما", $e->getMessage());
        }
    }
}
