<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Order;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Throwable;

class OrderController extends Controller
{
    public function index(Request $request)
    {
        
        try {
            if ($request->header('Shabaka-EM-AMEN') != '4tyJG86m5rqaGKBrXkQKwYixqJtNzDfmiwJuupCwg0uzXIaDkaJDoNmjSicw-AMEN') {
                return response()->json([
                    'massage' => 'لا يمكن أتمام العملية بسبب حدوث خطأ ما',
                    'status' => false,
                    'data' => null,
                ], 401);
            }
          
            $orders = Order::when($request->filled("form"), function ($builder) use ($request) {
                $builder->whereDate('created_at', '>=', $request->input('form'));
            })->when($request->filled("to"), function ($builder) use ($request) {
                $builder->whereDate('created_at', '<=', $request->input('to'));
            })->with(['user', 'products', 'addresses.cities.countries'])->where("payment_status","paid")->orderBy('id', 'desc')->get();
            
            return parent::success($orders, "تمت العملية بنجاح");
        } catch (Throwable $e) {
            return parent::error("حدث خطأ ما", $e->getMessage());
        }
    }

    public function show(Request $request)
    {
        try {
            if ($request->header('Shabaka-EM-AMEN') != '4tyJG86m5rqaGKBrXkQKwYixqJtNzDfmiwJuupCwg0uzXIaDkaJDoNmjSicw-AMEN') {
                return response()->json([
                    'massage' => 'لا يمكن أتمام العملية بسبب حدوث خطأ ما',
                    'status' => false,
                    'data' => null,
                ], 401);
            }

            $roles = [
                'id' => "required",
            ];
            $customMessages = [
                'id.required' => 'يرجى أدخال رقم الطلب',
            ];
            $validator = Validator::make($request->all(), $roles, $customMessages);
            if ($validator->fails()) {
                return parent::error("يرجى التأكد من البيانات المطلوبة", $validator->errors()->first());
            }

            $order = Order::with(['user', 'products', 'addresses.cities.countries'])->find($request->id);
            return parent::success($order, "تمت العملية بنجاح");
        } catch (Throwable $e) {
            return parent::error("حدث خطأ ما", $e->getMessage());
        }
    }
}
