<?php
$pdo = new PDO("mysql:host=localhost;dbname=cujzkrmy_ads_tracking;charset=utf8", 'cujzkrmy_addser', 'Da@1020304050');
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// تعريف الفلاتر
$where = 'WHERE 1';
$params = [];

if (isset($_GET['filter']) && $_GET['filter'] === 'today') {
    $where .= " AND DATE(created_at) = CURDATE()";
} elseif (isset($_GET['filter']) && $_GET['filter'] === 'month') {
    $where .= " AND MONTH(created_at) = MONTH(CURDATE()) AND YEAR(created_at) = YEAR(CURDATE())";
} elseif (
    isset($_GET['filter']) && $_GET['filter'] === 'range' &&
    !empty($_GET['from']) && !empty($_GET['to'])
) {
    $where .= " AND DATE(created_at) BETWEEN ? AND ?";
    $params[] = $_GET['from'];
    $params[] = $_GET['to'];
}

// السوشال ميديا
$platforms = ['snap', 'instagram', 'tiktok' ,'facebook','linked','twitter'];

// النتائج
$results = [];

foreach ($platforms as $platform) {
    // whatsapp
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM tracks $where AND type_socail = ? AND type_action = 'whatsapp'");
    $stmt->execute(array_merge($params, [$platform]));
    $results['whatsapp'][$platform] = $stmt->fetchColumn();

    // map
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM tracks $where AND type_socail = ? AND type_action = 'map'");
    $stmt->execute(array_merge($params, [$platform]));
    $results['map'][$platform] = $stmt->fetchColumn();
}
?>

<!DOCTYPE html>
<html lang="ar">

<head>
    <meta charset="UTF-8">
    <title>إحصائيات النقرات</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body class="p-4" style="direction: rtl;">

  <div class="conatainer text-center">
        <h3>📊 الإحصائيات حسب السوشال ميديا</h3>

        <form method="GET" class="row g-2 mb-4  mt-5    justify-content-center">
            <div class="col-auto">
                <select name="filter" class="form-select" onchange="toggleRange(this.value)">
                    <option value="">فلترة حسب الوقت</option>
                    <option value="today" <?= ($_GET['filter'] ?? '') === 'today' ? 'selected' : '' ?>>اليوم</option>
                    <option value="month" <?= ($_GET['filter'] ?? '') === 'month' ? 'selected' : '' ?>>هذا الشهر</option>
                    <option value="range" <?= ($_GET['filter'] ?? '') === 'range' ? 'selected' : '' ?>>من تاريخ إلى تاريخ</option>
                </select>
            </div>
            <div class="col-auto">
                <input type="date" name="from" id="from" class="form-control" value="<?= $_GET['from'] ?? '' ?>">
            </div>
            <div class="col-auto">
                <input type="date" name="to" id="to" class="form-control" value="<?= $_GET['to'] ?? '' ?>">
            </div>
            <div class="col-auto">
                <button class="btn btn-primary">تطبيق الفلتر</button>
            </div>
        </form>
    </div>

    <script>
        function toggleRange(value) {
            const from = document.getElementById('from');
            const to = document.getElementById('to');
            const isRange = value === 'range';
            from.disabled = !isRange;
            to.disabled = !isRange;
        }
        toggleRange("<?= $_GET['filter'] ?? '' ?>");
    </script>

   <div class="container">
         <div class="row justify-content-center">
        <div class="col-md-7 mt-3">
            <h4>📞 عدد ضغطات واتساب</h4>
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th>المنصة</th>
                        <th>عدد الضغطات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($results['whatsapp'] as $platform => $count): ?>
                        <tr>
                            <td><?= $platform ?></td>
                            <td><?= $count ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <div class="col-md-7 mt-3">
            <h4>📍 عدد ضغطات الموقع (Map)</h4>
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th>المنصة</th>
                        <th>عدد الضغطات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($results['map'] as $platform => $count): ?>
                        <tr>
                            <td><?= $platform ?></td>
                            <td><?= $count ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
   </div>

</body>

</html>